<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VirtualCard Structs
 * @subpackage Structs
 */
class VirtualCard extends AbstractStructBase
{
    /**
     * The CustomerAccountCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $CustomerAccountCode;
    /**
     * The BNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BNumber;
    /**
     * The Transactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Transactions
     */
    public $Transactions;
    /**
     * Constructor method for VirtualCard
     * @uses VirtualCard::setCustomerAccountCode()
     * @uses VirtualCard::setBNumber()
     * @uses VirtualCard::setTransactions()
     * @param string $customerAccountCode
     * @param string $bNumber
     * @param \Sabre\TravelItineraryRead\Structs\Transactions $transactions
     */
    public function __construct($customerAccountCode = null, $bNumber = null, \Sabre\TravelItineraryRead\Structs\Transactions $transactions = null)
    {
        $this
            ->setCustomerAccountCode($customerAccountCode)
            ->setBNumber($bNumber)
            ->setTransactions($transactions);
    }
    /**
     * Get CustomerAccountCode value
     * @return string
     */
    public function getCustomerAccountCode()
    {
        return $this->CustomerAccountCode;
    }
    /**
     * Set CustomerAccountCode value
     * @param string $customerAccountCode
     * @return \Sabre\TravelItineraryRead\Structs\VirtualCard
     */
    public function setCustomerAccountCode($customerAccountCode = null)
    {
        $this->CustomerAccountCode = $customerAccountCode;
        return $this;
    }
    /**
     * Get BNumber value
     * @return string|null
     */
    public function getBNumber()
    {
        return $this->BNumber;
    }
    /**
     * Set BNumber value
     * @param string $bNumber
     * @return \Sabre\TravelItineraryRead\Structs\VirtualCard
     */
    public function setBNumber($bNumber = null)
    {
        $this->BNumber = $bNumber;
        return $this;
    }
    /**
     * Get Transactions value
     * @return \Sabre\TravelItineraryRead\Structs\Transactions|null
     */
    public function getTransactions()
    {
        return $this->Transactions;
    }
    /**
     * Set Transactions value
     * @param \Sabre\TravelItineraryRead\Structs\Transactions $transactions
     * @return \Sabre\TravelItineraryRead\Structs\VirtualCard
     */
    public function setTransactions(\Sabre\TravelItineraryRead\Structs\Transactions $transactions = null)
    {
        $this->Transactions = $transactions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\VirtualCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
