<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TourDetails Structs
 * @subpackage Structs
 */
class TourDetails extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the confirmation number associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ConfirmationNumber;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Duration[]
     */
    public $Duration;
    /**
     * The Extensions
     * Meta informations extracted from the WSDL
     * - documentation: "Extensions" is used to return extension-related information associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Extensions;
    /**
     * The Features
     * Meta informations extracted from the WSDL
     * - documentation: "Features" is used to return feature-related information associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Features;
    /**
     * The HotelInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\HotelInformation
     */
    public $HotelInformation;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - documentation: "Location" is used to return location-related information associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Location;
    /**
     * The Meals
     * Meta informations extracted from the WSDL
     * - documentation: "Meals" is used to return meal-related information associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Meals;
    /**
     * The Options
     * Meta informations extracted from the WSDL
     * - documentation: "Options" is used to return option-related information associated with the particular tour reservation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Options;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Price[]
     */
    public $Price;
    /**
     * The ServiceInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ServiceInformation
     */
    public $ServiceInformation;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous tour-related information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Text;
    /**
     * The VehicleInformation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\VehicleInformation
     */
    public $VehicleInformation;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the location code associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - documentation: "Name" is used to return the name associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return number associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The ServiceCityName
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceCityName" is used to return the service city name associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $ServiceCityName;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - documentation: "Vendor" is used to return the tour vendor code associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $Vendor;
    /**
     * Constructor method for TourDetails
     * @uses TourDetails::setConfirmationNumber()
     * @uses TourDetails::setDuration()
     * @uses TourDetails::setExtensions()
     * @uses TourDetails::setFeatures()
     * @uses TourDetails::setHotelInformation()
     * @uses TourDetails::setLocation()
     * @uses TourDetails::setMeals()
     * @uses TourDetails::setOptions()
     * @uses TourDetails::setPrice()
     * @uses TourDetails::setServiceInformation()
     * @uses TourDetails::setText()
     * @uses TourDetails::setVehicleInformation()
     * @uses TourDetails::setLocationCode()
     * @uses TourDetails::setName()
     * @uses TourDetails::setNumber()
     * @uses TourDetails::setServiceCityName()
     * @uses TourDetails::setVendor()
     * @param string[] $confirmationNumber
     * @param \Sabre\TravelItineraryRead\Structs\Duration[] $duration
     * @param string[] $extensions
     * @param string[] $features
     * @param \Sabre\TravelItineraryRead\Structs\HotelInformation $hotelInformation
     * @param string[] $location
     * @param string[] $meals
     * @param string[] $options
     * @param \Sabre\TravelItineraryRead\Structs\Price[] $price
     * @param \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation
     * @param string[] $text
     * @param \Sabre\TravelItineraryRead\Structs\VehicleInformation $vehicleInformation
     * @param string $locationCode
     * @param string $name
     * @param string $number
     * @param string $serviceCityName
     * @param string $vendor
     */
    public function __construct(array $confirmationNumber = array(), array $duration = array(), array $extensions = array(), array $features = array(), \Sabre\TravelItineraryRead\Structs\HotelInformation $hotelInformation = null, array $location = array(), array $meals = array(), array $options = array(), array $price = array(), \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation = null, array $text = array(), \Sabre\TravelItineraryRead\Structs\VehicleInformation $vehicleInformation = null, $locationCode = null, $name = null, $number = null, $serviceCityName = null, $vendor = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setDuration($duration)
            ->setExtensions($extensions)
            ->setFeatures($features)
            ->setHotelInformation($hotelInformation)
            ->setLocation($location)
            ->setMeals($meals)
            ->setOptions($options)
            ->setPrice($price)
            ->setServiceInformation($serviceInformation)
            ->setText($text)
            ->setVehicleInformation($vehicleInformation)
            ->setLocationCode($locationCode)
            ->setName($name)
            ->setNumber($number)
            ->setServiceCityName($serviceCityName)
            ->setVendor($vendor);
    }
    /**
     * Get ConfirmationNumber value
     * @return string[]|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string[] $confirmationNumber
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setConfirmationNumber(array $confirmationNumber = array())
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Add item to ConfirmationNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToConfirmationNumber($item)
    {
        $this->ConfirmationNumber[] = $item;
        return $this;
    }
    /**
     * Get Duration value
     * @return \Sabre\TravelItineraryRead\Structs\Duration[]|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Duration[] $duration
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setDuration(array $duration = array())
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Add item to Duration value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Duration $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToDuration(\Sabre\TravelItineraryRead\Structs\Duration $item)
    {
        $this->Duration[] = $item;
        return $this;
    }
    /**
     * Get Extensions value
     * @return string[]|null
     */
    public function getExtensions()
    {
        return $this->Extensions;
    }
    /**
     * Set Extensions value
     * @throws \InvalidArgumentException
     * @param string[] $extensions
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setExtensions(array $extensions = array())
    {
        $this->Extensions = $extensions;
        return $this;
    }
    /**
     * Add item to Extensions value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToExtensions($item)
    {
        $this->Extensions[] = $item;
        return $this;
    }
    /**
     * Get Features value
     * @return string[]|null
     */
    public function getFeatures()
    {
        return $this->Features;
    }
    /**
     * Set Features value
     * @throws \InvalidArgumentException
     * @param string[] $features
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setFeatures(array $features = array())
    {
        $this->Features = $features;
        return $this;
    }
    /**
     * Add item to Features value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToFeatures($item)
    {
        $this->Features[] = $item;
        return $this;
    }
    /**
     * Get HotelInformation value
     * @return \Sabre\TravelItineraryRead\Structs\HotelInformation|null
     */
    public function getHotelInformation()
    {
        return $this->HotelInformation;
    }
    /**
     * Set HotelInformation value
     * @param \Sabre\TravelItineraryRead\Structs\HotelInformation $hotelInformation
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setHotelInformation(\Sabre\TravelItineraryRead\Structs\HotelInformation $hotelInformation = null)
    {
        $this->HotelInformation = $hotelInformation;
        return $this;
    }
    /**
     * Get Location value
     * @return string[]|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @throws \InvalidArgumentException
     * @param string[] $location
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setLocation(array $location = array())
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Add item to Location value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToLocation($item)
    {
        $this->Location[] = $item;
        return $this;
    }
    /**
     * Get Meals value
     * @return string[]|null
     */
    public function getMeals()
    {
        return $this->Meals;
    }
    /**
     * Set Meals value
     * @throws \InvalidArgumentException
     * @param string[] $meals
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setMeals(array $meals = array())
    {
        $this->Meals = $meals;
        return $this;
    }
    /**
     * Add item to Meals value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToMeals($item)
    {
        $this->Meals[] = $item;
        return $this;
    }
    /**
     * Get Options value
     * @return string[]|null
     */
    public function getOptions()
    {
        return $this->Options;
    }
    /**
     * Set Options value
     * @throws \InvalidArgumentException
     * @param string[] $options
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setOptions(array $options = array())
    {
        $this->Options = $options;
        return $this;
    }
    /**
     * Add item to Options value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToOptions($item)
    {
        $this->Options[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \Sabre\TravelItineraryRead\Structs\Price[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Price[] $price
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setPrice(array $price = array())
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Price $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToPrice(\Sabre\TravelItineraryRead\Structs\Price $item)
    {
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get ServiceInformation value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceInformation|null
     */
    public function getServiceInformation()
    {
        return $this->ServiceInformation;
    }
    /**
     * Set ServiceInformation value
     * @param \Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setServiceInformation(\Sabre\TravelItineraryRead\Structs\ServiceInformation $serviceInformation = null)
    {
        $this->ServiceInformation = $serviceInformation;
        return $this;
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setText(array $text = array())
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function addToText($item)
    {
        $this->Text[] = $item;
        return $this;
    }
    /**
     * Get VehicleInformation value
     * @return \Sabre\TravelItineraryRead\Structs\VehicleInformation|null
     */
    public function getVehicleInformation()
    {
        return $this->VehicleInformation;
    }
    /**
     * Set VehicleInformation value
     * @param \Sabre\TravelItineraryRead\Structs\VehicleInformation $vehicleInformation
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setVehicleInformation(\Sabre\TravelItineraryRead\Structs\VehicleInformation $vehicleInformation = null)
    {
        $this->VehicleInformation = $vehicleInformation;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setLocationCode($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get ServiceCityName value
     * @return string|null
     */
    public function getServiceCityName()
    {
        return $this->ServiceCityName;
    }
    /**
     * Set ServiceCityName value
     * @param string $serviceCityName
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setServiceCityName($serviceCityName = null)
    {
        $this->ServiceCityName = $serviceCityName;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TourDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
