<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Taxes Structs
 * Meta informations extracted from the WSDL
 * - documentation: Taxes is used as a container for Tax details. It holds the details for GST, QST and Tax. For GST information about amount, Currency code and Percentage is present for QST and Tax along with information about amount, Currency code,
 * Percentage Tax code details is also included. | "Taxes" is used to reflect the total tax details | "Taxes" is used to reflect the total tax details | Taxes is used to reflect the total tax details | "Taxes" element is used as container for taxes
 * associated with particular ancillary.
 * @subpackage Structs
 */
class Taxes extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryTax[]
     */
    public $Tax;
    /**
     * The GST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\GST
     */
    public $GST;
    /**
     * The QST
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\QST
     */
    public $QST;
    /**
     * The TotalAmount
     * Meta informations extracted from the WSDL
     * - documentation: "TotalAmount" is used to return the applicable amount. | "TotalAmount" is used to return the applicable amount.
     * - use: optional
     * @var string
     */
    public $TotalAmount;
    /**
     * The TaxBreakdownCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TaxBreakdownCode[]
     */
    public $TaxBreakdownCode;
    /**
     * Constructor method for Taxes
     * @uses Taxes::setTax()
     * @uses Taxes::setGST()
     * @uses Taxes::setQST()
     * @uses Taxes::setTotalAmount()
     * @uses Taxes::setTaxBreakdownCode()
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryTax[] $tax
     * @param \Sabre\TravelItineraryRead\Structs\GST $gST
     * @param \Sabre\TravelItineraryRead\Structs\QST $qST
     * @param string $totalAmount
     * @param \Sabre\TravelItineraryRead\Structs\TaxBreakdownCode[] $taxBreakdownCode
     */
    public function __construct(array $tax = array(), \Sabre\TravelItineraryRead\Structs\GST $gST = null, \Sabre\TravelItineraryRead\Structs\QST $qST = null, $totalAmount = null, array $taxBreakdownCode = array())
    {
        $this
            ->setTax($tax)
            ->setGST($gST)
            ->setQST($qST)
            ->setTotalAmount($totalAmount)
            ->setTaxBreakdownCode($taxBreakdownCode);
    }
    /**
     * Get Tax value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryTax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryTax[] $tax
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryTax $item
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function addToTax(\Sabre\TravelItineraryRead\Structs\AncillaryTax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get GST value
     * @return \Sabre\TravelItineraryRead\Structs\GST|null
     */
    public function getGST()
    {
        return $this->GST;
    }
    /**
     * Set GST value
     * @param \Sabre\TravelItineraryRead\Structs\GST $gST
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function setGST(\Sabre\TravelItineraryRead\Structs\GST $gST = null)
    {
        $this->GST = $gST;
        return $this;
    }
    /**
     * Get QST value
     * @return \Sabre\TravelItineraryRead\Structs\QST|null
     */
    public function getQST()
    {
        return $this->QST;
    }
    /**
     * Set QST value
     * @param \Sabre\TravelItineraryRead\Structs\QST $qST
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function setQST(\Sabre\TravelItineraryRead\Structs\QST $qST = null)
    {
        $this->QST = $qST;
        return $this;
    }
    /**
     * Get TotalAmount value
     * @return string|null
     */
    public function getTotalAmount()
    {
        return $this->TotalAmount;
    }
    /**
     * Set TotalAmount value
     * @param string $totalAmount
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function setTotalAmount($totalAmount = null)
    {
        $this->TotalAmount = $totalAmount;
        return $this;
    }
    /**
     * Get TaxBreakdownCode value
     * @return \Sabre\TravelItineraryRead\Structs\TaxBreakdownCode[]|null
     */
    public function getTaxBreakdownCode()
    {
        return $this->TaxBreakdownCode;
    }
    /**
     * Set TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TaxBreakdownCode[] $taxBreakdownCode
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function setTaxBreakdownCode(array $taxBreakdownCode = array())
    {
        $this->TaxBreakdownCode = $taxBreakdownCode;
        return $this;
    }
    /**
     * Add item to TaxBreakdownCode value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TaxBreakdownCode $item
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public function addToTaxBreakdownCode(\Sabre\TravelItineraryRead\Structs\TaxBreakdownCode $item)
    {
        $this->TaxBreakdownCode[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
