<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tax Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Tax" returns the individual Tax details | "Tax' returns the individual Tax details
 * @subpackage Structs
 */
class Tax extends AccountingTransactionAmountWithRule
{
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $code;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Id
     * @var string
     */
    public $Id;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable amount. | "Amount" is used to return the applicable tax amount
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The TaxCode
     * Meta informations extracted from the WSDL
     * - documentation: "TaxCode" is used to return the applicable tax code.
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The Exempt
     * Meta informations extracted from the WSDL
     * - documentation: "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt | "Exempt" is used to indicate whether or not the itinerary is classified as tax exempt
     * - use: optional
     * @var bool
     */
    public $Exempt;
    /**
     * The TaxAmount
     * @var float
     */
    public $TaxAmount;
    /**
     * Constructor method for Tax
     * @uses Tax::setCode()
     * @uses Tax::set_()
     * @uses Tax::setId()
     * @uses Tax::setAmount()
     * @uses Tax::setCurrencyCode()
     * @uses Tax::setPercent()
     * @uses Tax::setTaxCode()
     * @uses Tax::setExempt()
     * @uses Tax::setTaxAmount()
     * @param string $code
     * @param string $_
     * @param string $id
     * @param string $amount
     * @param string $currencyCode
     * @param string $percent
     * @param string $taxCode
     * @param bool $exempt
     * @param float $taxAmount
     */
    public function __construct($code = null, $_ = null, $id = null, $amount = null, $currencyCode = null, $percent = null, $taxCode = null, $exempt = null, $taxAmount = null)
    {
        $this
            ->setCode($code)
            ->set_($_)
            ->setId($id)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setPercent($percent)
            ->setTaxCode($taxCode)
            ->setExempt($exempt)
            ->setTaxAmount($taxAmount);
    }
    /**
     * Get code value
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setTaxCode($taxCode = null)
    {
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get Exempt value
     * @return bool|null
     */
    public function getExempt()
    {
        return $this->Exempt;
    }
    /**
     * Set Exempt value
     * @param bool $exempt
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setExempt($exempt = null)
    {
        $this->Exempt = $exempt;
        return $this;
    }
    /**
     * Get TaxAmount value
     * @return float|null
     */
    public function getTaxAmount()
    {
        return $this->TaxAmount;
    }
    /**
     * Set TaxAmount value
     * @param float $taxAmount
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public function setTaxAmount($taxAmount = null)
    {
        $this->TaxAmount = $taxAmount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Tax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
