<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SignatureMethodType Structs
 * Meta informations extracted from the WSDL
 * - mixed: true
 * @subpackage Structs
 */
class SignatureMethodType extends AbstractStructBase
{
    /**
     * The Algorithm
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Algorithm;
    /**
     * The HMACOutputLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $HMACOutputLength;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SignatureMethodType
     * @uses SignatureMethodType::setAlgorithm()
     * @uses SignatureMethodType::setHMACOutputLength()
     * @uses SignatureMethodType::setAny()
     * @param string $algorithm
     * @param int $hMACOutputLength
     * @param \DOMDocument $any
     */
    public function __construct($algorithm = null, $hMACOutputLength = null, \DOMDocument $any = null)
    {
        $this
            ->setAlgorithm($algorithm)
            ->setHMACOutputLength($hMACOutputLength)
            ->setAny($any);
    }
    /**
     * Get Algorithm value
     * @return string
     */
    public function getAlgorithm()
    {
        return $this->Algorithm;
    }
    /**
     * Set Algorithm value
     * @param string $algorithm
     * @return \Sabre\TravelItineraryRead\Structs\SignatureMethodType
     */
    public function setAlgorithm($algorithm = null)
    {
        $this->Algorithm = $algorithm;
        return $this;
    }
    /**
     * Get HMACOutputLength value
     * @return int|null
     */
    public function getHMACOutputLength()
    {
        return $this->HMACOutputLength;
    }
    /**
     * Set HMACOutputLength value
     * @param int $hMACOutputLength
     * @return \Sabre\TravelItineraryRead\Structs\SignatureMethodType
     */
    public function setHMACOutputLength($hMACOutputLength = null)
    {
        $this->HMACOutputLength = $hMACOutputLength;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \Sabre\TravelItineraryRead\Structs\SignatureMethodType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \Sabre\TravelItineraryRead\Structs\SignatureMethodType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\SignatureMethodType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
