<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ServiceRefType Structs
 * @subpackage Structs
 */
class ServiceRefType extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Description[]
     */
    public $Description;
    /**
     * The PassengerReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerReferences
     */
    public $PassengerReferences;
    /**
     * The Accommodation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Accommodation;
    /**
     * The Occupancy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Occupancy;
    /**
     * The NoOfServices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NoOfServices;
    /**
     * The TravellerAllocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravellerAllocation;
    /**
     * The ServicePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PriceType
     */
    public $ServicePrice;
    /**
     * The StealBoarding
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StealBoarding;
    /**
     * The id
     * @var string
     */
    public $id;
    /**
     * The productCategory
     * Meta informations extracted from the WSDL
     * - documentation: eg. TruTrip, passive, high level source/type
     * @var string
     */
    public $productCategory;
    /**
     * The productType
     * @var string
     */
    public $productType;
    /**
     * The vendorCode
     * @var string
     */
    public $vendorCode;
    /**
     * The statusCode
     * @var string
     */
    public $statusCode;
    /**
     * The previousStatusCode
     * @var string
     */
    public $previousStatusCode;
    /**
     * The startPoint
     * @var string
     */
    public $startPoint;
    /**
     * The startDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $startDateTime;
    /**
     * The endPoint
     * @var string
     */
    public $endPoint;
    /**
     * The endDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $endDateTime;
    /**
     * The normalizedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: when equals to "true" means this data has been normalized with Normalized Service
     * @var bool
     */
    public $normalizedIndicator;
    /**
     * The numberInParty
     * @var int
     */
    public $numberInParty;
    /**
     * Constructor method for ServiceRefType
     * @uses ServiceRefType::setDescription()
     * @uses ServiceRefType::setPassengerReferences()
     * @uses ServiceRefType::setAccommodation()
     * @uses ServiceRefType::setOccupancy()
     * @uses ServiceRefType::setNoOfServices()
     * @uses ServiceRefType::setTravellerAllocation()
     * @uses ServiceRefType::setServicePrice()
     * @uses ServiceRefType::setStealBoarding()
     * @uses ServiceRefType::setId()
     * @uses ServiceRefType::setProductCategory()
     * @uses ServiceRefType::setProductType()
     * @uses ServiceRefType::setVendorCode()
     * @uses ServiceRefType::setStatusCode()
     * @uses ServiceRefType::setPreviousStatusCode()
     * @uses ServiceRefType::setStartPoint()
     * @uses ServiceRefType::setStartDateTime()
     * @uses ServiceRefType::setEndPoint()
     * @uses ServiceRefType::setEndDateTime()
     * @uses ServiceRefType::setNormalizedIndicator()
     * @uses ServiceRefType::setNumberInParty()
     * @param \Sabre\TravelItineraryRead\Structs\Description[] $description
     * @param \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences
     * @param string $accommodation
     * @param string $occupancy
     * @param int $noOfServices
     * @param string $travellerAllocation
     * @param \Sabre\TravelItineraryRead\Structs\PriceType $servicePrice
     * @param string $stealBoarding
     * @param string $id
     * @param string $productCategory
     * @param string $productType
     * @param string $vendorCode
     * @param string $statusCode
     * @param string $previousStatusCode
     * @param string $startPoint
     * @param string $startDateTime
     * @param string $endPoint
     * @param string $endDateTime
     * @param bool $normalizedIndicator
     * @param int $numberInParty
     */
    public function __construct(array $description = array(), \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences = null, $accommodation = null, $occupancy = null, $noOfServices = null, $travellerAllocation = null, \Sabre\TravelItineraryRead\Structs\PriceType $servicePrice = null, $stealBoarding = null, $id = null, $productCategory = null, $productType = null, $vendorCode = null, $statusCode = null, $previousStatusCode = null, $startPoint = null, $startDateTime = null, $endPoint = null, $endDateTime = null, $normalizedIndicator = null, $numberInParty = null)
    {
        $this
            ->setDescription($description)
            ->setPassengerReferences($passengerReferences)
            ->setAccommodation($accommodation)
            ->setOccupancy($occupancy)
            ->setNoOfServices($noOfServices)
            ->setTravellerAllocation($travellerAllocation)
            ->setServicePrice($servicePrice)
            ->setStealBoarding($stealBoarding)
            ->setId($id)
            ->setProductCategory($productCategory)
            ->setProductType($productType)
            ->setVendorCode($vendorCode)
            ->setStatusCode($statusCode)
            ->setPreviousStatusCode($previousStatusCode)
            ->setStartPoint($startPoint)
            ->setStartDateTime($startDateTime)
            ->setEndPoint($endPoint)
            ->setEndDateTime($endDateTime)
            ->setNormalizedIndicator($normalizedIndicator)
            ->setNumberInParty($numberInParty);
    }
    /**
     * Get Description value
     * @return \Sabre\TravelItineraryRead\Structs\Description[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Description[] $description
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setDescription(array $description = array())
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Description $item
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function addToDescription(\Sabre\TravelItineraryRead\Structs\Description $item)
    {
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get PassengerReferences value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerReferences|null
     */
    public function getPassengerReferences()
    {
        return $this->PassengerReferences;
    }
    /**
     * Set PassengerReferences value
     * @param \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setPassengerReferences(\Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences = null)
    {
        $this->PassengerReferences = $passengerReferences;
        return $this;
    }
    /**
     * Get Accommodation value
     * @return string|null
     */
    public function getAccommodation()
    {
        return $this->Accommodation;
    }
    /**
     * Set Accommodation value
     * @param string $accommodation
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setAccommodation($accommodation = null)
    {
        $this->Accommodation = $accommodation;
        return $this;
    }
    /**
     * Get Occupancy value
     * @return string|null
     */
    public function getOccupancy()
    {
        return $this->Occupancy;
    }
    /**
     * Set Occupancy value
     * @param string $occupancy
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setOccupancy($occupancy = null)
    {
        $this->Occupancy = $occupancy;
        return $this;
    }
    /**
     * Get NoOfServices value
     * @return int|null
     */
    public function getNoOfServices()
    {
        return $this->NoOfServices;
    }
    /**
     * Set NoOfServices value
     * @param int $noOfServices
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setNoOfServices($noOfServices = null)
    {
        $this->NoOfServices = $noOfServices;
        return $this;
    }
    /**
     * Get TravellerAllocation value
     * @return string|null
     */
    public function getTravellerAllocation()
    {
        return $this->TravellerAllocation;
    }
    /**
     * Set TravellerAllocation value
     * @param string $travellerAllocation
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setTravellerAllocation($travellerAllocation = null)
    {
        $this->TravellerAllocation = $travellerAllocation;
        return $this;
    }
    /**
     * Get ServicePrice value
     * @return \Sabre\TravelItineraryRead\Structs\PriceType|null
     */
    public function getServicePrice()
    {
        return $this->ServicePrice;
    }
    /**
     * Set ServicePrice value
     * @param \Sabre\TravelItineraryRead\Structs\PriceType $servicePrice
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setServicePrice(\Sabre\TravelItineraryRead\Structs\PriceType $servicePrice = null)
    {
        $this->ServicePrice = $servicePrice;
        return $this;
    }
    /**
     * Get StealBoarding value
     * @return string|null
     */
    public function getStealBoarding()
    {
        return $this->StealBoarding;
    }
    /**
     * Set StealBoarding value
     * @param string $stealBoarding
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setStealBoarding($stealBoarding = null)
    {
        $this->StealBoarding = $stealBoarding;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get productCategory value
     * @return string|null
     */
    public function getProductCategory()
    {
        return $this->productCategory;
    }
    /**
     * Set productCategory value
     * @param string $productCategory
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setProductCategory($productCategory = null)
    {
        $this->productCategory = $productCategory;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get vendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->vendorCode;
    }
    /**
     * Set vendorCode value
     * @param string $vendorCode
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->vendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get previousStatusCode value
     * @return string|null
     */
    public function getPreviousStatusCode()
    {
        return $this->previousStatusCode;
    }
    /**
     * Set previousStatusCode value
     * @param string $previousStatusCode
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setPreviousStatusCode($previousStatusCode = null)
    {
        $this->previousStatusCode = $previousStatusCode;
        return $this;
    }
    /**
     * Get startPoint value
     * @return string|null
     */
    public function getStartPoint()
    {
        return $this->startPoint;
    }
    /**
     * Set startPoint value
     * @param string $startPoint
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setStartPoint($startPoint = null)
    {
        $this->startPoint = $startPoint;
        return $this;
    }
    /**
     * Get startDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->startDateTime;
    }
    /**
     * Set startDateTime value
     * @param string $startDateTime
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setStartDateTime($startDateTime = null)
    {
        $this->startDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get endPoint value
     * @return string|null
     */
    public function getEndPoint()
    {
        return $this->endPoint;
    }
    /**
     * Set endPoint value
     * @param string $endPoint
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setEndPoint($endPoint = null)
    {
        $this->endPoint = $endPoint;
        return $this;
    }
    /**
     * Get endDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->endDateTime;
    }
    /**
     * Set endDateTime value
     * @param string $endDateTime
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setEndDateTime($endDateTime = null)
    {
        $this->endDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get normalizedIndicator value
     * @return bool|null
     */
    public function getNormalizedIndicator()
    {
        return $this->normalizedIndicator;
    }
    /**
     * Set normalizedIndicator value
     * @param bool $normalizedIndicator
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setNormalizedIndicator($normalizedIndicator = null)
    {
        $this->normalizedIndicator = $normalizedIndicator;
        return $this;
    }
    /**
     * Get numberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->numberInParty;
    }
    /**
     * Set numberInParty value
     * @param int $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->numberInParty = $numberInParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
