<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SegmentOrTravelPortion Structs
 * @subpackage Structs
 */
class SegmentOrTravelPortion extends AbstractStructBase
{
    /**
     * The AirlineCode
     * @var CommonString
     */
    public $AirlineCode;
    /**
     * The FlightNumber
     * @var CommonString
     */
    public $FlightNumber;
    /**
     * The OperatingFlightNumber
     * @var CommonString
     */
    public $OperatingFlightNumber;
    /**
     * The ClassOfService
     * @var CommonString
     */
    public $ClassOfService;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $DepartureDate;
    /**
     * The BoardPoint
     * @var string
     */
    public $BoardPoint;
    /**
     * The OffPoint
     * @var string
     */
    public $OffPoint;
    /**
     * The EquipmentType
     * @var CommonString
     */
    public $EquipmentType;
    /**
     * The ETicketNumber
     * @var CommonString
     */
    public $ETicketNumber;
    /**
     * The ETicketCoupon
     * @var CommonString
     */
    public $ETicketCoupon;
    /**
     * The EMDNumber
     * @var CommonString
     */
    public $EMDNumber;
    /**
     * The EMDCoupon
     * @var CommonString
     */
    public $EMDCoupon;
    /**
     * The MarketingCarrier
     * @var CommonString
     */
    public $MarketingCarrier;
    /**
     * The OperatingCarrier
     * @var CommonString
     */
    public $OperatingCarrier;
    /**
     * The id
     * @var UniqueIdentifier
     */
    public $id;
    /**
     * The sequence
     * @var Numeric0to99999
     */
    public $sequence;
    /**
     * The advisory
     * @var bool
     */
    public $advisory;
    /**
     * Constructor method for SegmentOrTravelPortion
     * @uses SegmentOrTravelPortion::setAirlineCode()
     * @uses SegmentOrTravelPortion::setFlightNumber()
     * @uses SegmentOrTravelPortion::setOperatingFlightNumber()
     * @uses SegmentOrTravelPortion::setClassOfService()
     * @uses SegmentOrTravelPortion::setDepartureDate()
     * @uses SegmentOrTravelPortion::setBoardPoint()
     * @uses SegmentOrTravelPortion::setOffPoint()
     * @uses SegmentOrTravelPortion::setEquipmentType()
     * @uses SegmentOrTravelPortion::setETicketNumber()
     * @uses SegmentOrTravelPortion::setETicketCoupon()
     * @uses SegmentOrTravelPortion::setEMDNumber()
     * @uses SegmentOrTravelPortion::setEMDCoupon()
     * @uses SegmentOrTravelPortion::setMarketingCarrier()
     * @uses SegmentOrTravelPortion::setOperatingCarrier()
     * @uses SegmentOrTravelPortion::setId()
     * @uses SegmentOrTravelPortion::setSequence()
     * @uses SegmentOrTravelPortion::setAdvisory()
     * @param CommonString $airlineCode
     * @param CommonString $flightNumber
     * @param CommonString $operatingFlightNumber
     * @param CommonString $classOfService
     * @param string $departureDate
     * @param string $boardPoint
     * @param string $offPoint
     * @param CommonString $equipmentType
     * @param CommonString $eTicketNumber
     * @param CommonString $eTicketCoupon
     * @param CommonString $eMDNumber
     * @param CommonString $eMDCoupon
     * @param CommonString $marketingCarrier
     * @param CommonString $operatingCarrier
     * @param UniqueIdentifier $id
     * @param Numeric0to99999 $sequence
     * @param bool $advisory
     */
    public function __construct(CommonString $airlineCode = null, CommonString $flightNumber = null, CommonString $operatingFlightNumber = null, CommonString $classOfService = null, $departureDate = null, $boardPoint = null, $offPoint = null, CommonString $equipmentType = null, CommonString $eTicketNumber = null, CommonString $eTicketCoupon = null, CommonString $eMDNumber = null, CommonString $eMDCoupon = null, CommonString $marketingCarrier = null, CommonString $operatingCarrier = null, UniqueIdentifier $id = null, Numeric0to99999 $sequence = null, $advisory = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setFlightNumber($flightNumber)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setClassOfService($classOfService)
            ->setDepartureDate($departureDate)
            ->setBoardPoint($boardPoint)
            ->setOffPoint($offPoint)
            ->setEquipmentType($equipmentType)
            ->setETicketNumber($eTicketNumber)
            ->setETicketCoupon($eTicketCoupon)
            ->setEMDNumber($eMDNumber)
            ->setEMDCoupon($eMDCoupon)
            ->setMarketingCarrier($marketingCarrier)
            ->setOperatingCarrier($operatingCarrier)
            ->setId($id)
            ->setSequence($sequence)
            ->setAdvisory($advisory);
    }
    /**
     * Get AirlineCode value
     * @return CommonString|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param CommonString $airlineCode
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setAirlineCode(CommonString $airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return CommonString|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param CommonString $flightNumber
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setFlightNumber(CommonString $flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * @return CommonString|null
     */
    public function getOperatingFlightNumber()
    {
        return $this->OperatingFlightNumber;
    }
    /**
     * Set OperatingFlightNumber value
     * @param CommonString $operatingFlightNumber
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setOperatingFlightNumber(CommonString $operatingFlightNumber = null)
    {
        $this->OperatingFlightNumber = $operatingFlightNumber;
        return $this;
    }
    /**
     * Get ClassOfService value
     * @return CommonString|null
     */
    public function getClassOfService()
    {
        return $this->ClassOfService;
    }
    /**
     * Set ClassOfService value
     * @param CommonString $classOfService
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setClassOfService(CommonString $classOfService = null)
    {
        $this->ClassOfService = $classOfService;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setDepartureDate($departureDate = null)
    {
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get BoardPoint value
     * @return string|null
     */
    public function getBoardPoint()
    {
        return $this->BoardPoint;
    }
    /**
     * Set BoardPoint value
     * @param string $boardPoint
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setBoardPoint($boardPoint = null)
    {
        $this->BoardPoint = $boardPoint;
        return $this;
    }
    /**
     * Get OffPoint value
     * @return string|null
     */
    public function getOffPoint()
    {
        return $this->OffPoint;
    }
    /**
     * Set OffPoint value
     * @param string $offPoint
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setOffPoint($offPoint = null)
    {
        $this->OffPoint = $offPoint;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return CommonString|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param CommonString $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setEquipmentType(CommonString $equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get ETicketNumber value
     * @return CommonString|null
     */
    public function getETicketNumber()
    {
        return $this->ETicketNumber;
    }
    /**
     * Set ETicketNumber value
     * @param CommonString $eTicketNumber
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setETicketNumber(CommonString $eTicketNumber = null)
    {
        $this->ETicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get ETicketCoupon value
     * @return CommonString|null
     */
    public function getETicketCoupon()
    {
        return $this->ETicketCoupon;
    }
    /**
     * Set ETicketCoupon value
     * @param CommonString $eTicketCoupon
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setETicketCoupon(CommonString $eTicketCoupon = null)
    {
        $this->ETicketCoupon = $eTicketCoupon;
        return $this;
    }
    /**
     * Get EMDNumber value
     * @return CommonString|null
     */
    public function getEMDNumber()
    {
        return $this->EMDNumber;
    }
    /**
     * Set EMDNumber value
     * @param CommonString $eMDNumber
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setEMDNumber(CommonString $eMDNumber = null)
    {
        $this->EMDNumber = $eMDNumber;
        return $this;
    }
    /**
     * Get EMDCoupon value
     * @return CommonString|null
     */
    public function getEMDCoupon()
    {
        return $this->EMDCoupon;
    }
    /**
     * Set EMDCoupon value
     * @param CommonString $eMDCoupon
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setEMDCoupon(CommonString $eMDCoupon = null)
    {
        $this->EMDCoupon = $eMDCoupon;
        return $this;
    }
    /**
     * Get MarketingCarrier value
     * @return CommonString|null
     */
    public function getMarketingCarrier()
    {
        return $this->MarketingCarrier;
    }
    /**
     * Set MarketingCarrier value
     * @param CommonString $marketingCarrier
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setMarketingCarrier(CommonString $marketingCarrier = null)
    {
        $this->MarketingCarrier = $marketingCarrier;
        return $this;
    }
    /**
     * Get OperatingCarrier value
     * @return CommonString|null
     */
    public function getOperatingCarrier()
    {
        return $this->OperatingCarrier;
    }
    /**
     * Set OperatingCarrier value
     * @param CommonString $operatingCarrier
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setOperatingCarrier(CommonString $operatingCarrier = null)
    {
        $this->OperatingCarrier = $operatingCarrier;
        return $this;
    }
    /**
     * Get id value
     * @return UniqueIdentifier|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param UniqueIdentifier $id
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setId(UniqueIdentifier $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get sequence value
     * @return Numeric0to99999|null
     */
    public function getSequence()
    {
        return $this->sequence;
    }
    /**
     * Set sequence value
     * @param Numeric0to99999 $sequence
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setSequence(Numeric0to99999 $sequence = null)
    {
        $this->sequence = $sequence;
        return $this;
    }
    /**
     * Get advisory value
     * @return bool|null
     */
    public function getAdvisory()
    {
        return $this->advisory;
    }
    /**
     * Set advisory value
     * @param bool $advisory
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public function setAdvisory($advisory = null)
    {
        $this->advisory = $advisory;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
