<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security Structs
 * Meta informations extracted from the WSDL
 * - Prefix: wsse
 * - documentation: Header records no longer contain user credentials (username/password) as these are needed only for SessionCreateRQ in which the credentials should be in the payload.
 * - type: Security
 * @subpackage Structs
 */
class Security extends AbstractStructBase
{
    /**
     * The UsernameToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\UsernameToken
     */
    public $UsernameToken;
    /**
     * The SabreAth
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $SabreAth;
    /**
     * The BinarySecurityToken
     * Meta informations extracted from the WSDL
     * - Prefix: wsse
     * - minOccurs: 0
     * @var string
     */
    public $BinarySecurityToken;
    /**
     * The SecurityToken
     * Meta informations extracted from the WSDL
     * - documentation: Same as STL Text.Long - A field text characters and no other constraints.
     * - maxLength: 4096
     * - minLength: 0
     * @var string
     */
    public $SecurityToken;
    /**
     * Constructor method for Security
     * @uses Security::setUsernameToken()
     * @uses Security::setSabreAth()
     * @uses Security::setBinarySecurityToken()
     * @uses Security::setSecurityToken()
     * @param \Sabre\TravelItineraryRead\Structs\UsernameToken $usernameToken
     * @param string $sabreAth
     * @param string $binarySecurityToken
     * @param string $securityToken
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\UsernameToken $usernameToken = null, $sabreAth = null, $binarySecurityToken = null, $securityToken = null)
    {
        $this
            ->setUsernameToken($usernameToken)
            ->setSabreAth($sabreAth)
            ->setBinarySecurityToken($binarySecurityToken)
            ->setSecurityToken($securityToken);
    }
    /**
     * Get UsernameToken value
     * @return \Sabre\TravelItineraryRead\Structs\UsernameToken|null
     */
    public function getUsernameToken()
    {
        return $this->UsernameToken;
    }
    /**
     * Set UsernameToken value
     * @param \Sabre\TravelItineraryRead\Structs\UsernameToken $usernameToken
     * @return \Sabre\TravelItineraryRead\Structs\Security
     */
    public function setUsernameToken(\Sabre\TravelItineraryRead\Structs\UsernameToken $usernameToken = null)
    {
        $this->UsernameToken = $usernameToken;
        return $this;
    }
    /**
     * Get SabreAth value
     * @return string|null
     */
    public function getSabreAth()
    {
        return $this->SabreAth;
    }
    /**
     * Set SabreAth value
     * @param string $sabreAth
     * @return \Sabre\TravelItineraryRead\Structs\Security
     */
    public function setSabreAth($sabreAth = null)
    {
        $this->SabreAth = $sabreAth;
        return $this;
    }
    /**
     * Get BinarySecurityToken value
     * @return string|null
     */
    public function getBinarySecurityToken()
    {
        return $this->BinarySecurityToken;
    }
    /**
     * Set BinarySecurityToken value
     * @param string $binarySecurityToken
     * @return \Sabre\TravelItineraryRead\Structs\Security
     */
    public function setBinarySecurityToken($binarySecurityToken = null)
    {
        $this->BinarySecurityToken = $binarySecurityToken;
        return $this;
    }
    /**
     * Get SecurityToken value
     * @return string|null
     */
    public function getSecurityToken()
    {
        return $this->SecurityToken;
    }
    /**
     * Set SecurityToken value
     * @param string $securityToken
     * @return \Sabre\TravelItineraryRead\Structs\Security
     */
    public function setSecurityToken($securityToken = null)
    {
        $this->SecurityToken = $securityToken;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Security
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
