<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoomRates Structs
 * Meta informations extracted from the WSDL
 * - documentation: Reservation rate(s).
 * @subpackage Structs
 */
class RoomRates extends AbstractStructBase
{
    /**
     * The AmountBeforeTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AmountBeforeTax;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Override
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Override;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Commission
     */
    public $Commission;
    /**
     * The Rate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Rate
     */
    public $Rate;
    /**
     * Constructor method for RoomRates
     * @uses RoomRates::setAmountBeforeTax()
     * @uses RoomRates::setCurrencyCode()
     * @uses RoomRates::setOverride()
     * @uses RoomRates::setCommission()
     * @uses RoomRates::setRate()
     * @param string $amountBeforeTax
     * @param string $currencyCode
     * @param bool $override
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @param \Sabre\TravelItineraryRead\Structs\Rate $rate
     */
    public function __construct($amountBeforeTax = null, $currencyCode = null, $override = null, \Sabre\TravelItineraryRead\Structs\Commission $commission = null, \Sabre\TravelItineraryRead\Structs\Rate $rate = null)
    {
        $this
            ->setAmountBeforeTax($amountBeforeTax)
            ->setCurrencyCode($currencyCode)
            ->setOverride($override)
            ->setCommission($commission)
            ->setRate($rate);
    }
    /**
     * Get AmountBeforeTax value
     * @return string|null
     */
    public function getAmountBeforeTax()
    {
        return $this->AmountBeforeTax;
    }
    /**
     * Set AmountBeforeTax value
     * @param string $amountBeforeTax
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public function setAmountBeforeTax($amountBeforeTax = null)
    {
        $this->AmountBeforeTax = $amountBeforeTax;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Override value
     * @return bool|null
     */
    public function getOverride()
    {
        return $this->Override;
    }
    /**
     * Set Override value
     * @param bool $override
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public function setOverride($override = null)
    {
        $this->Override = $override;
        return $this;
    }
    /**
     * Get Commission value
     * @return \Sabre\TravelItineraryRead\Structs\Commission|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param \Sabre\TravelItineraryRead\Structs\Commission $commission
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public function setCommission(\Sabre\TravelItineraryRead\Structs\Commission $commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get Rate value
     * @return \Sabre\TravelItineraryRead\Structs\Rate|null
     */
    public function getRate()
    {
        return $this->Rate;
    }
    /**
     * Set Rate value
     * @param \Sabre\TravelItineraryRead\Structs\Rate $rate
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public function setRate(\Sabre\TravelItineraryRead\Structs\Rate $rate = null)
    {
        $this->Rate = $rate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\RoomRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
