<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Remark Structs
 * @subpackage Structs
 */
class Remark extends AbstractStructBase
{
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return the remark text
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PersonName[]
     */
    public $PersonName;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - documentation: "Code" is used to return the code associated with the particular remark line if applicable
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference placeholder Example: 001
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the segment number associated with the particular remark line if applicable Example: 9
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the type associated with the particular remark line if applicable; acceptable values are: "Client Address," "Alpha-Coded," "Historical," "General," "Delivery Address," "Itinerary," or "Invoice."
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - documentation: "Id" is used to return the id of Remark
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Remark
     * @uses Remark::setText()
     * @uses Remark::setPersonName()
     * @uses Remark::setCode()
     * @uses Remark::setRPH()
     * @uses Remark::setSegmentNumber()
     * @uses Remark::setType()
     * @uses Remark::setId()
     * @param string $text
     * @param \Sabre\TravelItineraryRead\Structs\PersonName[] $personName
     * @param string $code
     * @param string $rPH
     * @param string $segmentNumber
     * @param string $type
     * @param string $id
     */
    public function __construct($text = null, array $personName = array(), $code = null, $rPH = null, $segmentNumber = null, $type = null, $id = null)
    {
        $this
            ->setText($text)
            ->setPersonName($personName)
            ->setCode($code)
            ->setRPH($rPH)
            ->setSegmentNumber($segmentNumber)
            ->setType($type)
            ->setId($id);
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonName[]|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PersonName[] $personName
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setPersonName(array $personName = array())
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Add item to PersonName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $item
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function addToPersonName(\Sabre\TravelItineraryRead\Structs\PersonName $item)
    {
        $this->PersonName[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setCode($code = null)
    {
        $this->Code = $code;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Remark
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
