<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductDetailsType Structs
 * @subpackage Structs
 */
class ProductDetailsType extends AbstractStructBase
{
    /**
     * The ProductName
     * @var \Sabre\TravelItineraryRead\Structs\ProductNameType
     */
    public $ProductName;
    /**
     * The Hotel
     * @var \Sabre\TravelItineraryRead\Structs\HotelProductType
     */
    public $Hotel;
    /**
     * The GroundTransportation
     * @var \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public $GroundTransportation;
    /**
     * The Rail
     * @var \Sabre\TravelItineraryRead\Structs\RailType
     */
    public $Rail;
    /**
     * The Tour
     * @var \Sabre\TravelItineraryRead\Structs\TourType
     */
    public $Tour;
    /**
     * The Air
     * @var \Sabre\TravelItineraryRead\Structs\AirType
     */
    public $Air;
    /**
     * The Visa
     * @var \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public $Visa;
    /**
     * The Insurance
     * @var \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public $Insurance;
    /**
     * The Vehicle
     * @var \Sabre\TravelItineraryRead\Structs\VehicleType
     */
    public $Vehicle;
    /**
     * The Other
     * @var \Sabre\TravelItineraryRead\Structs\OtherType
     */
    public $Other;
    /**
     * The Ski
     * @var \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public $Ski;
    /**
     * The ExternalSystemReference
     * Meta informations extracted from the WSDL
     * - documentation: Hold reference ID given by external system/application which can be used to reference to product item that is in the external system
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType[]
     */
    public $ExternalSystemReference;
    /**
     * The TransactionInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TransactionInfo
     */
    public $TransactionInfo;
    /**
     * The BillingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\BillingInfo
     */
    public $BillingInfo;
    /**
     * The CO2Value
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CO2ValueType
     */
    public $CO2Value;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Comment;
    /**
     * The productCategory
     * Meta informations extracted from the WSDL
     * - documentation: eg. TruTrip, passive, high level source/type
     * @var string
     */
    public $productCategory;
    /**
     * The productType
     * @var string
     */
    public $productType;
    /**
     * The vendorCode
     * @var string
     */
    public $vendorCode;
    /**
     * The statusCode
     * @var string
     */
    public $statusCode;
    /**
     * The previousStatusCode
     * @var string
     */
    public $previousStatusCode;
    /**
     * The startPoint
     * @var string
     */
    public $startPoint;
    /**
     * The startDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $startDateTime;
    /**
     * The endPoint
     * @var string
     */
    public $endPoint;
    /**
     * The endDateTime
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $endDateTime;
    /**
     * The normalizedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: when equals to "true" means this data has been normalized with Normalized Service
     * @var bool
     */
    public $normalizedIndicator;
    /**
     * The numberInParty
     * @var int
     */
    public $numberInParty;
    /**
     * Constructor method for ProductDetailsType
     * @uses ProductDetailsType::setProductName()
     * @uses ProductDetailsType::setHotel()
     * @uses ProductDetailsType::setGroundTransportation()
     * @uses ProductDetailsType::setRail()
     * @uses ProductDetailsType::setTour()
     * @uses ProductDetailsType::setAir()
     * @uses ProductDetailsType::setVisa()
     * @uses ProductDetailsType::setInsurance()
     * @uses ProductDetailsType::setVehicle()
     * @uses ProductDetailsType::setOther()
     * @uses ProductDetailsType::setSki()
     * @uses ProductDetailsType::setExternalSystemReference()
     * @uses ProductDetailsType::setTransactionInfo()
     * @uses ProductDetailsType::setBillingInfo()
     * @uses ProductDetailsType::setCO2Value()
     * @uses ProductDetailsType::setComment()
     * @uses ProductDetailsType::setProductCategory()
     * @uses ProductDetailsType::setProductType()
     * @uses ProductDetailsType::setVendorCode()
     * @uses ProductDetailsType::setStatusCode()
     * @uses ProductDetailsType::setPreviousStatusCode()
     * @uses ProductDetailsType::setStartPoint()
     * @uses ProductDetailsType::setStartDateTime()
     * @uses ProductDetailsType::setEndPoint()
     * @uses ProductDetailsType::setEndDateTime()
     * @uses ProductDetailsType::setNormalizedIndicator()
     * @uses ProductDetailsType::setNumberInParty()
     * @param \Sabre\TravelItineraryRead\Structs\ProductNameType $productName
     * @param \Sabre\TravelItineraryRead\Structs\HotelProductType $hotel
     * @param \Sabre\TravelItineraryRead\Structs\GroundTransportationType $groundTransportation
     * @param \Sabre\TravelItineraryRead\Structs\RailType $rail
     * @param \Sabre\TravelItineraryRead\Structs\TourType $tour
     * @param \Sabre\TravelItineraryRead\Structs\AirType $air
     * @param \Sabre\TravelItineraryRead\Structs\VisaType $visa
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceType $insurance
     * @param \Sabre\TravelItineraryRead\Structs\VehicleType $vehicle
     * @param \Sabre\TravelItineraryRead\Structs\OtherType $other
     * @param \Sabre\TravelItineraryRead\Structs\SkiType $ski
     * @param \Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType[] $externalSystemReference
     * @param \Sabre\TravelItineraryRead\Structs\TransactionInfo $transactionInfo
     * @param \Sabre\TravelItineraryRead\Structs\BillingInfo $billingInfo
     * @param \Sabre\TravelItineraryRead\Structs\CO2ValueType $cO2Value
     * @param string $comment
     * @param string $productCategory
     * @param string $productType
     * @param string $vendorCode
     * @param string $statusCode
     * @param string $previousStatusCode
     * @param string $startPoint
     * @param string $startDateTime
     * @param string $endPoint
     * @param string $endDateTime
     * @param bool $normalizedIndicator
     * @param int $numberInParty
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\ProductNameType $productName = null, \Sabre\TravelItineraryRead\Structs\HotelProductType $hotel = null, \Sabre\TravelItineraryRead\Structs\GroundTransportationType $groundTransportation = null, \Sabre\TravelItineraryRead\Structs\RailType $rail = null, \Sabre\TravelItineraryRead\Structs\TourType $tour = null, \Sabre\TravelItineraryRead\Structs\AirType $air = null, \Sabre\TravelItineraryRead\Structs\VisaType $visa = null, \Sabre\TravelItineraryRead\Structs\InsuranceType $insurance = null, \Sabre\TravelItineraryRead\Structs\VehicleType $vehicle = null, \Sabre\TravelItineraryRead\Structs\OtherType $other = null, \Sabre\TravelItineraryRead\Structs\SkiType $ski = null, array $externalSystemReference = array(), \Sabre\TravelItineraryRead\Structs\TransactionInfo $transactionInfo = null, \Sabre\TravelItineraryRead\Structs\BillingInfo $billingInfo = null, \Sabre\TravelItineraryRead\Structs\CO2ValueType $cO2Value = null, $comment = null, $productCategory = null, $productType = null, $vendorCode = null, $statusCode = null, $previousStatusCode = null, $startPoint = null, $startDateTime = null, $endPoint = null, $endDateTime = null, $normalizedIndicator = null, $numberInParty = null)
    {
        $this
            ->setProductName($productName)
            ->setHotel($hotel)
            ->setGroundTransportation($groundTransportation)
            ->setRail($rail)
            ->setTour($tour)
            ->setAir($air)
            ->setVisa($visa)
            ->setInsurance($insurance)
            ->setVehicle($vehicle)
            ->setOther($other)
            ->setSki($ski)
            ->setExternalSystemReference($externalSystemReference)
            ->setTransactionInfo($transactionInfo)
            ->setBillingInfo($billingInfo)
            ->setCO2Value($cO2Value)
            ->setComment($comment)
            ->setProductCategory($productCategory)
            ->setProductType($productType)
            ->setVendorCode($vendorCode)
            ->setStatusCode($statusCode)
            ->setPreviousStatusCode($previousStatusCode)
            ->setStartPoint($startPoint)
            ->setStartDateTime($startDateTime)
            ->setEndPoint($endPoint)
            ->setEndDateTime($endDateTime)
            ->setNormalizedIndicator($normalizedIndicator)
            ->setNumberInParty($numberInParty);
    }
    /**
     * Get ProductName value
     * @return \Sabre\TravelItineraryRead\Structs\ProductNameType|null
     */
    public function getProductName()
    {
        return $this->ProductName;
    }
    /**
     * Set ProductName value
     * @param \Sabre\TravelItineraryRead\Structs\ProductNameType $productName
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setProductName(\Sabre\TravelItineraryRead\Structs\ProductNameType $productName = null)
    {
        $this->ProductName = $productName;
        return $this;
    }
    /**
     * Get Hotel value
     * @return \Sabre\TravelItineraryRead\Structs\HotelProductType|null
     */
    public function getHotel()
    {
        return $this->Hotel;
    }
    /**
     * Set Hotel value
     * @param \Sabre\TravelItineraryRead\Structs\HotelProductType $hotel
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setHotel(\Sabre\TravelItineraryRead\Structs\HotelProductType $hotel = null)
    {
        $this->Hotel = $hotel;
        return $this;
    }
    /**
     * Get GroundTransportation value
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType|null
     */
    public function getGroundTransportation()
    {
        return $this->GroundTransportation;
    }
    /**
     * Set GroundTransportation value
     * @param \Sabre\TravelItineraryRead\Structs\GroundTransportationType $groundTransportation
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setGroundTransportation(\Sabre\TravelItineraryRead\Structs\GroundTransportationType $groundTransportation = null)
    {
        $this->GroundTransportation = $groundTransportation;
        return $this;
    }
    /**
     * Get Rail value
     * @return \Sabre\TravelItineraryRead\Structs\RailType|null
     */
    public function getRail()
    {
        return $this->Rail;
    }
    /**
     * Set Rail value
     * @param \Sabre\TravelItineraryRead\Structs\RailType $rail
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setRail(\Sabre\TravelItineraryRead\Structs\RailType $rail = null)
    {
        $this->Rail = $rail;
        return $this;
    }
    /**
     * Get Tour value
     * @return \Sabre\TravelItineraryRead\Structs\TourType|null
     */
    public function getTour()
    {
        return $this->Tour;
    }
    /**
     * Set Tour value
     * @param \Sabre\TravelItineraryRead\Structs\TourType $tour
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setTour(\Sabre\TravelItineraryRead\Structs\TourType $tour = null)
    {
        $this->Tour = $tour;
        return $this;
    }
    /**
     * Get Air value
     * @return \Sabre\TravelItineraryRead\Structs\AirType|null
     */
    public function getAir()
    {
        return $this->Air;
    }
    /**
     * Set Air value
     * @param \Sabre\TravelItineraryRead\Structs\AirType $air
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setAir(\Sabre\TravelItineraryRead\Structs\AirType $air = null)
    {
        $this->Air = $air;
        return $this;
    }
    /**
     * Get Visa value
     * @return \Sabre\TravelItineraryRead\Structs\VisaType|null
     */
    public function getVisa()
    {
        return $this->Visa;
    }
    /**
     * Set Visa value
     * @param \Sabre\TravelItineraryRead\Structs\VisaType $visa
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setVisa(\Sabre\TravelItineraryRead\Structs\VisaType $visa = null)
    {
        $this->Visa = $visa;
        return $this;
    }
    /**
     * Get Insurance value
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * Set Insurance value
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceType $insurance
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setInsurance(\Sabre\TravelItineraryRead\Structs\InsuranceType $insurance = null)
    {
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Get Vehicle value
     * @return \Sabre\TravelItineraryRead\Structs\VehicleType|null
     */
    public function getVehicle()
    {
        return $this->Vehicle;
    }
    /**
     * Set Vehicle value
     * @param \Sabre\TravelItineraryRead\Structs\VehicleType $vehicle
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setVehicle(\Sabre\TravelItineraryRead\Structs\VehicleType $vehicle = null)
    {
        $this->Vehicle = $vehicle;
        return $this;
    }
    /**
     * Get Other value
     * @return \Sabre\TravelItineraryRead\Structs\OtherType|null
     */
    public function getOther()
    {
        return $this->Other;
    }
    /**
     * Set Other value
     * @param \Sabre\TravelItineraryRead\Structs\OtherType $other
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setOther(\Sabre\TravelItineraryRead\Structs\OtherType $other = null)
    {
        $this->Other = $other;
        return $this;
    }
    /**
     * Get Ski value
     * @return \Sabre\TravelItineraryRead\Structs\SkiType|null
     */
    public function getSki()
    {
        return $this->Ski;
    }
    /**
     * Set Ski value
     * @param \Sabre\TravelItineraryRead\Structs\SkiType $ski
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setSki(\Sabre\TravelItineraryRead\Structs\SkiType $ski = null)
    {
        $this->Ski = $ski;
        return $this;
    }
    /**
     * Get ExternalSystemReference value
     * @return \Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType[]|null
     */
    public function getExternalSystemReference()
    {
        return $this->ExternalSystemReference;
    }
    /**
     * Set ExternalSystemReference value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType[] $externalSystemReference
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setExternalSystemReference(array $externalSystemReference = array())
    {
        $this->ExternalSystemReference = $externalSystemReference;
        return $this;
    }
    /**
     * Add item to ExternalSystemReference value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType $item
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function addToExternalSystemReference(\Sabre\TravelItineraryRead\Structs\ExternalSystemReferenceType $item)
    {
        $this->ExternalSystemReference[] = $item;
        return $this;
    }
    /**
     * Get TransactionInfo value
     * @return \Sabre\TravelItineraryRead\Structs\TransactionInfo|null
     */
    public function getTransactionInfo()
    {
        return $this->TransactionInfo;
    }
    /**
     * Set TransactionInfo value
     * @param \Sabre\TravelItineraryRead\Structs\TransactionInfo $transactionInfo
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setTransactionInfo(\Sabre\TravelItineraryRead\Structs\TransactionInfo $transactionInfo = null)
    {
        $this->TransactionInfo = $transactionInfo;
        return $this;
    }
    /**
     * Get BillingInfo value
     * @return \Sabre\TravelItineraryRead\Structs\BillingInfo|null
     */
    public function getBillingInfo()
    {
        return $this->BillingInfo;
    }
    /**
     * Set BillingInfo value
     * @param \Sabre\TravelItineraryRead\Structs\BillingInfo $billingInfo
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setBillingInfo(\Sabre\TravelItineraryRead\Structs\BillingInfo $billingInfo = null)
    {
        $this->BillingInfo = $billingInfo;
        return $this;
    }
    /**
     * Get CO2Value value
     * @return \Sabre\TravelItineraryRead\Structs\CO2ValueType|null
     */
    public function getCO2Value()
    {
        return $this->CO2Value;
    }
    /**
     * Set CO2Value value
     * @param \Sabre\TravelItineraryRead\Structs\CO2ValueType $cO2Value
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setCO2Value(\Sabre\TravelItineraryRead\Structs\CO2ValueType $cO2Value = null)
    {
        $this->CO2Value = $cO2Value;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setComment($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get productCategory value
     * @return string|null
     */
    public function getProductCategory()
    {
        return $this->productCategory;
    }
    /**
     * Set productCategory value
     * @param string $productCategory
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setProductCategory($productCategory = null)
    {
        $this->productCategory = $productCategory;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @param string $productType
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setProductType($productType = null)
    {
        $this->productType = $productType;
        return $this;
    }
    /**
     * Get vendorCode value
     * @return string|null
     */
    public function getVendorCode()
    {
        return $this->vendorCode;
    }
    /**
     * Set vendorCode value
     * @param string $vendorCode
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setVendorCode($vendorCode = null)
    {
        $this->vendorCode = $vendorCode;
        return $this;
    }
    /**
     * Get statusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->statusCode;
    }
    /**
     * Set statusCode value
     * @param string $statusCode
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->statusCode = $statusCode;
        return $this;
    }
    /**
     * Get previousStatusCode value
     * @return string|null
     */
    public function getPreviousStatusCode()
    {
        return $this->previousStatusCode;
    }
    /**
     * Set previousStatusCode value
     * @param string $previousStatusCode
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setPreviousStatusCode($previousStatusCode = null)
    {
        $this->previousStatusCode = $previousStatusCode;
        return $this;
    }
    /**
     * Get startPoint value
     * @return string|null
     */
    public function getStartPoint()
    {
        return $this->startPoint;
    }
    /**
     * Set startPoint value
     * @param string $startPoint
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setStartPoint($startPoint = null)
    {
        $this->startPoint = $startPoint;
        return $this;
    }
    /**
     * Get startDateTime value
     * @return string|null
     */
    public function getStartDateTime()
    {
        return $this->startDateTime;
    }
    /**
     * Set startDateTime value
     * @param string $startDateTime
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setStartDateTime($startDateTime = null)
    {
        $this->startDateTime = $startDateTime;
        return $this;
    }
    /**
     * Get endPoint value
     * @return string|null
     */
    public function getEndPoint()
    {
        return $this->endPoint;
    }
    /**
     * Set endPoint value
     * @param string $endPoint
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setEndPoint($endPoint = null)
    {
        $this->endPoint = $endPoint;
        return $this;
    }
    /**
     * Get endDateTime value
     * @return string|null
     */
    public function getEndDateTime()
    {
        return $this->endDateTime;
    }
    /**
     * Set endDateTime value
     * @param string $endDateTime
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setEndDateTime($endDateTime = null)
    {
        $this->endDateTime = $endDateTime;
        return $this;
    }
    /**
     * Get normalizedIndicator value
     * @return bool|null
     */
    public function getNormalizedIndicator()
    {
        return $this->normalizedIndicator;
    }
    /**
     * Set normalizedIndicator value
     * @param bool $normalizedIndicator
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setNormalizedIndicator($normalizedIndicator = null)
    {
        $this->normalizedIndicator = $normalizedIndicator;
        return $this;
    }
    /**
     * Get numberInParty value
     * @return int|null
     */
    public function getNumberInParty()
    {
        return $this->numberInParty;
    }
    /**
     * Set numberInParty value
     * @param int $numberInParty
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public function setNumberInParty($numberInParty = null)
    {
        $this->numberInParty = $numberInParty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ProductDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
