<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaymentCardApproval Structs
 * @subpackage Structs
 */
class PaymentCardApproval extends AbstractStructBase
{
    /**
     * The ManualApproval
     * @var bool
     */
    public $ManualApproval;
    /**
     * The ResponseCode
     * @var string
     */
    public $ResponseCode;
    /**
     * The ApprovalCode
     * @var string
     */
    public $ApprovalCode;
    /**
     * The RequestTime
     * Meta informations extracted from the WSDL
     * - documentation: Approval request time | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $RequestTime;
    /**
     * The ExpiryTime
     * Meta informations extracted from the WSDL
     * - documentation: Approval expiry time | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $ExpiryTime;
    /**
     * The AirlineCode
     * @var string
     */
    public $AirlineCode;
    /**
     * The Amount
     * @var \Sabre\TravelItineraryRead\Structs\MoneyType
     */
    public $Amount;
    /**
     * The Remarks
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Remarks;
    /**
     * The SupplierTransID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierTransID;
    /**
     * The PaymentRef
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaymentRef;
    /**
     * The CSCMatched
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSCMatched;
    /**
     * The CSCRemark
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CSCRemark;
    /**
     * The Qualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Qualifier;
    /**
     * The ExtendPayment
     * Meta informations extracted from the WSDL
     * - documentation: Number of months or installments.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExtendPayment;
    /**
     * Constructor method for PaymentCardApproval
     * @uses PaymentCardApproval::setManualApproval()
     * @uses PaymentCardApproval::setResponseCode()
     * @uses PaymentCardApproval::setApprovalCode()
     * @uses PaymentCardApproval::setRequestTime()
     * @uses PaymentCardApproval::setExpiryTime()
     * @uses PaymentCardApproval::setAirlineCode()
     * @uses PaymentCardApproval::setAmount()
     * @uses PaymentCardApproval::setRemarks()
     * @uses PaymentCardApproval::setSupplierTransID()
     * @uses PaymentCardApproval::setPaymentRef()
     * @uses PaymentCardApproval::setCSCMatched()
     * @uses PaymentCardApproval::setCSCRemark()
     * @uses PaymentCardApproval::setQualifier()
     * @uses PaymentCardApproval::setExtendPayment()
     * @param bool $manualApproval
     * @param string $responseCode
     * @param string $approvalCode
     * @param string $requestTime
     * @param string $expiryTime
     * @param string $airlineCode
     * @param \Sabre\TravelItineraryRead\Structs\MoneyType $amount
     * @param string $remarks
     * @param string $supplierTransID
     * @param string $paymentRef
     * @param string $cSCMatched
     * @param string $cSCRemark
     * @param string $qualifier
     * @param string $extendPayment
     */
    public function __construct($manualApproval = null, $responseCode = null, $approvalCode = null, $requestTime = null, $expiryTime = null, $airlineCode = null, \Sabre\TravelItineraryRead\Structs\MoneyType $amount = null, $remarks = null, $supplierTransID = null, $paymentRef = null, $cSCMatched = null, $cSCRemark = null, $qualifier = null, $extendPayment = null)
    {
        $this
            ->setManualApproval($manualApproval)
            ->setResponseCode($responseCode)
            ->setApprovalCode($approvalCode)
            ->setRequestTime($requestTime)
            ->setExpiryTime($expiryTime)
            ->setAirlineCode($airlineCode)
            ->setAmount($amount)
            ->setRemarks($remarks)
            ->setSupplierTransID($supplierTransID)
            ->setPaymentRef($paymentRef)
            ->setCSCMatched($cSCMatched)
            ->setCSCRemark($cSCRemark)
            ->setQualifier($qualifier)
            ->setExtendPayment($extendPayment);
    }
    /**
     * Get ManualApproval value
     * @return bool|null
     */
    public function getManualApproval()
    {
        return $this->ManualApproval;
    }
    /**
     * Set ManualApproval value
     * @param bool $manualApproval
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setManualApproval($manualApproval = null)
    {
        $this->ManualApproval = $manualApproval;
        return $this;
    }
    /**
     * Get ResponseCode value
     * @return string|null
     */
    public function getResponseCode()
    {
        return $this->ResponseCode;
    }
    /**
     * Set ResponseCode value
     * @param string $responseCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setResponseCode($responseCode = null)
    {
        $this->ResponseCode = $responseCode;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setApprovalCode($approvalCode = null)
    {
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get RequestTime value
     * @return string|null
     */
    public function getRequestTime()
    {
        return $this->RequestTime;
    }
    /**
     * Set RequestTime value
     * @param string $requestTime
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setRequestTime($requestTime = null)
    {
        $this->RequestTime = $requestTime;
        return $this;
    }
    /**
     * Get ExpiryTime value
     * @return string|null
     */
    public function getExpiryTime()
    {
        return $this->ExpiryTime;
    }
    /**
     * Set ExpiryTime value
     * @param string $expiryTime
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setExpiryTime($expiryTime = null)
    {
        $this->ExpiryTime = $expiryTime;
        return $this;
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setAirlineCode($airlineCode = null)
    {
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Sabre\TravelItineraryRead\Structs\MoneyType|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Sabre\TravelItineraryRead\Structs\MoneyType $amount
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setAmount(\Sabre\TravelItineraryRead\Structs\MoneyType $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Remarks value
     * @return string|null
     */
    public function getRemarks()
    {
        return $this->Remarks;
    }
    /**
     * Set Remarks value
     * @param string $remarks
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setRemarks($remarks = null)
    {
        $this->Remarks = $remarks;
        return $this;
    }
    /**
     * Get SupplierTransID value
     * @return string|null
     */
    public function getSupplierTransID()
    {
        return $this->SupplierTransID;
    }
    /**
     * Set SupplierTransID value
     * @param string $supplierTransID
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setSupplierTransID($supplierTransID = null)
    {
        $this->SupplierTransID = $supplierTransID;
        return $this;
    }
    /**
     * Get PaymentRef value
     * @return string|null
     */
    public function getPaymentRef()
    {
        return $this->PaymentRef;
    }
    /**
     * Set PaymentRef value
     * @param string $paymentRef
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setPaymentRef($paymentRef = null)
    {
        $this->PaymentRef = $paymentRef;
        return $this;
    }
    /**
     * Get CSCMatched value
     * @return string|null
     */
    public function getCSCMatched()
    {
        return $this->CSCMatched;
    }
    /**
     * Set CSCMatched value
     * @param string $cSCMatched
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setCSCMatched($cSCMatched = null)
    {
        $this->CSCMatched = $cSCMatched;
        return $this;
    }
    /**
     * Get CSCRemark value
     * @return string|null
     */
    public function getCSCRemark()
    {
        return $this->CSCRemark;
    }
    /**
     * Set CSCRemark value
     * @param string $cSCRemark
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setCSCRemark($cSCRemark = null)
    {
        $this->CSCRemark = $cSCRemark;
        return $this;
    }
    /**
     * Get Qualifier value
     * @return string|null
     */
    public function getQualifier()
    {
        return $this->Qualifier;
    }
    /**
     * Set Qualifier value
     * @param string $qualifier
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setQualifier($qualifier = null)
    {
        $this->Qualifier = $qualifier;
        return $this;
    }
    /**
     * Get ExtendPayment value
     * @return string|null
     */
    public function getExtendPayment()
    {
        return $this->ExtendPayment;
    }
    /**
     * Set ExtendPayment value
     * @param string $extendPayment
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public function setExtendPayment($extendPayment = null)
    {
        $this->ExtendPayment = $extendPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PaymentCardApproval
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
