<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment Structs
 * @subpackage Structs
 */
class Payment extends AbstractStructBase
{
    /**
     * The FormOfPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public $FormOfPayment;
    /**
     * The Receiver
     * Meta informations extracted from the WSDL
     * - documentation: Visa payment receiver
     * - minOccurs: 0
     * @var string
     */
    public $Receiver;
    /**
     * The SubTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SubTotal
     */
    public $SubTotal;
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Total
     */
    public $Total;
    /**
     * The TransactionId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionId;
    /**
     * The SupplierId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SupplierId;
    /**
     * The ApprovalAmount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount
     */
    public $ApprovalAmount;
    /**
     * The ApprovalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ApprovalCode;
    /**
     * The Form
     * Meta informations extracted from the WSDL
     * - documentation: "Form" is used to return the form of payment used to purchase the insurance. | "Form" is used to return the form of payment used to purchase the insurance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string
     */
    public $Form;
    /**
     * The CC_Info
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CC_Info[]
     */
    public $CC_Info;
    /**
     * Constructor method for Payment
     * @uses Payment::setFormOfPayment()
     * @uses Payment::setReceiver()
     * @uses Payment::setSubTotal()
     * @uses Payment::setTotal()
     * @uses Payment::setTransactionId()
     * @uses Payment::setSupplierId()
     * @uses Payment::setApprovalAmount()
     * @uses Payment::setApprovalCode()
     * @uses Payment::setForm()
     * @uses Payment::setCC_Info()
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @param string $receiver
     * @param \Sabre\TravelItineraryRead\Structs\SubTotal $subTotal
     * @param \Sabre\TravelItineraryRead\Structs\Total $total
     * @param string $transactionId
     * @param string $supplierId
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $approvalAmount
     * @param string $approvalCode
     * @param string $form
     * @param \Sabre\TravelItineraryRead\Structs\CC_Info[] $cC_Info
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null, $receiver = null, \Sabre\TravelItineraryRead\Structs\SubTotal $subTotal = null, \Sabre\TravelItineraryRead\Structs\Total $total = null, $transactionId = null, $supplierId = null, \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $approvalAmount = null, $approvalCode = null, $form = null, array $cC_Info = array())
    {
        $this
            ->setFormOfPayment($formOfPayment)
            ->setReceiver($receiver)
            ->setSubTotal($subTotal)
            ->setTotal($total)
            ->setTransactionId($transactionId)
            ->setSupplierId($supplierId)
            ->setApprovalAmount($approvalAmount)
            ->setApprovalCode($approvalCode)
            ->setForm($form)
            ->setCC_Info($cC_Info);
    }
    /**
     * Get FormOfPayment value
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public function getFormOfPayment()
    {
        return $this->FormOfPayment;
    }
    /**
     * Set FormOfPayment value
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setFormOfPayment(\Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null)
    {
        $this->FormOfPayment = $formOfPayment;
        return $this;
    }
    /**
     * Get Receiver value
     * @return string|null
     */
    public function getReceiver()
    {
        return $this->Receiver;
    }
    /**
     * Set Receiver value
     * @param string $receiver
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setReceiver($receiver = null)
    {
        $this->Receiver = $receiver;
        return $this;
    }
    /**
     * Get SubTotal value
     * @return \Sabre\TravelItineraryRead\Structs\SubTotal|null
     */
    public function getSubTotal()
    {
        return $this->SubTotal;
    }
    /**
     * Set SubTotal value
     * @param \Sabre\TravelItineraryRead\Structs\SubTotal $subTotal
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setSubTotal(\Sabre\TravelItineraryRead\Structs\SubTotal $subTotal = null)
    {
        $this->SubTotal = $subTotal;
        return $this;
    }
    /**
     * Get Total value
     * @return \Sabre\TravelItineraryRead\Structs\Total|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \Sabre\TravelItineraryRead\Structs\Total $total
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setTotal(\Sabre\TravelItineraryRead\Structs\Total $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setTransactionId($transactionId = null)
    {
        $this->TransactionId = $transactionId;
        return $this;
    }
    /**
     * Get SupplierId value
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->SupplierId;
    }
    /**
     * Set SupplierId value
     * @param string $supplierId
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setSupplierId($supplierId = null)
    {
        $this->SupplierId = $supplierId;
        return $this;
    }
    /**
     * Get ApprovalAmount value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount|null
     */
    public function getApprovalAmount()
    {
        return $this->ApprovalAmount;
    }
    /**
     * Set ApprovalAmount value
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $approvalAmount
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setApprovalAmount(\Sabre\TravelItineraryRead\Structs\AccountingTransactionAmount $approvalAmount = null)
    {
        $this->ApprovalAmount = $approvalAmount;
        return $this;
    }
    /**
     * Get ApprovalCode value
     * @return string|null
     */
    public function getApprovalCode()
    {
        return $this->ApprovalCode;
    }
    /**
     * Set ApprovalCode value
     * @param string $approvalCode
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setApprovalCode($approvalCode = null)
    {
        $this->ApprovalCode = $approvalCode;
        return $this;
    }
    /**
     * Get Form value
     * @return string|null
     */
    public function getForm()
    {
        return $this->Form;
    }
    /**
     * Set Form value
     * @param string $form
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setForm($form = null)
    {
        $this->Form = $form;
        return $this;
    }
    /**
     * Get CC_Info value
     * @return \Sabre\TravelItineraryRead\Structs\CC_Info[]|null
     */
    public function getCC_Info()
    {
        return $this->CC_Info;
    }
    /**
     * Set CC_Info value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CC_Info[] $cC_Info
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function setCC_Info(array $cC_Info = array())
    {
        $this->CC_Info = $cC_Info;
        return $this;
    }
    /**
     * Add item to CC_Info value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\CC_Info $item
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public function addToCC_Info(\Sabre\TravelItineraryRead\Structs\CC_Info $item)
    {
        $this->CC_Info[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Payment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
