<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PTC_FareBreakdown Structs
 * @subpackage Structs
 */
class PTC_FareBreakdown extends AbstractStructBase
{
    /**
     * The NetRemits
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\NetRemits
     */
    public $NetRemits;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Endorsements
     */
    public $Endorsements;
    /**
     * The FareBasis
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FareBasis[]
     */
    public $FareBasis;
    /**
     * The FareCalculation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FareCalculation
     */
    public $FareCalculation;
    /**
     * The FareSource
     * Meta informations extracted from the WSDL
     * - documentation: "FareSource" is used to return the fare source.
     * - minOccurs: 0
     * @var string
     */
    public $FareSource;
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FlightSegment[]
     */
    public $FlightSegment;
    /**
     * The FareComponent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FareComponent[]
     */
    public $FareComponent;
    /**
     * The ResTicketingRestrictions
     * Meta informations extracted from the WSDL
     * - documentation: "ResTicketingRestrictions" is used to return last day to purchase-related information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $ResTicketingRestrictions;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TourCode
     */
    public $TourCode;
    /**
     * Constructor method for PTC_FareBreakdown
     * @uses PTC_FareBreakdown::setNetRemits()
     * @uses PTC_FareBreakdown::setEndorsements()
     * @uses PTC_FareBreakdown::setFareBasis()
     * @uses PTC_FareBreakdown::setFareCalculation()
     * @uses PTC_FareBreakdown::setFareSource()
     * @uses PTC_FareBreakdown::setFlightSegment()
     * @uses PTC_FareBreakdown::setFareComponent()
     * @uses PTC_FareBreakdown::setResTicketingRestrictions()
     * @uses PTC_FareBreakdown::setTourCode()
     * @param \Sabre\TravelItineraryRead\Structs\NetRemits $netRemits
     * @param \Sabre\TravelItineraryRead\Structs\Endorsements $endorsements
     * @param \Sabre\TravelItineraryRead\Structs\FareBasis[] $fareBasis
     * @param \Sabre\TravelItineraryRead\Structs\FareCalculation $fareCalculation
     * @param string $fareSource
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment[] $flightSegment
     * @param \Sabre\TravelItineraryRead\Structs\FareComponent[] $fareComponent
     * @param string[] $resTicketingRestrictions
     * @param \Sabre\TravelItineraryRead\Structs\TourCode $tourCode
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\NetRemits $netRemits = null, \Sabre\TravelItineraryRead\Structs\Endorsements $endorsements = null, array $fareBasis = array(), \Sabre\TravelItineraryRead\Structs\FareCalculation $fareCalculation = null, $fareSource = null, array $flightSegment = array(), array $fareComponent = array(), array $resTicketingRestrictions = array(), \Sabre\TravelItineraryRead\Structs\TourCode $tourCode = null)
    {
        $this
            ->setNetRemits($netRemits)
            ->setEndorsements($endorsements)
            ->setFareBasis($fareBasis)
            ->setFareCalculation($fareCalculation)
            ->setFareSource($fareSource)
            ->setFlightSegment($flightSegment)
            ->setFareComponent($fareComponent)
            ->setResTicketingRestrictions($resTicketingRestrictions)
            ->setTourCode($tourCode);
    }
    /**
     * Get NetRemits value
     * @return \Sabre\TravelItineraryRead\Structs\NetRemits|null
     */
    public function getNetRemits()
    {
        return $this->NetRemits;
    }
    /**
     * Set NetRemits value
     * @param \Sabre\TravelItineraryRead\Structs\NetRemits $netRemits
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setNetRemits(\Sabre\TravelItineraryRead\Structs\NetRemits $netRemits = null)
    {
        $this->NetRemits = $netRemits;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return \Sabre\TravelItineraryRead\Structs\Endorsements|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param \Sabre\TravelItineraryRead\Structs\Endorsements $endorsements
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setEndorsements(\Sabre\TravelItineraryRead\Structs\Endorsements $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get FareBasis value
     * @return \Sabre\TravelItineraryRead\Structs\FareBasis[]|null
     */
    public function getFareBasis()
    {
        return $this->FareBasis;
    }
    /**
     * Set FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FareBasis[] $fareBasis
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setFareBasis(array $fareBasis = array())
    {
        $this->FareBasis = $fareBasis;
        return $this;
    }
    /**
     * Add item to FareBasis value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FareBasis $item
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function addToFareBasis(\Sabre\TravelItineraryRead\Structs\FareBasis $item)
    {
        $this->FareBasis[] = $item;
        return $this;
    }
    /**
     * Get FareCalculation value
     * @return \Sabre\TravelItineraryRead\Structs\FareCalculation|null
     */
    public function getFareCalculation()
    {
        return $this->FareCalculation;
    }
    /**
     * Set FareCalculation value
     * @param \Sabre\TravelItineraryRead\Structs\FareCalculation $fareCalculation
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setFareCalculation(\Sabre\TravelItineraryRead\Structs\FareCalculation $fareCalculation = null)
    {
        $this->FareCalculation = $fareCalculation;
        return $this;
    }
    /**
     * Get FareSource value
     * @return string|null
     */
    public function getFareSource()
    {
        return $this->FareSource;
    }
    /**
     * Set FareSource value
     * @param string $fareSource
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setFareSource($fareSource = null)
    {
        $this->FareSource = $fareSource;
        return $this;
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\TravelItineraryRead\Structs\FlightSegment[]|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment[] $flightSegment
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setFlightSegment(array $flightSegment = array())
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Add item to FlightSegment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $item
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function addToFlightSegment(\Sabre\TravelItineraryRead\Structs\FlightSegment $item)
    {
        $this->FlightSegment[] = $item;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \Sabre\TravelItineraryRead\Structs\FareComponent[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FareComponent[] $fareComponent
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setFareComponent(array $fareComponent = array())
    {
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\FareComponent $item
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function addToFareComponent(\Sabre\TravelItineraryRead\Structs\FareComponent $item)
    {
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get ResTicketingRestrictions value
     * @return string[]|null
     */
    public function getResTicketingRestrictions()
    {
        return $this->ResTicketingRestrictions;
    }
    /**
     * Set ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string[] $resTicketingRestrictions
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setResTicketingRestrictions(array $resTicketingRestrictions = array())
    {
        $this->ResTicketingRestrictions = $resTicketingRestrictions;
        return $this;
    }
    /**
     * Add item to ResTicketingRestrictions value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function addToResTicketingRestrictions($item)
    {
        $this->ResTicketingRestrictions[] = $item;
        return $this;
    }
    /**
     * Get TourCode value
     * @return \Sabre\TravelItineraryRead\Structs\TourCode|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param \Sabre\TravelItineraryRead\Structs\TourCode $tourCode
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public function setTourCode(\Sabre\TravelItineraryRead\Structs\TourCode $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\PTC_FareBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
