<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpenReservationElementType Structs
 * @subpackage Structs
 */
class OpenReservationElementType extends AbstractStructBase
{
    /**
     * The SocialMediaContact
     * Meta informations extracted from the WSDL
     * - ref: SocialMediaContact
     * @var \Sabre\TravelItineraryRead\Structs\SocialMediaContactType
     */
    public $SocialMediaContact;
    /**
     * The AgencyFees
     * Meta informations extracted from the WSDL
     * - ref: AgencyFees
     * @var \Sabre\TravelItineraryRead\Structs\AgencyFeesType
     */
    public $AgencyFees;
    /**
     * The LangDetails
     * Meta informations extracted from the WSDL
     * - ref: LangDetails
     * @var \Sabre\TravelItineraryRead\Structs\LangDetailsType
     */
    public $LangDetails;
    /**
     * The FormOfPayment
     * Meta informations extracted from the WSDL
     * - ref: FormOfPayment
     * @var \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public $FormOfPayment;
    /**
     * The Loyalty
     * Meta informations extracted from the WSDL
     * - ref: Loyalty
     * @var \Sabre\TravelItineraryRead\Structs\Loyalty
     */
    public $Loyalty;
    /**
     * The AncillaryProduct
     * Meta informations extracted from the WSDL
     * - ref: AncillaryProduct
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryProductObject
     */
    public $AncillaryProduct;
    /**
     * The InvoiceData
     * Meta informations extracted from the WSDL
     * - ref: InvoiceData
     * @var \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public $InvoiceData;
    /**
     * The AccountingField
     * Meta informations extracted from the WSDL
     * - ref: AccountingField
     * @var \Sabre\TravelItineraryRead\Structs\AccountingField
     */
    public $AccountingField;
    /**
     * The ServiceRequest
     * Meta informations extracted from the WSDL
     * - ref: ServiceRequest
     * @var \Sabre\TravelItineraryRead\Structs\ServiceRequestType
     */
    public $ServiceRequest;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - ref: Email
     * @var \Sabre\TravelItineraryRead\Structs\Email
     */
    public $Email;
    /**
     * The PriceCache
     * Meta informations extracted from the WSDL
     * - ref: PriceCache
     * @var \Sabre\TravelItineraryRead\Structs\PriceCache
     */
    public $PriceCache;
    /**
     * The InsuranceOptOut
     * Meta informations extracted from the WSDL
     * - ref: InsuranceOptOut
     * @var \Sabre\TravelItineraryRead\Structs\InsuranceOptOut
     */
    public $InsuranceOptOut;
    /**
     * The TripProposalReference
     * Meta informations extracted from the WSDL
     * - ref: TripProposalReference
     * @var \Sabre\TravelItineraryRead\Structs\TripProposalReference
     */
    public $TripProposalReference;
    /**
     * The SegmentAssociation
     * @var \Sabre\TravelItineraryRead\Structs\SegmentAssociation
     */
    public $SegmentAssociation;
    /**
     * The NameAssociation
     * @var \Sabre\TravelItineraryRead\Structs\NameAssociationTag
     */
    public $NameAssociation;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: hold reference ID
     * @var string
     */
    public $id;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: open reservation element type, like SF for Agency Fees
     * @var string
     */
    public $type;
    /**
     * The displayIndex
     * Meta informations extracted from the WSDL
     * - documentation: used to order items sequentially for presentation purposes
     * - use: optional
     * @var int
     */
    public $displayIndex;
    /**
     * The elementId
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $elementId;
    /**
     * Constructor method for OpenReservationElementType
     * @uses OpenReservationElementType::setSocialMediaContact()
     * @uses OpenReservationElementType::setAgencyFees()
     * @uses OpenReservationElementType::setLangDetails()
     * @uses OpenReservationElementType::setFormOfPayment()
     * @uses OpenReservationElementType::setLoyalty()
     * @uses OpenReservationElementType::setAncillaryProduct()
     * @uses OpenReservationElementType::setInvoiceData()
     * @uses OpenReservationElementType::setAccountingField()
     * @uses OpenReservationElementType::setServiceRequest()
     * @uses OpenReservationElementType::setEmail()
     * @uses OpenReservationElementType::setPriceCache()
     * @uses OpenReservationElementType::setInsuranceOptOut()
     * @uses OpenReservationElementType::setTripProposalReference()
     * @uses OpenReservationElementType::setSegmentAssociation()
     * @uses OpenReservationElementType::setNameAssociation()
     * @uses OpenReservationElementType::setId()
     * @uses OpenReservationElementType::setType()
     * @uses OpenReservationElementType::setDisplayIndex()
     * @uses OpenReservationElementType::setElementId()
     * @param \Sabre\TravelItineraryRead\Structs\SocialMediaContactType $socialMediaContact
     * @param \Sabre\TravelItineraryRead\Structs\AgencyFeesType $agencyFees
     * @param \Sabre\TravelItineraryRead\Structs\LangDetailsType $langDetails
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @param \Sabre\TravelItineraryRead\Structs\Loyalty $loyalty
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryProductObject $ancillaryProduct
     * @param \Sabre\TravelItineraryRead\Structs\InvoiceData $invoiceData
     * @param \Sabre\TravelItineraryRead\Structs\AccountingField $accountingField
     * @param \Sabre\TravelItineraryRead\Structs\ServiceRequestType $serviceRequest
     * @param \Sabre\TravelItineraryRead\Structs\Email $email
     * @param \Sabre\TravelItineraryRead\Structs\PriceCache $priceCache
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceOptOut $insuranceOptOut
     * @param \Sabre\TravelItineraryRead\Structs\TripProposalReference $tripProposalReference
     * @param \Sabre\TravelItineraryRead\Structs\SegmentAssociation $segmentAssociation
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag $nameAssociation
     * @param string $id
     * @param string $type
     * @param int $displayIndex
     * @param string $elementId
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\SocialMediaContactType $socialMediaContact = null, \Sabre\TravelItineraryRead\Structs\AgencyFeesType $agencyFees = null, \Sabre\TravelItineraryRead\Structs\LangDetailsType $langDetails = null, \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null, \Sabre\TravelItineraryRead\Structs\Loyalty $loyalty = null, \Sabre\TravelItineraryRead\Structs\AncillaryProductObject $ancillaryProduct = null, \Sabre\TravelItineraryRead\Structs\InvoiceData $invoiceData = null, \Sabre\TravelItineraryRead\Structs\AccountingField $accountingField = null, \Sabre\TravelItineraryRead\Structs\ServiceRequestType $serviceRequest = null, \Sabre\TravelItineraryRead\Structs\Email $email = null, \Sabre\TravelItineraryRead\Structs\PriceCache $priceCache = null, \Sabre\TravelItineraryRead\Structs\InsuranceOptOut $insuranceOptOut = null, \Sabre\TravelItineraryRead\Structs\TripProposalReference $tripProposalReference = null, \Sabre\TravelItineraryRead\Structs\SegmentAssociation $segmentAssociation = null, \Sabre\TravelItineraryRead\Structs\NameAssociationTag $nameAssociation = null, $id = null, $type = null, $displayIndex = null, $elementId = null)
    {
        $this
            ->setSocialMediaContact($socialMediaContact)
            ->setAgencyFees($agencyFees)
            ->setLangDetails($langDetails)
            ->setFormOfPayment($formOfPayment)
            ->setLoyalty($loyalty)
            ->setAncillaryProduct($ancillaryProduct)
            ->setInvoiceData($invoiceData)
            ->setAccountingField($accountingField)
            ->setServiceRequest($serviceRequest)
            ->setEmail($email)
            ->setPriceCache($priceCache)
            ->setInsuranceOptOut($insuranceOptOut)
            ->setTripProposalReference($tripProposalReference)
            ->setSegmentAssociation($segmentAssociation)
            ->setNameAssociation($nameAssociation)
            ->setId($id)
            ->setType($type)
            ->setDisplayIndex($displayIndex)
            ->setElementId($elementId);
    }
    /**
     * Get SocialMediaContact value
     * @return \Sabre\TravelItineraryRead\Structs\SocialMediaContactType|null
     */
    public function getSocialMediaContact()
    {
        return $this->SocialMediaContact;
    }
    /**
     * Set SocialMediaContact value
     * @param \Sabre\TravelItineraryRead\Structs\SocialMediaContactType $socialMediaContact
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setSocialMediaContact(\Sabre\TravelItineraryRead\Structs\SocialMediaContactType $socialMediaContact = null)
    {
        $this->SocialMediaContact = $socialMediaContact;
        return $this;
    }
    /**
     * Get AgencyFees value
     * @return \Sabre\TravelItineraryRead\Structs\AgencyFeesType|null
     */
    public function getAgencyFees()
    {
        return $this->AgencyFees;
    }
    /**
     * Set AgencyFees value
     * @param \Sabre\TravelItineraryRead\Structs\AgencyFeesType $agencyFees
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setAgencyFees(\Sabre\TravelItineraryRead\Structs\AgencyFeesType $agencyFees = null)
    {
        $this->AgencyFees = $agencyFees;
        return $this;
    }
    /**
     * Get LangDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LangDetailsType|null
     */
    public function getLangDetails()
    {
        return $this->LangDetails;
    }
    /**
     * Set LangDetails value
     * @param \Sabre\TravelItineraryRead\Structs\LangDetailsType $langDetails
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setLangDetails(\Sabre\TravelItineraryRead\Structs\LangDetailsType $langDetails = null)
    {
        $this->LangDetails = $langDetails;
        return $this;
    }
    /**
     * Get FormOfPayment value
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment|null
     */
    public function getFormOfPayment()
    {
        return $this->FormOfPayment;
    }
    /**
     * Set FormOfPayment value
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setFormOfPayment(\Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null)
    {
        $this->FormOfPayment = $formOfPayment;
        return $this;
    }
    /**
     * Get Loyalty value
     * @return \Sabre\TravelItineraryRead\Structs\Loyalty|null
     */
    public function getLoyalty()
    {
        return $this->Loyalty;
    }
    /**
     * Set Loyalty value
     * @param \Sabre\TravelItineraryRead\Structs\Loyalty $loyalty
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setLoyalty(\Sabre\TravelItineraryRead\Structs\Loyalty $loyalty = null)
    {
        $this->Loyalty = $loyalty;
        return $this;
    }
    /**
     * Get AncillaryProduct value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryProductObject|null
     */
    public function getAncillaryProduct()
    {
        return $this->AncillaryProduct;
    }
    /**
     * Set AncillaryProduct value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryProductObject $ancillaryProduct
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setAncillaryProduct(\Sabre\TravelItineraryRead\Structs\AncillaryProductObject $ancillaryProduct = null)
    {
        $this->AncillaryProduct = $ancillaryProduct;
        return $this;
    }
    /**
     * Get InvoiceData value
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData|null
     */
    public function getInvoiceData()
    {
        return $this->InvoiceData;
    }
    /**
     * Set InvoiceData value
     * @param \Sabre\TravelItineraryRead\Structs\InvoiceData $invoiceData
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setInvoiceData(\Sabre\TravelItineraryRead\Structs\InvoiceData $invoiceData = null)
    {
        $this->InvoiceData = $invoiceData;
        return $this;
    }
    /**
     * Get AccountingField value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingField|null
     */
    public function getAccountingField()
    {
        return $this->AccountingField;
    }
    /**
     * Set AccountingField value
     * @param \Sabre\TravelItineraryRead\Structs\AccountingField $accountingField
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setAccountingField(\Sabre\TravelItineraryRead\Structs\AccountingField $accountingField = null)
    {
        $this->AccountingField = $accountingField;
        return $this;
    }
    /**
     * Get ServiceRequest value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRequestType|null
     */
    public function getServiceRequest()
    {
        return $this->ServiceRequest;
    }
    /**
     * Set ServiceRequest value
     * @param \Sabre\TravelItineraryRead\Structs\ServiceRequestType $serviceRequest
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setServiceRequest(\Sabre\TravelItineraryRead\Structs\ServiceRequestType $serviceRequest = null)
    {
        $this->ServiceRequest = $serviceRequest;
        return $this;
    }
    /**
     * Get Email value
     * @return \Sabre\TravelItineraryRead\Structs\Email|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @param \Sabre\TravelItineraryRead\Structs\Email $email
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setEmail(\Sabre\TravelItineraryRead\Structs\Email $email = null)
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Get PriceCache value
     * @return \Sabre\TravelItineraryRead\Structs\PriceCache|null
     */
    public function getPriceCache()
    {
        return $this->PriceCache;
    }
    /**
     * Set PriceCache value
     * @param \Sabre\TravelItineraryRead\Structs\PriceCache $priceCache
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setPriceCache(\Sabre\TravelItineraryRead\Structs\PriceCache $priceCache = null)
    {
        $this->PriceCache = $priceCache;
        return $this;
    }
    /**
     * Get InsuranceOptOut value
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceOptOut|null
     */
    public function getInsuranceOptOut()
    {
        return $this->InsuranceOptOut;
    }
    /**
     * Set InsuranceOptOut value
     * @param \Sabre\TravelItineraryRead\Structs\InsuranceOptOut $insuranceOptOut
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setInsuranceOptOut(\Sabre\TravelItineraryRead\Structs\InsuranceOptOut $insuranceOptOut = null)
    {
        $this->InsuranceOptOut = $insuranceOptOut;
        return $this;
    }
    /**
     * Get TripProposalReference value
     * @return \Sabre\TravelItineraryRead\Structs\TripProposalReference|null
     */
    public function getTripProposalReference()
    {
        return $this->TripProposalReference;
    }
    /**
     * Set TripProposalReference value
     * @param \Sabre\TravelItineraryRead\Structs\TripProposalReference $tripProposalReference
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setTripProposalReference(\Sabre\TravelItineraryRead\Structs\TripProposalReference $tripProposalReference = null)
    {
        $this->TripProposalReference = $tripProposalReference;
        return $this;
    }
    /**
     * Get SegmentAssociation value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociation|null
     */
    public function getSegmentAssociation()
    {
        return $this->SegmentAssociation;
    }
    /**
     * Set SegmentAssociation value
     * @param \Sabre\TravelItineraryRead\Structs\SegmentAssociation $segmentAssociation
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setSegmentAssociation(\Sabre\TravelItineraryRead\Structs\SegmentAssociation $segmentAssociation = null)
    {
        $this->SegmentAssociation = $segmentAssociation;
        return $this;
    }
    /**
     * Get NameAssociation value
     * @return \Sabre\TravelItineraryRead\Structs\NameAssociationTag|null
     */
    public function getNameAssociation()
    {
        return $this->NameAssociation;
    }
    /**
     * Set NameAssociation value
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag $nameAssociation
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setNameAssociation(\Sabre\TravelItineraryRead\Structs\NameAssociationTag $nameAssociation = null)
    {
        $this->NameAssociation = $nameAssociation;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get displayIndex value
     * @return int|null
     */
    public function getDisplayIndex()
    {
        return $this->displayIndex;
    }
    /**
     * Set displayIndex value
     * @param int $displayIndex
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setDisplayIndex($displayIndex = null)
    {
        $this->displayIndex = $displayIndex;
        return $this;
    }
    /**
     * Get elementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->elementId;
    }
    /**
     * Set elementId value
     * @param string $elementId
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public function setElementId($elementId = null)
    {
        $this->elementId = $elementId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\OpenReservationElementType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
