<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyProgramRedemption Structs
 * @subpackage Structs
 */
class LoyaltyProgramRedemption extends AbstractStructBase
{
    /**
     * The MembershipNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MembershipNumber;
    /**
     * The ProgramName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ProgramName;
    /**
     * The MemberName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MemberName;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Vendor;
    /**
     * The TierLevel
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TierLevel[]
     */
    public $TierLevel;
    /**
     * The LocalCardNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $LocalCardNumber;
    /**
     * Constructor method for LoyaltyProgramRedemption
     * @uses LoyaltyProgramRedemption::setMembershipNumber()
     * @uses LoyaltyProgramRedemption::setProgramName()
     * @uses LoyaltyProgramRedemption::setMemberName()
     * @uses LoyaltyProgramRedemption::setVendor()
     * @uses LoyaltyProgramRedemption::setTierLevel()
     * @uses LoyaltyProgramRedemption::setLocalCardNumber()
     * @param string $membershipNumber
     * @param string $programName
     * @param string $memberName
     * @param string $vendor
     * @param \Sabre\TravelItineraryRead\Structs\TierLevel[] $tierLevel
     * @param string $localCardNumber
     */
    public function __construct($membershipNumber = null, $programName = null, $memberName = null, $vendor = null, array $tierLevel = array(), $localCardNumber = null)
    {
        $this
            ->setMembershipNumber($membershipNumber)
            ->setProgramName($programName)
            ->setMemberName($memberName)
            ->setVendor($vendor)
            ->setTierLevel($tierLevel)
            ->setLocalCardNumber($localCardNumber);
    }
    /**
     * Get MembershipNumber value
     * @return string
     */
    public function getMembershipNumber()
    {
        return $this->MembershipNumber;
    }
    /**
     * Set MembershipNumber value
     * @param string $membershipNumber
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        $this->MembershipNumber = $membershipNumber;
        return $this;
    }
    /**
     * Get ProgramName value
     * @return string|null
     */
    public function getProgramName()
    {
        return $this->ProgramName;
    }
    /**
     * Set ProgramName value
     * @param string $programName
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setProgramName($programName = null)
    {
        $this->ProgramName = $programName;
        return $this;
    }
    /**
     * Get MemberName value
     * @return string|null
     */
    public function getMemberName()
    {
        return $this->MemberName;
    }
    /**
     * Set MemberName value
     * @param string $memberName
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setMemberName($memberName = null)
    {
        $this->MemberName = $memberName;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get TierLevel value
     * @return \Sabre\TravelItineraryRead\Structs\TierLevel[]|null
     */
    public function getTierLevel()
    {
        return $this->TierLevel;
    }
    /**
     * Set TierLevel value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TierLevel[] $tierLevel
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setTierLevel(array $tierLevel = array())
    {
        $this->TierLevel = $tierLevel;
        return $this;
    }
    /**
     * Add item to TierLevel value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TierLevel $item
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function addToTierLevel(\Sabre\TravelItineraryRead\Structs\TierLevel $item)
    {
        $this->TierLevel[] = $item;
        return $this;
    }
    /**
     * Get LocalCardNumber value
     * @return string|null
     */
    public function getLocalCardNumber()
    {
        return $this->LocalCardNumber;
    }
    /**
     * Set LocalCardNumber value
     * @param string $localCardNumber
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public function setLocalCardNumber($localCardNumber = null)
    {
        $this->LocalCardNumber = $localCardNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyProgramRedemption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
