<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceType Structs
 * @subpackage Structs
 */
class InsuranceType extends AbstractStructBase
{
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - documentation: "ConfirmationNumber" is used to return the confirmation number associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The QuoteID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\QuoteID
     */
    public $QuoteID;
    /**
     * The Coverages
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Coverages
     */
    public $Coverages;
    /**
     * The AddOns
     * @var \Sabre\TravelItineraryRead\Structs\AddOns
     */
    public $AddOns;
    /**
     * The Excess
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Excess;
    /**
     * The Cancellation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Cancellation;
    /**
     * The Commission
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Commission;
    /**
     * The PremiumAmount
     * Meta informations extracted from the WSDL
     * - documentation: "PremiumAmount" is used to return the insurance premium amount associated with the particular insurance segment including discounts.
     * - minOccurs: 0
     * @var string
     */
    public $PremiumAmount;
    /**
     * The PremiumGrossAmount
     * Meta informations extracted from the WSDL
     * - documentation: "PremiumGrossAmount" is used to return the insurance premium amount associated with the particular insurance segment before any discount applies.
     * - minOccurs: 0
     * @var string
     */
    public $PremiumGrossAmount;
    /**
     * The PremiumPerDay
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PremiumPerDay;
    /**
     * The DestinationLocation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\DestinationLocation[]
     */
    public $DestinationLocation;
    /**
     * The OriginLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\OriginLocation
     */
    public $OriginLocation;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Payment
     */
    public $Payment;
    /**
     * The Travelers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Travelers
     */
    public $Travelers;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return specialized instructions associated with the particular insurance segment.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public $Vendor;
    /**
     * The PriceDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public $PriceDetails;
    /**
     * The Declarations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Declarations
     */
    public $Declarations;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the insurance premium currency code associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $currencyCode;
    /**
     * The end
     * Meta informations extracted from the WSDL
     * - documentation: "End" is used to return the end date of the insurance coverage. The formate is MM:DD | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $end;
    /**
     * The numberOfPolicies
     * Meta informations extracted from the WSDL
     * - documentation: "numberOfPolicies" is used to return the number of policies associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $numberOfPolicies;
    /**
     * The productCode
     * Meta informations extracted from the WSDL
     * - documentation: "ProductType" is used to return the insurance plan type/code.
     * - use: optional
     * @var string
     */
    public $productCode;
    /**
     * The productName
     * Meta informations extracted from the WSDL
     * - documentation: "ProductType" is used to return the insurance plan type/code.
     * - use: optional
     * @var string
     */
    public $productName;
    /**
     * The planType
     * Meta informations extracted from the WSDL
     * - documentation: "PlanType" is used to return the insurance plan type/code.
     * - use: optional
     * @var string
     */
    public $planType;
    /**
     * The planName
     * Meta informations extracted from the WSDL
     * - documentation: "PlanType" is used to return the insurance plan type/code.
     * - use: optional
     * @var string
     */
    public $planName;
    /**
     * The tripType
     * Meta informations extracted from the WSDL
     * - documentation: "PlanType" is used to return the insurance plan type/code.
     * - use: optional
     * @var string
     */
    public $tripType;
    /**
     * The minAge
     * Meta informations extracted from the WSDL
     * - documentation: Minimum age supported in the product.
     * - use: optional
     * @var int
     */
    public $minAge;
    /**
     * The maxAge
     * Meta informations extracted from the WSDL
     * - documentation: Maximum age supported in the product.
     * - use: optional
     * @var int
     */
    public $maxAge;
    /**
     * The purchaseDate
     * Meta informations extracted from the WSDL
     * - documentation: "PurchaseDate" is used to return the purchase date of the insurance. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss",
     * "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $purchaseDate;
    /**
     * The start
     * Meta informations extracted from the WSDL
     * - documentation: "Start" is used to return the start date and time of the insurance coverage. The formate is MM:DDTHH:MM | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - use: optional
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $start;
    /**
     * Constructor method for InsuranceType
     * @uses InsuranceType::setConfirmationNumber()
     * @uses InsuranceType::setQuoteID()
     * @uses InsuranceType::setCoverages()
     * @uses InsuranceType::setAddOns()
     * @uses InsuranceType::setExcess()
     * @uses InsuranceType::setCancellation()
     * @uses InsuranceType::setCommission()
     * @uses InsuranceType::setPremiumAmount()
     * @uses InsuranceType::setPremiumGrossAmount()
     * @uses InsuranceType::setPremiumPerDay()
     * @uses InsuranceType::setDestinationLocation()
     * @uses InsuranceType::setOriginLocation()
     * @uses InsuranceType::setPayment()
     * @uses InsuranceType::setTravelers()
     * @uses InsuranceType::setText()
     * @uses InsuranceType::setVendor()
     * @uses InsuranceType::setPriceDetails()
     * @uses InsuranceType::setDeclarations()
     * @uses InsuranceType::setCurrencyCode()
     * @uses InsuranceType::setEnd()
     * @uses InsuranceType::setNumberOfPolicies()
     * @uses InsuranceType::setProductCode()
     * @uses InsuranceType::setProductName()
     * @uses InsuranceType::setPlanType()
     * @uses InsuranceType::setPlanName()
     * @uses InsuranceType::setTripType()
     * @uses InsuranceType::setMinAge()
     * @uses InsuranceType::setMaxAge()
     * @uses InsuranceType::setPurchaseDate()
     * @uses InsuranceType::setStart()
     * @param string $confirmationNumber
     * @param \Sabre\TravelItineraryRead\Structs\QuoteID $quoteID
     * @param \Sabre\TravelItineraryRead\Structs\Coverages $coverages
     * @param \Sabre\TravelItineraryRead\Structs\AddOns $addOns
     * @param string $excess
     * @param string $cancellation
     * @param string $commission
     * @param string $premiumAmount
     * @param string $premiumGrossAmount
     * @param string $premiumPerDay
     * @param \Sabre\TravelItineraryRead\Structs\DestinationLocation[] $destinationLocation
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @param \Sabre\TravelItineraryRead\Structs\Travelers $travelers
     * @param string $text
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $priceDetails
     * @param \Sabre\TravelItineraryRead\Structs\Declarations $declarations
     * @param string $currencyCode
     * @param string $end
     * @param string $numberOfPolicies
     * @param string $productCode
     * @param string $productName
     * @param string $planType
     * @param string $planName
     * @param string $tripType
     * @param int $minAge
     * @param int $maxAge
     * @param string $purchaseDate
     * @param string $start
     */
    public function __construct($confirmationNumber = null, \Sabre\TravelItineraryRead\Structs\QuoteID $quoteID = null, \Sabre\TravelItineraryRead\Structs\Coverages $coverages = null, \Sabre\TravelItineraryRead\Structs\AddOns $addOns = null, $excess = null, $cancellation = null, $commission = null, $premiumAmount = null, $premiumGrossAmount = null, $premiumPerDay = null, array $destinationLocation = array(), \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null, \Sabre\TravelItineraryRead\Structs\Payment $payment = null, \Sabre\TravelItineraryRead\Structs\Travelers $travelers = null, $text = null, \Sabre\TravelItineraryRead\Structs\Vendor $vendor = null, \Sabre\TravelItineraryRead\Structs\PricingElementsType $priceDetails = null, \Sabre\TravelItineraryRead\Structs\Declarations $declarations = null, $currencyCode = null, $end = null, $numberOfPolicies = null, $productCode = null, $productName = null, $planType = null, $planName = null, $tripType = null, $minAge = null, $maxAge = null, $purchaseDate = null, $start = null)
    {
        $this
            ->setConfirmationNumber($confirmationNumber)
            ->setQuoteID($quoteID)
            ->setCoverages($coverages)
            ->setAddOns($addOns)
            ->setExcess($excess)
            ->setCancellation($cancellation)
            ->setCommission($commission)
            ->setPremiumAmount($premiumAmount)
            ->setPremiumGrossAmount($premiumGrossAmount)
            ->setPremiumPerDay($premiumPerDay)
            ->setDestinationLocation($destinationLocation)
            ->setOriginLocation($originLocation)
            ->setPayment($payment)
            ->setTravelers($travelers)
            ->setText($text)
            ->setVendor($vendor)
            ->setPriceDetails($priceDetails)
            ->setDeclarations($declarations)
            ->setCurrencyCode($currencyCode)
            ->setEnd($end)
            ->setNumberOfPolicies($numberOfPolicies)
            ->setProductCode($productCode)
            ->setProductName($productName)
            ->setPlanType($planType)
            ->setPlanName($planName)
            ->setTripType($tripType)
            ->setMinAge($minAge)
            ->setMaxAge($maxAge)
            ->setPurchaseDate($purchaseDate)
            ->setStart($start);
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return \Sabre\TravelItineraryRead\Structs\QuoteID|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param \Sabre\TravelItineraryRead\Structs\QuoteID $quoteID
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setQuoteID(\Sabre\TravelItineraryRead\Structs\QuoteID $quoteID = null)
    {
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Get Coverages value
     * @return \Sabre\TravelItineraryRead\Structs\Coverages|null
     */
    public function getCoverages()
    {
        return $this->Coverages;
    }
    /**
     * Set Coverages value
     * @param \Sabre\TravelItineraryRead\Structs\Coverages $coverages
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setCoverages(\Sabre\TravelItineraryRead\Structs\Coverages $coverages = null)
    {
        $this->Coverages = $coverages;
        return $this;
    }
    /**
     * Get AddOns value
     * @return \Sabre\TravelItineraryRead\Structs\AddOns|null
     */
    public function getAddOns()
    {
        return $this->AddOns;
    }
    /**
     * Set AddOns value
     * @param \Sabre\TravelItineraryRead\Structs\AddOns $addOns
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setAddOns(\Sabre\TravelItineraryRead\Structs\AddOns $addOns = null)
    {
        $this->AddOns = $addOns;
        return $this;
    }
    /**
     * Get Excess value
     * @return string|null
     */
    public function getExcess()
    {
        return $this->Excess;
    }
    /**
     * Set Excess value
     * @param string $excess
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setExcess($excess = null)
    {
        $this->Excess = $excess;
        return $this;
    }
    /**
     * Get Cancellation value
     * @return string|null
     */
    public function getCancellation()
    {
        return $this->Cancellation;
    }
    /**
     * Set Cancellation value
     * @param string $cancellation
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setCancellation($cancellation = null)
    {
        $this->Cancellation = $cancellation;
        return $this;
    }
    /**
     * Get Commission value
     * @return string|null
     */
    public function getCommission()
    {
        return $this->Commission;
    }
    /**
     * Set Commission value
     * @param string $commission
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setCommission($commission = null)
    {
        $this->Commission = $commission;
        return $this;
    }
    /**
     * Get PremiumAmount value
     * @return string|null
     */
    public function getPremiumAmount()
    {
        return $this->PremiumAmount;
    }
    /**
     * Set PremiumAmount value
     * @param string $premiumAmount
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPremiumAmount($premiumAmount = null)
    {
        $this->PremiumAmount = $premiumAmount;
        return $this;
    }
    /**
     * Get PremiumGrossAmount value
     * @return string|null
     */
    public function getPremiumGrossAmount()
    {
        return $this->PremiumGrossAmount;
    }
    /**
     * Set PremiumGrossAmount value
     * @param string $premiumGrossAmount
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPremiumGrossAmount($premiumGrossAmount = null)
    {
        $this->PremiumGrossAmount = $premiumGrossAmount;
        return $this;
    }
    /**
     * Get PremiumPerDay value
     * @return string|null
     */
    public function getPremiumPerDay()
    {
        return $this->PremiumPerDay;
    }
    /**
     * Set PremiumPerDay value
     * @param string $premiumPerDay
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPremiumPerDay($premiumPerDay = null)
    {
        $this->PremiumPerDay = $premiumPerDay;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation[]|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\DestinationLocation[] $destinationLocation
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setDestinationLocation(array $destinationLocation = array())
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Add item to DestinationLocation value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\DestinationLocation $item
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function addToDestinationLocation(\Sabre\TravelItineraryRead\Structs\DestinationLocation $item)
    {
        $this->DestinationLocation[] = $item;
        return $this;
    }
    /**
     * Get OriginLocation value
     * @return \Sabre\TravelItineraryRead\Structs\OriginLocation|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param \Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setOriginLocation(\Sabre\TravelItineraryRead\Structs\OriginLocation $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\TravelItineraryRead\Structs\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPayment(\Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get Travelers value
     * @return \Sabre\TravelItineraryRead\Structs\Travelers|null
     */
    public function getTravelers()
    {
        return $this->Travelers;
    }
    /**
     * Set Travelers value
     * @param \Sabre\TravelItineraryRead\Structs\Travelers $travelers
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setTravelers(\Sabre\TravelItineraryRead\Structs\Travelers $travelers = null)
    {
        $this->Travelers = $travelers;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get PriceDetails value
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType|null
     */
    public function getPriceDetails()
    {
        return $this->PriceDetails;
    }
    /**
     * Set PriceDetails value
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $priceDetails
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPriceDetails(\Sabre\TravelItineraryRead\Structs\PricingElementsType $priceDetails = null)
    {
        $this->PriceDetails = $priceDetails;
        return $this;
    }
    /**
     * Get Declarations value
     * @return \Sabre\TravelItineraryRead\Structs\Declarations|null
     */
    public function getDeclarations()
    {
        return $this->Declarations;
    }
    /**
     * Set Declarations value
     * @param \Sabre\TravelItineraryRead\Structs\Declarations $declarations
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setDeclarations(\Sabre\TravelItineraryRead\Structs\Declarations $declarations = null)
    {
        $this->Declarations = $declarations;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get end value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->end;
    }
    /**
     * Set end value
     * @param string $end
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setEnd($end = null)
    {
        $this->end = $end;
        return $this;
    }
    /**
     * Get numberOfPolicies value
     * @return string|null
     */
    public function getNumberOfPolicies()
    {
        return $this->numberOfPolicies;
    }
    /**
     * Set numberOfPolicies value
     * @param string $numberOfPolicies
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setNumberOfPolicies($numberOfPolicies = null)
    {
        $this->numberOfPolicies = $numberOfPolicies;
        return $this;
    }
    /**
     * Get productCode value
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->productCode;
    }
    /**
     * Set productCode value
     * @param string $productCode
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setProductCode($productCode = null)
    {
        $this->productCode = $productCode;
        return $this;
    }
    /**
     * Get productName value
     * @return string|null
     */
    public function getProductName()
    {
        return $this->productName;
    }
    /**
     * Set productName value
     * @param string $productName
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setProductName($productName = null)
    {
        $this->productName = $productName;
        return $this;
    }
    /**
     * Get planType value
     * @return string|null
     */
    public function getPlanType()
    {
        return $this->planType;
    }
    /**
     * Set planType value
     * @param string $planType
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPlanType($planType = null)
    {
        $this->planType = $planType;
        return $this;
    }
    /**
     * Get planName value
     * @return string|null
     */
    public function getPlanName()
    {
        return $this->planName;
    }
    /**
     * Set planName value
     * @param string $planName
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPlanName($planName = null)
    {
        $this->planName = $planName;
        return $this;
    }
    /**
     * Get tripType value
     * @return string|null
     */
    public function getTripType()
    {
        return $this->tripType;
    }
    /**
     * Set tripType value
     * @param string $tripType
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setTripType($tripType = null)
    {
        $this->tripType = $tripType;
        return $this;
    }
    /**
     * Get minAge value
     * @return int|null
     */
    public function getMinAge()
    {
        return $this->minAge;
    }
    /**
     * Set minAge value
     * @param int $minAge
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setMinAge($minAge = null)
    {
        $this->minAge = $minAge;
        return $this;
    }
    /**
     * Get maxAge value
     * @return int|null
     */
    public function getMaxAge()
    {
        return $this->maxAge;
    }
    /**
     * Set maxAge value
     * @param int $maxAge
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setMaxAge($maxAge = null)
    {
        $this->maxAge = $maxAge;
        return $this;
    }
    /**
     * Get purchaseDate value
     * @return string|null
     */
    public function getPurchaseDate()
    {
        return $this->purchaseDate;
    }
    /**
     * Set purchaseDate value
     * @param string $purchaseDate
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setPurchaseDate($purchaseDate = null)
    {
        $this->purchaseDate = $purchaseDate;
        return $this;
    }
    /**
     * Get start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->start;
    }
    /**
     * Set start value
     * @param string $start
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public function setStart($start = null)
    {
        $this->start = $start;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\InsuranceType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
