<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FeeInformation Structs
 * @subpackage Structs
 */
class FeeInformation extends AbstractStructBase
{
    /**
     * The AssociatedData
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AssociatedData[]
     */
    public $AssociatedData;
    /**
     * The AccountData
     * Meta informations extracted from the WSDL
     * - documentation: "AccountData" is used to return ticketing fee account-related information.
     * - use: optional
     * @var string
     */
    public $AccountData;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the ticketing fee amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The DisplayOnOutputInd
     * Meta informations extracted from the WSDL
     * - documentation: "DisplayOnOutputInd" is used to is used to indicate whether or not the fee is displayed on output.
     * - use: optional
     * @var string
     */
    public $DisplayOnOutputInd;
    /**
     * The FunctionCode
     * Meta informations extracted from the WSDL
     * - documentation: "FunctionCode" is used to return the ticketing fee function code.
     * - use: optional
     * @var string
     */
    public $FunctionCode;
    /**
     * The GuaranteeType
     * Meta informations extracted from the WSDL
     * - documentation: "GuaranteeType" is used to return the ticketing fee guarantee type.
     * - use: optional
     * @var string
     */
    public $GuaranteeType;
    /**
     * The NonCommissionInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonCommissionInd" is used to is used to indicate whether or not the fee is commission eligible.
     * - use: optional
     * @var string
     */
    public $NonCommissionInd;
    /**
     * The NonRefundableInd
     * Meta informations extracted from the WSDL
     * - documentation: "NonRefundableInd" is used to is used to indicate whether or not the fee is refundable.
     * - use: optional
     * @var string
     */
    public $NonRefundableInd;
    /**
     * The OnlineInterlineService
     * Meta informations extracted from the WSDL
     * - documentation: "OnlineInterlineService" is used to is used to return online/interline-related information.
     * - use: optional
     * @var string
     */
    public $OnlineInterlineService;
    /**
     * The ServiceType
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceType" is used to return the ticketing fee service type.
     * - use: optional
     * @var string
     */
    public $ServiceType;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Currency Code.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: Ob Fee Description
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * Constructor method for FeeInformation
     * @uses FeeInformation::setAssociatedData()
     * @uses FeeInformation::setAccountData()
     * @uses FeeInformation::setAmount()
     * @uses FeeInformation::setDisplayOnOutputInd()
     * @uses FeeInformation::setFunctionCode()
     * @uses FeeInformation::setGuaranteeType()
     * @uses FeeInformation::setNonCommissionInd()
     * @uses FeeInformation::setNonRefundableInd()
     * @uses FeeInformation::setOnlineInterlineService()
     * @uses FeeInformation::setServiceType()
     * @uses FeeInformation::setCurrencyCode()
     * @uses FeeInformation::setDescription()
     * @param \Sabre\TravelItineraryRead\Structs\AssociatedData[] $associatedData
     * @param string $accountData
     * @param string $amount
     * @param string $displayOnOutputInd
     * @param string $functionCode
     * @param string $guaranteeType
     * @param string $nonCommissionInd
     * @param string $nonRefundableInd
     * @param string $onlineInterlineService
     * @param string $serviceType
     * @param string $currencyCode
     * @param string $description
     */
    public function __construct(array $associatedData = array(), $accountData = null, $amount = null, $displayOnOutputInd = null, $functionCode = null, $guaranteeType = null, $nonCommissionInd = null, $nonRefundableInd = null, $onlineInterlineService = null, $serviceType = null, $currencyCode = null, $description = null)
    {
        $this
            ->setAssociatedData($associatedData)
            ->setAccountData($accountData)
            ->setAmount($amount)
            ->setDisplayOnOutputInd($displayOnOutputInd)
            ->setFunctionCode($functionCode)
            ->setGuaranteeType($guaranteeType)
            ->setNonCommissionInd($nonCommissionInd)
            ->setNonRefundableInd($nonRefundableInd)
            ->setOnlineInterlineService($onlineInterlineService)
            ->setServiceType($serviceType)
            ->setCurrencyCode($currencyCode)
            ->setDescription($description);
    }
    /**
     * Get AssociatedData value
     * @return \Sabre\TravelItineraryRead\Structs\AssociatedData[]|null
     */
    public function getAssociatedData()
    {
        return $this->AssociatedData;
    }
    /**
     * Set AssociatedData value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AssociatedData[] $associatedData
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setAssociatedData(array $associatedData = array())
    {
        $this->AssociatedData = $associatedData;
        return $this;
    }
    /**
     * Add item to AssociatedData value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AssociatedData $item
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function addToAssociatedData(\Sabre\TravelItineraryRead\Structs\AssociatedData $item)
    {
        $this->AssociatedData[] = $item;
        return $this;
    }
    /**
     * Get AccountData value
     * @return string|null
     */
    public function getAccountData()
    {
        return $this->AccountData;
    }
    /**
     * Set AccountData value
     * @param string $accountData
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setAccountData($accountData = null)
    {
        $this->AccountData = $accountData;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get DisplayOnOutputInd value
     * @return string|null
     */
    public function getDisplayOnOutputInd()
    {
        return $this->DisplayOnOutputInd;
    }
    /**
     * Set DisplayOnOutputInd value
     * @param string $displayOnOutputInd
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setDisplayOnOutputInd($displayOnOutputInd = null)
    {
        $this->DisplayOnOutputInd = $displayOnOutputInd;
        return $this;
    }
    /**
     * Get FunctionCode value
     * @return string|null
     */
    public function getFunctionCode()
    {
        return $this->FunctionCode;
    }
    /**
     * Set FunctionCode value
     * @param string $functionCode
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setFunctionCode($functionCode = null)
    {
        $this->FunctionCode = $functionCode;
        return $this;
    }
    /**
     * Get GuaranteeType value
     * @return string|null
     */
    public function getGuaranteeType()
    {
        return $this->GuaranteeType;
    }
    /**
     * Set GuaranteeType value
     * @param string $guaranteeType
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setGuaranteeType($guaranteeType = null)
    {
        $this->GuaranteeType = $guaranteeType;
        return $this;
    }
    /**
     * Get NonCommissionInd value
     * @return string|null
     */
    public function getNonCommissionInd()
    {
        return $this->NonCommissionInd;
    }
    /**
     * Set NonCommissionInd value
     * @param string $nonCommissionInd
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setNonCommissionInd($nonCommissionInd = null)
    {
        $this->NonCommissionInd = $nonCommissionInd;
        return $this;
    }
    /**
     * Get NonRefundableInd value
     * @return string|null
     */
    public function getNonRefundableInd()
    {
        return $this->NonRefundableInd;
    }
    /**
     * Set NonRefundableInd value
     * @param string $nonRefundableInd
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setNonRefundableInd($nonRefundableInd = null)
    {
        $this->NonRefundableInd = $nonRefundableInd;
        return $this;
    }
    /**
     * Get OnlineInterlineService value
     * @return string|null
     */
    public function getOnlineInterlineService()
    {
        return $this->OnlineInterlineService;
    }
    /**
     * Set OnlineInterlineService value
     * @param string $onlineInterlineService
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setOnlineInterlineService($onlineInterlineService = null)
    {
        $this->OnlineInterlineService = $onlineInterlineService;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return string|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param string $serviceType
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setServiceType($serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\FeeInformation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
