<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Email Structs
 * Meta informations extracted from the WSDL
 * - documentation: "Email" is used to return the passenger's email address.
 * - type: Email
 * @subpackage Structs
 */
class Email extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Address;
    /**
     * The comment
     * Meta informations extracted from the WSDL
     * - documentation: Comment contains all additinal data for email
     * - use: optional
     * @var string
     */
    public $comment;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Parsed type of email addres
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Parsed name for email address
     * - use: optional
     * @var string
     */
    public $name;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Comment
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Comment;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Email
     * @uses Email::setAddress()
     * @uses Email::setComment()
     * @uses Email::setType()
     * @uses Email::setName()
     * @uses Email::set_()
     * @uses Email::setId()
     * @uses Email::setComment_1()
     * @uses Email::setType_1()
     * @uses Email::setName_1()
     * @param string $address
     * @param string $comment
     * @param string $type
     * @param string $name
     * @param string $_
     * @param string $id
     * @param string $comment
     * @param string $type
     * @param string $name
     */
    public function __construct($address = null, $comment = null, $type = null, $name = null, $_ = null, $id = null, $comment = null, $type = null, $name = null)
    {
        $this
            ->setAddress($address)
            ->setComment($comment)
            ->setType($type)
            ->setName($name)
            ->set_($_)
            ->setId($id)
            ->setComment_1($comment)
            ->setType_1($type)
            ->setName_1($name);
    }
    /**
     * Get Address value
     * @return string
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setAddress($address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get Comment value
     * @return string|null
     */
    public function getComment()
    {
        return $this->comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setComment($comment = null)
    {
        $this->comment = $comment;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setName($name = null)
    {
        $this->name = $name;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get comment_1 value
     * @return comment_1
     */
    public function getComment_1()
    {
        return $this->Comment;
    }
    /**
     * Set Comment value
     * @param string $comment
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setComment_1($comment = null)
    {
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Get type_1 value
     * @return type_1
     */
    public function getType_1()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setType_1($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get name_1 value
     * @return name_1
     */
    public function getName_1()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public function setName_1($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Email
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
