<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DestinationLocation Structs
 * @subpackage Structs
 */
class DestinationLocation extends AbstractStructBase
{
    /**
     * The locationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the arrival location code associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $locationCode;
    /**
     * The countryCode
     * Meta informations extracted from the WSDL
     * - documentation: "countryCode" is used to return the arrival country associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $countryCode;
    /**
     * The areaCode
     * Meta informations extracted from the WSDL
     * - documentation: "area" is used to return the arrival area associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $areaCode;
    /**
     * The areaName
     * Meta informations extracted from the WSDL
     * - documentation: "area" is used to return the arrival area associated with the particular insurance segment.
     * - use: optional
     * @var string
     */
    public $areaName;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: International or domestic "type" of destination.
     * - use: optional
     * @var string
     */
    public $type;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the destination location code associated with the particular segment. | "LocationCode" is used to return the location code associated with the particular cruise segment. | "LocationCode" is used to
     * return the arrival airport code. | "LocationCode" is used to return the arrival location code associated with the particular insurance segment. | "LocationCode" is used to return the departure location code associated with the particular rail
     * segment. | "LocationCode" is used to return the arrival airport code.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The ArrivalDate
     * Meta informations extracted from the WSDL
     * - documentation: ArrivalDate" is used to return the arrival date associated with the particular cruise segment. ArrivalDate" follows this format: MM:DD | "ArrivalDate" is used to return arrival date information associated with the particular rail
     * segment. "ArrivalDate" follows this format: MM:DD | A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string[]
     */
    public $ArrivalDate;
    /**
     * The ArrivalTime
     * Meta informations extracted from the WSDL
     * - documentation: ArrivalTime" is used to return the arrival time associated with the particular cruise segment. "ArrivalTime" follows this format: MM:DD | "ArrivalTime" is used to return arrival time information associated with the particular rail
     * segment. "ArrivalTime" follows this format: HH:MM | A simple time type. Seconds can be omitted, since those values are not propagated to the Sabre backend systems. Accepted formats: "hh:mm:ss" or "hh:mm"
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - pattern: ([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string[]
     */
    public $ArrivalTime;
    /**
     * The Point
     * Meta informations extracted from the WSDL
     * - documentation: "Point" is used to return the arrival location point associated with the particular cruise segment. | "Point" is used to return the arrival location point associated with the particular rail segment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Point;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - documentation: "LocationName" is used to return the arrival location name associated with the particular cruise segment. | "LocationName" is used to return the arrival location name associated with the particular rail segment.
     * - minOccurs: 0
     * - use: optional
     * @var string
     */
    public $LocationName;
    /**
     * The Terminal
     * Meta informations extracted from the WSDL
     * - documentation: "Terminal" is used to return the arrival airport terminal.
     * - use: optional
     * @var string
     */
    public $Terminal;
    /**
     * The TerminalCode
     * Meta informations extracted from the WSDL
     * - documentation: "TerminalCode" is used to return the arrival airport terminal code.
     * - use: optional
     * @var string
     */
    public $TerminalCode;
    /**
     * Constructor method for DestinationLocation
     * @uses DestinationLocation::setLocationCode()
     * @uses DestinationLocation::setCountryCode()
     * @uses DestinationLocation::setAreaCode()
     * @uses DestinationLocation::setAreaName()
     * @uses DestinationLocation::setType()
     * @uses DestinationLocation::setLocationCode_1()
     * @uses DestinationLocation::setArrivalDate()
     * @uses DestinationLocation::setArrivalTime()
     * @uses DestinationLocation::setPoint()
     * @uses DestinationLocation::setLocationName()
     * @uses DestinationLocation::setTerminal()
     * @uses DestinationLocation::setTerminalCode()
     * @param string $locationCode
     * @param string $countryCode
     * @param string $areaCode
     * @param string $areaName
     * @param string $type
     * @param string $locationCode
     * @param string[] $arrivalDate
     * @param string[] $arrivalTime
     * @param string[] $point
     * @param string $locationName
     * @param string $terminal
     * @param string $terminalCode
     */
    public function __construct($locationCode = null, $countryCode = null, $areaCode = null, $areaName = null, $type = null, $locationCode = null, array $arrivalDate = array(), array $arrivalTime = array(), array $point = array(), $locationName = null, $terminal = null, $terminalCode = null)
    {
        $this
            ->setLocationCode($locationCode)
            ->setCountryCode($countryCode)
            ->setAreaCode($areaCode)
            ->setAreaName($areaName)
            ->setType($type)
            ->setLocationCode_1($locationCode)
            ->setArrivalDate($arrivalDate)
            ->setArrivalTime($arrivalTime)
            ->setPoint($point)
            ->setLocationName($locationName)
            ->setTerminal($terminal)
            ->setTerminalCode($terminalCode);
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->locationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setLocationCode($locationCode = null)
    {
        $this->locationCode = $locationCode;
        return $this;
    }
    /**
     * Get countryCode value
     * @return string|null
     */
    public function getCountryCode()
    {
        return $this->countryCode;
    }
    /**
     * Set countryCode value
     * @param string $countryCode
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setCountryCode($countryCode = null)
    {
        $this->countryCode = $countryCode;
        return $this;
    }
    /**
     * Get areaCode value
     * @return string|null
     */
    public function getAreaCode()
    {
        return $this->areaCode;
    }
    /**
     * Set areaCode value
     * @param string $areaCode
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setAreaCode($areaCode = null)
    {
        $this->areaCode = $areaCode;
        return $this;
    }
    /**
     * Get areaName value
     * @return string|null
     */
    public function getAreaName()
    {
        return $this->areaName;
    }
    /**
     * Set areaName value
     * @param string $areaName
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setAreaName($areaName = null)
    {
        $this->areaName = $areaName;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get locationCode_1 value
     * @return locationCode_1
     */
    public function getLocationCode_1()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setLocationCode_1($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get ArrivalDate value
     * @return string[]|null
     */
    public function getArrivalDate()
    {
        return $this->ArrivalDate;
    }
    /**
     * Set ArrivalDate value
     * @throws \InvalidArgumentException
     * @param string[] $arrivalDate
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setArrivalDate(array $arrivalDate = array())
    {
        $this->ArrivalDate = $arrivalDate;
        return $this;
    }
    /**
     * Add item to ArrivalDate value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function addToArrivalDate($item)
    {
        $this->ArrivalDate[] = $item;
        return $this;
    }
    /**
     * Get ArrivalTime value
     * @return string[]|null
     */
    public function getArrivalTime()
    {
        return $this->ArrivalTime;
    }
    /**
     * Set ArrivalTime value
     * @throws \InvalidArgumentException
     * @param string[] $arrivalTime
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setArrivalTime(array $arrivalTime = array())
    {
        $this->ArrivalTime = $arrivalTime;
        return $this;
    }
    /**
     * Add item to ArrivalTime value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function addToArrivalTime($item)
    {
        $this->ArrivalTime[] = $item;
        return $this;
    }
    /**
     * Get Point value
     * @return string[]|null
     */
    public function getPoint()
    {
        return $this->Point;
    }
    /**
     * Set Point value
     * @throws \InvalidArgumentException
     * @param string[] $point
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setPoint(array $point = array())
    {
        $this->Point = $point;
        return $this;
    }
    /**
     * Add item to Point value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function addToPoint($item)
    {
        $this->Point[] = $item;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setLocationName($locationName = null)
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Get Terminal value
     * @return string|null
     */
    public function getTerminal()
    {
        return $this->Terminal;
    }
    /**
     * Set Terminal value
     * @param string $terminal
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setTerminal($terminal = null)
    {
        $this->Terminal = $terminal;
        return $this;
    }
    /**
     * Get TerminalCode value
     * @return string|null
     */
    public function getTerminalCode()
    {
        return $this->TerminalCode;
    }
    /**
     * Set TerminalCode value
     * @param string $terminalCode
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public function setTerminalCode($terminalCode = null)
    {
        $this->TerminalCode = $terminalCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\DestinationLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
