<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociatedDataItem Structs
 * Meta informations extracted from the WSDL
 * - documentation: "AssociatedDataItem" is used to create the relationship between passenger name data and waiver code
 * @subpackage Structs
 */
class AssociatedDataItem extends AbstractStructBase
{
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The WaiverCode
     * Meta informations extracted from the WSDL
     * - documentation: "WaiverCode" is used to associate the passenger name number to a particular fee waiver code.
     * - use: optional
     * @var string
     */
    public $WaiverCode;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "NameNumber" is used to associate the particular Waiver code number to a particular passenger within the record.
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * Constructor method for AssociatedDataItem
     * @uses AssociatedDataItem::set_()
     * @uses AssociatedDataItem::setWaiverCode()
     * @uses AssociatedDataItem::setNameNumber()
     * @param string $_
     * @param string $waiverCode
     * @param string $nameNumber
     */
    public function __construct($_ = null, $waiverCode = null, $nameNumber = null)
    {
        $this
            ->set_($_)
            ->setWaiverCode($waiverCode)
            ->setNameNumber($nameNumber);
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\TravelItineraryRead\Structs\AssociatedDataItem
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get WaiverCode value
     * @return string|null
     */
    public function getWaiverCode()
    {
        return $this->WaiverCode;
    }
    /**
     * Set WaiverCode value
     * @param string $waiverCode
     * @return \Sabre\TravelItineraryRead\Structs\AssociatedDataItem
     */
    public function setWaiverCode($waiverCode = null)
    {
        $this->WaiverCode = $waiverCode;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\TravelItineraryRead\Structs\AssociatedDataItem
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AssociatedDataItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
