<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VisaType Structs
 * @subpackage Structs
 */
class VisaType extends AbstractStructBase
{
    /**
     * The CustomerResponsibilityID
     * Meta informations extracted from the WSDL
     * - documentation: Customer responsibility ID
     * - minOccurs: 0
     * @var string
     */
    public $CustomerResponsibilityID;
    /**
     * The Rates
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Rates
     */
    public $Rates;
    /**
     * The ServiceFee
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ServiceFee
     */
    public $ServiceFee;
    /**
     * The DestinationCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\DestinationCountry
     */
    public $DestinationCountry;
    /**
     * The ProcessingTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ProcessingTime
     */
    public $ProcessingTime;
    /**
     * The Purpose
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Purpose
     */
    public $Purpose;
    /**
     * The Transit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Transit
     */
    public $Transit;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public $Vendor;
    /**
     * The Duration
     * Meta informations extracted from the WSDL
     * - documentation: Visa duration
     * - minOccurs: 0
     * @var string
     */
    public $Duration;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Payment
     */
    public $Payment;
    /**
     * The PricingElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public $PricingElements;
    /**
     * Constructor method for VisaType
     * @uses VisaType::setCustomerResponsibilityID()
     * @uses VisaType::setRates()
     * @uses VisaType::setServiceFee()
     * @uses VisaType::setDestinationCountry()
     * @uses VisaType::setProcessingTime()
     * @uses VisaType::setPurpose()
     * @uses VisaType::setTransit()
     * @uses VisaType::setVendor()
     * @uses VisaType::setDuration()
     * @uses VisaType::setPayment()
     * @uses VisaType::setPricingElements()
     * @param string $customerResponsibilityID
     * @param \Sabre\TravelItineraryRead\Structs\Rates $rates
     * @param \Sabre\TravelItineraryRead\Structs\ServiceFee $serviceFee
     * @param \Sabre\TravelItineraryRead\Structs\DestinationCountry $destinationCountry
     * @param \Sabre\TravelItineraryRead\Structs\ProcessingTime $processingTime
     * @param \Sabre\TravelItineraryRead\Structs\Purpose $purpose
     * @param \Sabre\TravelItineraryRead\Structs\Transit $transit
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @param string $duration
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements
     */
    public function __construct($customerResponsibilityID = null, \Sabre\TravelItineraryRead\Structs\Rates $rates = null, \Sabre\TravelItineraryRead\Structs\ServiceFee $serviceFee = null, \Sabre\TravelItineraryRead\Structs\DestinationCountry $destinationCountry = null, \Sabre\TravelItineraryRead\Structs\ProcessingTime $processingTime = null, \Sabre\TravelItineraryRead\Structs\Purpose $purpose = null, \Sabre\TravelItineraryRead\Structs\Transit $transit = null, \Sabre\TravelItineraryRead\Structs\Vendor $vendor = null, $duration = null, \Sabre\TravelItineraryRead\Structs\Payment $payment = null, \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements = null)
    {
        $this
            ->setCustomerResponsibilityID($customerResponsibilityID)
            ->setRates($rates)
            ->setServiceFee($serviceFee)
            ->setDestinationCountry($destinationCountry)
            ->setProcessingTime($processingTime)
            ->setPurpose($purpose)
            ->setTransit($transit)
            ->setVendor($vendor)
            ->setDuration($duration)
            ->setPayment($payment)
            ->setPricingElements($pricingElements);
    }
    /**
     * Get CustomerResponsibilityID value
     * @return string|null
     */
    public function getCustomerResponsibilityID()
    {
        return $this->CustomerResponsibilityID;
    }
    /**
     * Set CustomerResponsibilityID value
     * @param string $customerResponsibilityID
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setCustomerResponsibilityID($customerResponsibilityID = null)
    {
        $this->CustomerResponsibilityID = $customerResponsibilityID;
        return $this;
    }
    /**
     * Get Rates value
     * @return \Sabre\TravelItineraryRead\Structs\Rates|null
     */
    public function getRates()
    {
        return $this->Rates;
    }
    /**
     * Set Rates value
     * @param \Sabre\TravelItineraryRead\Structs\Rates $rates
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setRates(\Sabre\TravelItineraryRead\Structs\Rates $rates = null)
    {
        $this->Rates = $rates;
        return $this;
    }
    /**
     * Get ServiceFee value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceFee|null
     */
    public function getServiceFee()
    {
        return $this->ServiceFee;
    }
    /**
     * Set ServiceFee value
     * @param \Sabre\TravelItineraryRead\Structs\ServiceFee $serviceFee
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setServiceFee(\Sabre\TravelItineraryRead\Structs\ServiceFee $serviceFee = null)
    {
        $this->ServiceFee = $serviceFee;
        return $this;
    }
    /**
     * Get DestinationCountry value
     * @return \Sabre\TravelItineraryRead\Structs\DestinationCountry|null
     */
    public function getDestinationCountry()
    {
        return $this->DestinationCountry;
    }
    /**
     * Set DestinationCountry value
     * @param \Sabre\TravelItineraryRead\Structs\DestinationCountry $destinationCountry
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setDestinationCountry(\Sabre\TravelItineraryRead\Structs\DestinationCountry $destinationCountry = null)
    {
        $this->DestinationCountry = $destinationCountry;
        return $this;
    }
    /**
     * Get ProcessingTime value
     * @return \Sabre\TravelItineraryRead\Structs\ProcessingTime|null
     */
    public function getProcessingTime()
    {
        return $this->ProcessingTime;
    }
    /**
     * Set ProcessingTime value
     * @param \Sabre\TravelItineraryRead\Structs\ProcessingTime $processingTime
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setProcessingTime(\Sabre\TravelItineraryRead\Structs\ProcessingTime $processingTime = null)
    {
        $this->ProcessingTime = $processingTime;
        return $this;
    }
    /**
     * Get Purpose value
     * @return \Sabre\TravelItineraryRead\Structs\Purpose|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @param \Sabre\TravelItineraryRead\Structs\Purpose $purpose
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setPurpose(\Sabre\TravelItineraryRead\Structs\Purpose $purpose = null)
    {
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get Transit value
     * @return \Sabre\TravelItineraryRead\Structs\Transit|null
     */
    public function getTransit()
    {
        return $this->Transit;
    }
    /**
     * Set Transit value
     * @param \Sabre\TravelItineraryRead\Structs\Transit $transit
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setTransit(\Sabre\TravelItineraryRead\Structs\Transit $transit = null)
    {
        $this->Transit = $transit;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setDuration($duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\TravelItineraryRead\Structs\Payment|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @param \Sabre\TravelItineraryRead\Structs\Payment $payment
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setPayment(\Sabre\TravelItineraryRead\Structs\Payment $payment = null)
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Get PricingElements value
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType|null
     */
    public function getPricingElements()
    {
        return $this->PricingElements;
    }
    /**
     * Set PricingElements value
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public function setPricingElements(\Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements = null)
    {
        $this->PricingElements = $pricingElements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\VisaType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
