<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TransactionInfo Structs
 * @subpackage Structs
 */
class TransactionInfo extends AbstractStructBase
{
    /**
     * The RequestorInfo
     * @var \Sabre\TravelItineraryRead\Structs\RequestorSourceType
     */
    public $RequestorInfo;
    /**
     * The LastUpdateTimeStamp
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the creation date and time of the message in UTC using the following format specified by ISO 8601; YYYY-MM-DDThh:mm:ssZ with time values using the 24 hour clock (e.g. 20 November 2003, 1:59:38 pm UTC becomes
     * 2003-11-20T13:59:38Z). | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $LastUpdateTimeStamp;
    /**
     * Constructor method for TransactionInfo
     * @uses TransactionInfo::setRequestorInfo()
     * @uses TransactionInfo::setLastUpdateTimeStamp()
     * @param \Sabre\TravelItineraryRead\Structs\RequestorSourceType $requestorInfo
     * @param string $lastUpdateTimeStamp
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\RequestorSourceType $requestorInfo = null, $lastUpdateTimeStamp = null)
    {
        $this
            ->setRequestorInfo($requestorInfo)
            ->setLastUpdateTimeStamp($lastUpdateTimeStamp);
    }
    /**
     * Get RequestorInfo value
     * @return \Sabre\TravelItineraryRead\Structs\RequestorSourceType|null
     */
    public function getRequestorInfo()
    {
        return $this->RequestorInfo;
    }
    /**
     * Set RequestorInfo value
     * @param \Sabre\TravelItineraryRead\Structs\RequestorSourceType $requestorInfo
     * @return \Sabre\TravelItineraryRead\Structs\TransactionInfo
     */
    public function setRequestorInfo(\Sabre\TravelItineraryRead\Structs\RequestorSourceType $requestorInfo = null)
    {
        $this->RequestorInfo = $requestorInfo;
        return $this;
    }
    /**
     * Get LastUpdateTimeStamp value
     * @return string|null
     */
    public function getLastUpdateTimeStamp()
    {
        return $this->LastUpdateTimeStamp;
    }
    /**
     * Set LastUpdateTimeStamp value
     * @param string $lastUpdateTimeStamp
     * @return \Sabre\TravelItineraryRead\Structs\TransactionInfo
     */
    public function setLastUpdateTimeStamp($lastUpdateTimeStamp = null)
    {
        $this->LastUpdateTimeStamp = $lastUpdateTimeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TransactionInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
