<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transaction Structs
 * @subpackage Structs
 */
class Transaction extends AbstractStructBase
{
    /**
     * The LastUpdateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $LastUpdateTime;
    /**
     * The DeploymentId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DeploymentId;
    /**
     * The DocumentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DocumentNumber;
    /**
     * The ConfirmationNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The index
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var int
     */
    public $index;
    /**
     * Constructor method for Transaction
     * @uses Transaction::setLastUpdateTime()
     * @uses Transaction::setDeploymentId()
     * @uses Transaction::setDocumentNumber()
     * @uses Transaction::setConfirmationNumber()
     * @uses Transaction::setIndex()
     * @param string $lastUpdateTime
     * @param string $deploymentId
     * @param string $documentNumber
     * @param string $confirmationNumber
     * @param int $index
     */
    public function __construct($lastUpdateTime = null, $deploymentId = null, $documentNumber = null, $confirmationNumber = null, $index = null)
    {
        $this
            ->setLastUpdateTime($lastUpdateTime)
            ->setDeploymentId($deploymentId)
            ->setDocumentNumber($documentNumber)
            ->setConfirmationNumber($confirmationNumber)
            ->setIndex($index);
    }
    /**
     * Get LastUpdateTime value
     * @return string|null
     */
    public function getLastUpdateTime()
    {
        return $this->LastUpdateTime;
    }
    /**
     * Set LastUpdateTime value
     * @param string $lastUpdateTime
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public function setLastUpdateTime($lastUpdateTime = null)
    {
        $this->LastUpdateTime = $lastUpdateTime;
        return $this;
    }
    /**
     * Get DeploymentId value
     * @return string|null
     */
    public function getDeploymentId()
    {
        return $this->DeploymentId;
    }
    /**
     * Set DeploymentId value
     * @param string $deploymentId
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public function setDeploymentId($deploymentId = null)
    {
        $this->DeploymentId = $deploymentId;
        return $this;
    }
    /**
     * Get DocumentNumber value
     * @return string|null
     */
    public function getDocumentNumber()
    {
        return $this->DocumentNumber;
    }
    /**
     * Set DocumentNumber value
     * @param string $documentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public function setDocumentNumber($documentNumber = null)
    {
        $this->DocumentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return $this->ConfirmationNumber;
    }
    /**
     * Set ConfirmationNumber value
     * @param string $confirmationNumber
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        $this->ConfirmationNumber = $confirmationNumber;
        return $this;
    }
    /**
     * Get index value
     * @return int|null
     */
    public function getIndex()
    {
        return $this->index;
    }
    /**
     * Set index value
     * @param int $index
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public function setIndex($index = null)
    {
        $this->index = $index;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Transaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
