<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalTax Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TotalTax" is used to return the total tax details | "TotalTax" is used to return the total tax details
 * @subpackage Structs
 */
class TotalTax extends AbstractStructBase
{
    /**
     * The Tax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Tax[]
     */
    public $Tax;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * Constructor method for TotalTax
     * @uses TotalTax::setTax()
     * @uses TotalTax::setAmount()
     * @uses TotalTax::setCurrencyCode()
     * @param \Sabre\TravelItineraryRead\Structs\Tax[] $tax
     * @param string $amount
     * @param string $currencyCode
     */
    public function __construct(array $tax = array(), $amount = null, $currencyCode = null)
    {
        $this
            ->setTax($tax)
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get Tax value
     * @return \Sabre\TravelItineraryRead\Structs\Tax[]|null
     */
    public function getTax()
    {
        return $this->Tax;
    }
    /**
     * Set Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Tax[] $tax
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public function setTax(array $tax = array())
    {
        $this->Tax = $tax;
        return $this;
    }
    /**
     * Add item to Tax value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Tax $item
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public function addToTax(\Sabre\TravelItineraryRead\Structs\Tax $item)
    {
        $this->Tax[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TotalTax
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
