<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TotalTTLPrice Structs
 * Meta informations extracted from the WSDL
 * - documentation: "TotalTTLPrice" indicates "TTLPrice" multiplied by "NumberOfItems".
 * @subpackage Structs
 */
class TotalTTLPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - documentation: "Price" is used to returns the total TTL price.
     * @var float
     */
    public $Price;
    /**
     * The Currency
     * Meta informations extracted from the WSDL
     * - documentation: "Currency" is used to return the currency used for pricing.
     * - use: optional
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for TotalTTLPrice
     * @uses TotalTTLPrice::setPrice()
     * @uses TotalTTLPrice::setCurrency()
     * @param float $price
     * @param string $currency
     */
    public function __construct($price = null, $currency = null)
    {
        $this
            ->setPrice($price)
            ->setCurrency($currency);
    }
    /**
     * Get Price value
     * @return float|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param float $price
     * @return \Sabre\TravelItineraryRead\Structs\TotalTTLPrice
     */
    public function setPrice($price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \Sabre\TravelItineraryRead\Structs\TotalTTLPrice
     */
    public function setCurrency($currency = null)
    {
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\TotalTTLPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
