<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing Structs
 * @subpackage Structs
 */
class Ticketing extends AbstractStructBase
{
    /**
     * The ConjunctedCount
     * Meta informations extracted from the WSDL
     * - documentation: "ConjunctedCount" is used to return the number of conjuncted eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $ConjunctedCount;
    /**
     * The CouponCount
     * Meta informations extracted from the WSDL
     * - documentation: "CouponCount" is used to return the number of eTicket coupons associated with the particular accounting line if applicable.
     * - use: optional
     * @var string
     */
    public $CouponCount;
    /**
     * The PersonName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PersonName
     */
    public $PersonName;
    /**
     * The eTicketNumber
     * Meta informations extracted from the WSDL
     * - documentation: "eTicketNumber" is used to return ticket-related information.
     * - use: optional
     * @var string
     */
    public $eTicketNumber;
    /**
     * The RPH
     * Meta informations extracted from the WSDL
     * - documentation: "RPH" is used as a reference place holder.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The TicketTimeLimit
     * Meta informations extracted from the WSDL
     * - documentation: "TicketTimeLimit" is used to return the ticket time limit-related information.
     * - use: optional
     * @var string
     */
    public $TicketTimeLimit;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "TicketStatus" is used to return the status of a ticketing document from T2.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Ticketing
     * @uses Ticketing::setConjunctedCount()
     * @uses Ticketing::setCouponCount()
     * @uses Ticketing::setPersonName()
     * @uses Ticketing::setETicketNumber()
     * @uses Ticketing::setRPH()
     * @uses Ticketing::setTicketTimeLimit()
     * @uses Ticketing::setId()
     * @uses Ticketing::setStatus()
     * @param string $conjunctedCount
     * @param string $couponCount
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $personName
     * @param string $eTicketNumber
     * @param string $rPH
     * @param string $ticketTimeLimit
     * @param string $id
     * @param string $status
     */
    public function __construct($conjunctedCount = null, $couponCount = null, \Sabre\TravelItineraryRead\Structs\PersonName $personName = null, $eTicketNumber = null, $rPH = null, $ticketTimeLimit = null, $id = null, $status = null)
    {
        $this
            ->setConjunctedCount($conjunctedCount)
            ->setCouponCount($couponCount)
            ->setPersonName($personName)
            ->setETicketNumber($eTicketNumber)
            ->setRPH($rPH)
            ->setTicketTimeLimit($ticketTimeLimit)
            ->setId($id)
            ->setStatus($status);
    }
    /**
     * Get ConjunctedCount value
     * @return string|null
     */
    public function getConjunctedCount()
    {
        return $this->ConjunctedCount;
    }
    /**
     * Set ConjunctedCount value
     * @param string $conjunctedCount
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setConjunctedCount($conjunctedCount = null)
    {
        $this->ConjunctedCount = $conjunctedCount;
        return $this;
    }
    /**
     * Get CouponCount value
     * @return string|null
     */
    public function getCouponCount()
    {
        return $this->CouponCount;
    }
    /**
     * Set CouponCount value
     * @param string $couponCount
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setCouponCount($couponCount = null)
    {
        $this->CouponCount = $couponCount;
        return $this;
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonName|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\TravelItineraryRead\Structs\PersonName $personName
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setPersonName(\Sabre\TravelItineraryRead\Structs\PersonName $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get eTicketNumber value
     * @return string|null
     */
    public function getETicketNumber()
    {
        return $this->eTicketNumber;
    }
    /**
     * Set eTicketNumber value
     * @param string $eTicketNumber
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setETicketNumber($eTicketNumber = null)
    {
        $this->eTicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setRPH($rPH = null)
    {
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get TicketTimeLimit value
     * @return string|null
     */
    public function getTicketTimeLimit()
    {
        return $this->TicketTimeLimit;
    }
    /**
     * Set TicketTimeLimit value
     * @param string $ticketTimeLimit
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setTicketTimeLimit($ticketTimeLimit = null)
    {
        $this->TicketTimeLimit = $ticketTimeLimit;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Ticketing
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
