<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SkiType Structs
 * Meta informations extracted from the WSDL
 * - documentation: Ski product is used to ski tour sale and processing purposes
 * @subpackage Structs
 */
class SkiType extends AbstractStructBase
{
    /**
     * The Booking
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Booking
     */
    public $Booking;
    /**
     * The ChangePolicy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ChangePolicy
     */
    public $ChangePolicy;
    /**
     * The City
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\City
     */
    public $City;
    /**
     * The ClothingHire
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ClothingHire
     */
    public $ClothingHire;
    /**
     * The EquipmentHire
     * Meta informations extracted from the WSDL
     * - documentation: "EquipmentHire" is used to order ski equipment
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType
     */
    public $EquipmentHire;
    /**
     * The Extras
     * Meta informations extracted from the WSDL
     * - documentation: "Extras" is used to order extra services
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType
     */
    public $Extras;
    /**
     * The Lessons
     * Meta informations extracted from the WSDL
     * - documentation: "Lessons" is used to order ski lessons
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType
     */
    public $Lessons;
    /**
     * The LiftPass
     * Meta informations extracted from the WSDL
     * - documentation: "LiftPass" is used to order ski lift pass
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType
     */
    public $LiftPass;
    /**
     * The Location
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Location
     */
    public $Location;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Vendor
     */
    public $Vendor;
    /**
     * The Transfers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Transfers
     */
    public $Transfers;
    /**
     * The PricingElements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PricingElementsType
     */
    public $PricingElements;
    /**
     * Constructor method for SkiType
     * @uses SkiType::setBooking()
     * @uses SkiType::setChangePolicy()
     * @uses SkiType::setCity()
     * @uses SkiType::setClothingHire()
     * @uses SkiType::setEquipmentHire()
     * @uses SkiType::setExtras()
     * @uses SkiType::setLessons()
     * @uses SkiType::setLiftPass()
     * @uses SkiType::setLocation()
     * @uses SkiType::setVendor()
     * @uses SkiType::setTransfers()
     * @uses SkiType::setPricingElements()
     * @param \Sabre\TravelItineraryRead\Structs\Booking $booking
     * @param \Sabre\TravelItineraryRead\Structs\ChangePolicy $changePolicy
     * @param \Sabre\TravelItineraryRead\Structs\City $city
     * @param \Sabre\TravelItineraryRead\Structs\ClothingHire $clothingHire
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $equipmentHire
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $extras
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $lessons
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $liftPass
     * @param \Sabre\TravelItineraryRead\Structs\Location $location
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @param \Sabre\TravelItineraryRead\Structs\Transfers $transfers
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\Booking $booking = null, \Sabre\TravelItineraryRead\Structs\ChangePolicy $changePolicy = null, \Sabre\TravelItineraryRead\Structs\City $city = null, \Sabre\TravelItineraryRead\Structs\ClothingHire $clothingHire = null, \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $equipmentHire = null, \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $extras = null, \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $lessons = null, \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $liftPass = null, \Sabre\TravelItineraryRead\Structs\Location $location = null, \Sabre\TravelItineraryRead\Structs\Vendor $vendor = null, \Sabre\TravelItineraryRead\Structs\Transfers $transfers = null, \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements = null)
    {
        $this
            ->setBooking($booking)
            ->setChangePolicy($changePolicy)
            ->setCity($city)
            ->setClothingHire($clothingHire)
            ->setEquipmentHire($equipmentHire)
            ->setExtras($extras)
            ->setLessons($lessons)
            ->setLiftPass($liftPass)
            ->setLocation($location)
            ->setVendor($vendor)
            ->setTransfers($transfers)
            ->setPricingElements($pricingElements);
    }
    /**
     * Get Booking value
     * @return \Sabre\TravelItineraryRead\Structs\Booking|null
     */
    public function getBooking()
    {
        return $this->Booking;
    }
    /**
     * Set Booking value
     * @param \Sabre\TravelItineraryRead\Structs\Booking $booking
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setBooking(\Sabre\TravelItineraryRead\Structs\Booking $booking = null)
    {
        $this->Booking = $booking;
        return $this;
    }
    /**
     * Get ChangePolicy value
     * @return \Sabre\TravelItineraryRead\Structs\ChangePolicy|null
     */
    public function getChangePolicy()
    {
        return $this->ChangePolicy;
    }
    /**
     * Set ChangePolicy value
     * @param \Sabre\TravelItineraryRead\Structs\ChangePolicy $changePolicy
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setChangePolicy(\Sabre\TravelItineraryRead\Structs\ChangePolicy $changePolicy = null)
    {
        $this->ChangePolicy = $changePolicy;
        return $this;
    }
    /**
     * Get City value
     * @return \Sabre\TravelItineraryRead\Structs\City|null
     */
    public function getCity()
    {
        return $this->City;
    }
    /**
     * Set City value
     * @param \Sabre\TravelItineraryRead\Structs\City $city
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setCity(\Sabre\TravelItineraryRead\Structs\City $city = null)
    {
        $this->City = $city;
        return $this;
    }
    /**
     * Get ClothingHire value
     * @return \Sabre\TravelItineraryRead\Structs\ClothingHire|null
     */
    public function getClothingHire()
    {
        return $this->ClothingHire;
    }
    /**
     * Set ClothingHire value
     * @param \Sabre\TravelItineraryRead\Structs\ClothingHire $clothingHire
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setClothingHire(\Sabre\TravelItineraryRead\Structs\ClothingHire $clothingHire = null)
    {
        $this->ClothingHire = $clothingHire;
        return $this;
    }
    /**
     * Get EquipmentHire value
     * @return \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType|null
     */
    public function getEquipmentHire()
    {
        return $this->EquipmentHire;
    }
    /**
     * Set EquipmentHire value
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $equipmentHire
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setEquipmentHire(\Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $equipmentHire = null)
    {
        $this->EquipmentHire = $equipmentHire;
        return $this;
    }
    /**
     * Get Extras value
     * @return \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType|null
     */
    public function getExtras()
    {
        return $this->Extras;
    }
    /**
     * Set Extras value
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $extras
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setExtras(\Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $extras = null)
    {
        $this->Extras = $extras;
        return $this;
    }
    /**
     * Get Lessons value
     * @return \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType|null
     */
    public function getLessons()
    {
        return $this->Lessons;
    }
    /**
     * Set Lessons value
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $lessons
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setLessons(\Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $lessons = null)
    {
        $this->Lessons = $lessons;
        return $this;
    }
    /**
     * Get LiftPass value
     * @return \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType|null
     */
    public function getLiftPass()
    {
        return $this->LiftPass;
    }
    /**
     * Set LiftPass value
     * @param \Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $liftPass
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setLiftPass(\Sabre\TravelItineraryRead\Structs\SkiCommonElementsType $liftPass = null)
    {
        $this->LiftPass = $liftPass;
        return $this;
    }
    /**
     * Get Location value
     * @return \Sabre\TravelItineraryRead\Structs\Location|null
     */
    public function getLocation()
    {
        return $this->Location;
    }
    /**
     * Set Location value
     * @param \Sabre\TravelItineraryRead\Structs\Location $location
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setLocation(\Sabre\TravelItineraryRead\Structs\Location $location = null)
    {
        $this->Location = $location;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\Vendor|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\Vendor $vendor
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\Vendor $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Transfers value
     * @return \Sabre\TravelItineraryRead\Structs\Transfers|null
     */
    public function getTransfers()
    {
        return $this->Transfers;
    }
    /**
     * Set Transfers value
     * @param \Sabre\TravelItineraryRead\Structs\Transfers $transfers
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setTransfers(\Sabre\TravelItineraryRead\Structs\Transfers $transfers = null)
    {
        $this->Transfers = $transfers;
        return $this;
    }
    /**
     * Get PricingElements value
     * @return \Sabre\TravelItineraryRead\Structs\PricingElementsType|null
     */
    public function getPricingElements()
    {
        return $this->PricingElements;
    }
    /**
     * Set PricingElements value
     * @param \Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public function setPricingElements(\Sabre\TravelItineraryRead\Structs\PricingElementsType $pricingElements = null)
    {
        $this->PricingElements = $pricingElements;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\SkiType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
