<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Services Structs
 * Meta informations extracted from the WSDL
 * - documentation: Specifies additional services to be provided by hotel.
 * @subpackage Structs
 */
class Services extends AbstractStructBase
{
    /**
     * The MealType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\MealType
     */
    public $MealType;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\TravelItineraryRead\Structs\ServiceRefType[]
     */
    public $Service;
    /**
     * Constructor method for Services
     * @uses Services::setMealType()
     * @uses Services::setService()
     * @param \Sabre\TravelItineraryRead\Structs\MealType $mealType
     * @param \Sabre\TravelItineraryRead\Structs\ServiceRefType[] $service
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\MealType $mealType = null, array $service = array())
    {
        $this
            ->setMealType($mealType)
            ->setService($service);
    }
    /**
     * Get MealType value
     * @return \Sabre\TravelItineraryRead\Structs\MealType|null
     */
    public function getMealType()
    {
        return $this->MealType;
    }
    /**
     * Set MealType value
     * @param \Sabre\TravelItineraryRead\Structs\MealType $mealType
     * @return \Sabre\TravelItineraryRead\Structs\Services
     */
    public function setMealType(\Sabre\TravelItineraryRead\Structs\MealType $mealType = null)
    {
        $this->MealType = $mealType;
        return $this;
    }
    /**
     * Get Service value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceRefType[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ServiceRefType[] $service
     * @return \Sabre\TravelItineraryRead\Structs\Services
     */
    public function setService(array $service = array())
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\ServiceRefType $item
     * @return \Sabre\TravelItineraryRead\Structs\Services
     */
    public function addToService(\Sabre\TravelItineraryRead\Structs\ServiceRefType $item)
    {
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Services
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
