<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Seat Structs
 * @subpackage Structs
 */
class Seat extends AbstractStructBase
{
    /**
     * The FlightSegment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FlightSegment
     */
    public $FlightSegment;
    /**
     * The Changed
     * Meta informations extracted from the WSDL
     * - documentation: "Changed" is used to indicate if the passenger's seat as been changed.
     * - use: optional
     * @var string
     */
    public $Changed;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "NameNumber" is used return the passenger name number associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - documentation: "Number" is used to return the seat assignment associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $Number;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number that the seat is related to.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The SegmentStatus
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentStatus" is used to return the segment status associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $SegmentStatus;
    /**
     * The SmokingPreference
     * Meta informations extracted from the WSDL
     * - documentation: "SmokingPreference" is used to indicate the smoking preference associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $SmokingPreference;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - documentation: "Status" is used to return the seat status code.
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the seat type associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The TypeTwo
     * Meta informations extracted from the WSDL
     * - documentation: "TypeTwo" is used to return the seat type associated with the particular seat reservation.
     * - use: optional
     * @var string
     */
    public $TypeTwo;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Id;
    /**
     * Constructor method for Seat
     * @uses Seat::setFlightSegment()
     * @uses Seat::setChanged()
     * @uses Seat::setNameNumber()
     * @uses Seat::setNumber()
     * @uses Seat::setSegmentNumber()
     * @uses Seat::setSegmentStatus()
     * @uses Seat::setSmokingPreference()
     * @uses Seat::setStatus()
     * @uses Seat::setType()
     * @uses Seat::setTypeTwo()
     * @uses Seat::setId()
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment
     * @param string $changed
     * @param string $nameNumber
     * @param string $number
     * @param string $segmentNumber
     * @param string $segmentStatus
     * @param string $smokingPreference
     * @param string $status
     * @param string $type
     * @param string $typeTwo
     * @param string $id
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment = null, $changed = null, $nameNumber = null, $number = null, $segmentNumber = null, $segmentStatus = null, $smokingPreference = null, $status = null, $type = null, $typeTwo = null, $id = null)
    {
        $this
            ->setFlightSegment($flightSegment)
            ->setChanged($changed)
            ->setNameNumber($nameNumber)
            ->setNumber($number)
            ->setSegmentNumber($segmentNumber)
            ->setSegmentStatus($segmentStatus)
            ->setSmokingPreference($smokingPreference)
            ->setStatus($status)
            ->setType($type)
            ->setTypeTwo($typeTwo)
            ->setId($id);
    }
    /**
     * Get FlightSegment value
     * @return \Sabre\TravelItineraryRead\Structs\FlightSegment|null
     */
    public function getFlightSegment()
    {
        return $this->FlightSegment;
    }
    /**
     * Set FlightSegment value
     * @param \Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setFlightSegment(\Sabre\TravelItineraryRead\Structs\FlightSegment $flightSegment = null)
    {
        $this->FlightSegment = $flightSegment;
        return $this;
    }
    /**
     * Get Changed value
     * @return string|null
     */
    public function getChanged()
    {
        return $this->Changed;
    }
    /**
     * Set Changed value
     * @param string $changed
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setChanged($changed = null)
    {
        $this->Changed = $changed;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get SegmentStatus value
     * @return string|null
     */
    public function getSegmentStatus()
    {
        return $this->SegmentStatus;
    }
    /**
     * Set SegmentStatus value
     * @param string $segmentStatus
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setSegmentStatus($segmentStatus = null)
    {
        $this->SegmentStatus = $segmentStatus;
        return $this;
    }
    /**
     * Get SmokingPreference value
     * @return string|null
     */
    public function getSmokingPreference()
    {
        return $this->SmokingPreference;
    }
    /**
     * Set SmokingPreference value
     * @param string $smokingPreference
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setSmokingPreference($smokingPreference = null)
    {
        $this->SmokingPreference = $smokingPreference;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get TypeTwo value
     * @return string|null
     */
    public function getTypeTwo()
    {
        return $this->TypeTwo;
    }
    /**
     * Set TypeTwo value
     * @param string $typeTwo
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setTypeTwo($typeTwo = null)
    {
        $this->TypeTwo = $typeTwo;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public function setId($id = null)
    {
        $this->Id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Seat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
