<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Room Structs
 * @subpackage Structs
 */
class Room extends AbstractStructBase
{
    /**
     * The OccupancyCode
     * Meta informations extracted from the WSDL
     * - documentation: "OccupancyCode" is used to return the hotel room occupancy code associated with the particular tour reservation if applicable.
     * - use: optional
     * @var string
     */
    public $OccupancyCode;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - documentation: "Type" is used to return the hotel room type associated with the particular tour reservation if applicable.
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * Constructor method for Room
     * @uses Room::setOccupancyCode()
     * @uses Room::setType()
     * @param string $occupancyCode
     * @param string $type
     */
    public function __construct($occupancyCode = null, $type = null)
    {
        $this
            ->setOccupancyCode($occupancyCode)
            ->setType($type);
    }
    /**
     * Get OccupancyCode value
     * @return string|null
     */
    public function getOccupancyCode()
    {
        return $this->OccupancyCode;
    }
    /**
     * Set OccupancyCode value
     * @param string $occupancyCode
     * @return \Sabre\TravelItineraryRead\Structs\Room
     */
    public function setOccupancyCode($occupancyCode = null)
    {
        $this->OccupancyCode = $occupancyCode;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Room
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Room
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
