<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RemarkInfo Structs
 * Meta informations extracted from the WSDL
 * - documentation: "RemarkInfo" holds details of Remarks
 * @subpackage Structs
 */
class RemarkInfo extends AbstractStructBase
{
    /**
     * The Remark
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Remark[]
     */
    public $Remark;
    /**
     * Constructor method for RemarkInfo
     * @uses RemarkInfo::setRemark()
     * @param \Sabre\TravelItineraryRead\Structs\Remark[] $remark
     */
    public function __construct(array $remark = array())
    {
        $this
            ->setRemark($remark);
    }
    /**
     * Get Remark value
     * @return \Sabre\TravelItineraryRead\Structs\Remark[]|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Remark[] $remark
     * @return \Sabre\TravelItineraryRead\Structs\RemarkInfo
     */
    public function setRemark(array $remark = array())
    {
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Add item to Remark value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Remark $item
     * @return \Sabre\TravelItineraryRead\Structs\RemarkInfo
     */
    public function addToRemark(\Sabre\TravelItineraryRead\Structs\Remark $item)
    {
        $this->Remark[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\RemarkInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
