<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Price Structs
 * @subpackage Structs
 */
class Price extends AbstractStructBase
{
    /**
     * The Total
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PriceType
     */
    public $Total;
    /**
     * The Breakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Breakdown[]
     */
    public $Breakdown;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return price-related information associated with the particular tour reservation.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * Constructor method for Price
     * @uses Price::setTotal()
     * @uses Price::setBreakdown()
     * @uses Price::setAmount()
     * @param \Sabre\TravelItineraryRead\Structs\PriceType $total
     * @param \Sabre\TravelItineraryRead\Structs\Breakdown[] $breakdown
     * @param string $amount
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\PriceType $total = null, array $breakdown = array(), $amount = null)
    {
        $this
            ->setTotal($total)
            ->setBreakdown($breakdown)
            ->setAmount($amount);
    }
    /**
     * Get Total value
     * @return \Sabre\TravelItineraryRead\Structs\PriceType|null
     */
    public function getTotal()
    {
        return $this->Total;
    }
    /**
     * Set Total value
     * @param \Sabre\TravelItineraryRead\Structs\PriceType $total
     * @return \Sabre\TravelItineraryRead\Structs\Price
     */
    public function setTotal(\Sabre\TravelItineraryRead\Structs\PriceType $total = null)
    {
        $this->Total = $total;
        return $this;
    }
    /**
     * Get Breakdown value
     * @return \Sabre\TravelItineraryRead\Structs\Breakdown[]|null
     */
    public function getBreakdown()
    {
        return $this->Breakdown;
    }
    /**
     * Set Breakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Breakdown[] $breakdown
     * @return \Sabre\TravelItineraryRead\Structs\Price
     */
    public function setBreakdown(array $breakdown = array())
    {
        $this->Breakdown = $breakdown;
        return $this;
    }
    /**
     * Add item to Breakdown value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Breakdown $item
     * @return \Sabre\TravelItineraryRead\Structs\Price
     */
    public function addToBreakdown(\Sabre\TravelItineraryRead\Structs\Breakdown $item)
    {
        $this->Breakdown[] = $item;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\Price
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Price
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
