<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocationDetails Structs
 * @subpackage Structs
 */
class LocationDetails extends AbstractStructBase
{
    /**
     * The ContactNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PhoneType
     */
    public $ContactNumber;
    /**
     * The extendedLocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "extendedLocationCode" is used to return the extended vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $extendedLocationCode;
    /**
     * The locationCode
     * Meta informations extracted from the WSDL
     * - documentation: "locationCode" is used to return the vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $locationCode;
    /**
     * The locationName
     * Meta informations extracted from the WSDL
     * - documentation: "locationName" is used to return the vehicle pick up rental location name.
     * - use: optional
     * @var string
     */
    public $locationName;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The ExtendedLocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "ExtendedLocationCode" is used to return the extended vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $ExtendedLocationCode;
    /**
     * The LocationCode
     * Meta informations extracted from the WSDL
     * - documentation: "LocationCode" is used to return the vehicle pick up rental location code.
     * - use: optional
     * @var string
     */
    public $LocationCode;
    /**
     * The LocationName
     * Meta informations extracted from the WSDL
     * - documentation: "LocationName" is used to return the vehicle pick up rental location name.
     * - use: optional
     * @var string
     */
    public $LocationName;
    /**
     * Constructor method for LocationDetails
     * @uses LocationDetails::setContactNumber()
     * @uses LocationDetails::setExtendedLocationCode()
     * @uses LocationDetails::setLocationCode()
     * @uses LocationDetails::setLocationName()
     * @uses LocationDetails::setContactNumbers()
     * @uses LocationDetails::setExtendedLocationCode_1()
     * @uses LocationDetails::setLocationCode_1()
     * @uses LocationDetails::setLocationName_1()
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber
     * @param string $extendedLocationCode
     * @param string $locationCode
     * @param string $locationName
     * @param \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers
     * @param string $extendedLocationCode
     * @param string $locationCode
     * @param string $locationName
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber = null, $extendedLocationCode = null, $locationCode = null, $locationName = null, \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers = null, $extendedLocationCode = null, $locationCode = null, $locationName = null)
    {
        $this
            ->setContactNumber($contactNumber)
            ->setExtendedLocationCode($extendedLocationCode)
            ->setLocationCode($locationCode)
            ->setLocationName($locationName)
            ->setContactNumbers($contactNumbers)
            ->setExtendedLocationCode_1($extendedLocationCode)
            ->setLocationCode_1($locationCode)
            ->setLocationName_1($locationName);
    }
    /**
     * Get ContactNumber value
     * @return \Sabre\TravelItineraryRead\Structs\PhoneType|null
     */
    public function getContactNumber()
    {
        return $this->ContactNumber;
    }
    /**
     * Set ContactNumber value
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setContactNumber(\Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber = null)
    {
        $this->ContactNumber = $contactNumber;
        return $this;
    }
    /**
     * Get ExtendedLocationCode value
     * @return string|null
     */
    public function getExtendedLocationCode()
    {
        return $this->extendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setExtendedLocationCode($extendedLocationCode = null)
    {
        $this->extendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get LocationCode value
     * @return string|null
     */
    public function getLocationCode()
    {
        return $this->locationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setLocationCode($locationCode = null)
    {
        $this->locationCode = $locationCode;
        return $this;
    }
    /**
     * Get LocationName value
     * @return string|null
     */
    public function getLocationName()
    {
        return $this->locationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setLocationName($locationName = null)
    {
        $this->locationName = $locationName;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\TravelItineraryRead\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setContactNumbers(\Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get extendedLocationCode_1 value
     * @return extendedLocationCode_1
     */
    public function getExtendedLocationCode_1()
    {
        return $this->ExtendedLocationCode;
    }
    /**
     * Set ExtendedLocationCode value
     * @param string $extendedLocationCode
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setExtendedLocationCode_1($extendedLocationCode = null)
    {
        $this->ExtendedLocationCode = $extendedLocationCode;
        return $this;
    }
    /**
     * Get locationCode_1 value
     * @return locationCode_1
     */
    public function getLocationCode_1()
    {
        return $this->LocationCode;
    }
    /**
     * Set LocationCode value
     * @param string $locationCode
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setLocationCode_1($locationCode = null)
    {
        $this->LocationCode = $locationCode;
        return $this;
    }
    /**
     * Get locationName_1 value
     * @return locationName_1
     */
    public function getLocationName_1()
    {
        return $this->LocationName;
    }
    /**
     * Set LocationName value
     * @param string $locationName
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public function setLocationName_1($locationName = null)
    {
        $this->LocationName = $locationName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
