<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceData Structs
 * Meta informations extracted from the WSDL
 * - type: InvoiceData
 * @subpackage Structs
 */
class InvoiceData extends AbstractStructBase
{
    /**
     * The SnapshotId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SnapshotId;
    /**
     * The InvoiceId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $InvoiceId;
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceNumber;
    /**
     * The InvoiceCreateDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $InvoiceCreateDate;
    /**
     * The DkNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DkNumber;
    /**
     * The TravellerLastName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravellerLastName;
    /**
     * The TravellerFirstName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TravellerFirstName;
    /**
     * The TravellerName
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\NameAssociationTag[]
     */
    public $TravellerName;
    /**
     * The AccountingLine
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $AccountingLine;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $SegmentNumber;
    /**
     * Constructor method for InvoiceData
     * @uses InvoiceData::setSnapshotId()
     * @uses InvoiceData::setInvoiceId()
     * @uses InvoiceData::setInvoiceNumber()
     * @uses InvoiceData::setInvoiceCreateDate()
     * @uses InvoiceData::setDkNumber()
     * @uses InvoiceData::setTravellerLastName()
     * @uses InvoiceData::setTravellerFirstName()
     * @uses InvoiceData::setTravellerName()
     * @uses InvoiceData::setAccountingLine()
     * @uses InvoiceData::setSegmentNumber()
     * @param string $snapshotId
     * @param string $invoiceId
     * @param int $invoiceNumber
     * @param string $invoiceCreateDate
     * @param string $dkNumber
     * @param string $travellerLastName
     * @param string $travellerFirstName
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag[] $travellerName
     * @param string[] $accountingLine
     * @param string[] $segmentNumber
     */
    public function __construct($snapshotId = null, $invoiceId = null, $invoiceNumber = null, $invoiceCreateDate = null, $dkNumber = null, $travellerLastName = null, $travellerFirstName = null, array $travellerName = array(), array $accountingLine = array(), array $segmentNumber = array())
    {
        $this
            ->setSnapshotId($snapshotId)
            ->setInvoiceId($invoiceId)
            ->setInvoiceNumber($invoiceNumber)
            ->setInvoiceCreateDate($invoiceCreateDate)
            ->setDkNumber($dkNumber)
            ->setTravellerLastName($travellerLastName)
            ->setTravellerFirstName($travellerFirstName)
            ->setTravellerName($travellerName)
            ->setAccountingLine($accountingLine)
            ->setSegmentNumber($segmentNumber);
    }
    /**
     * Get SnapshotId value
     * @return string|null
     */
    public function getSnapshotId()
    {
        return $this->SnapshotId;
    }
    /**
     * Set SnapshotId value
     * @param string $snapshotId
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setSnapshotId($snapshotId = null)
    {
        $this->SnapshotId = $snapshotId;
        return $this;
    }
    /**
     * Get InvoiceId value
     * @return string|null
     */
    public function getInvoiceId()
    {
        return $this->InvoiceId;
    }
    /**
     * Set InvoiceId value
     * @param string $invoiceId
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setInvoiceId($invoiceId = null)
    {
        $this->InvoiceId = $invoiceId;
        return $this;
    }
    /**
     * Get InvoiceNumber value
     * @return int|null
     */
    public function getInvoiceNumber()
    {
        return $this->InvoiceNumber;
    }
    /**
     * Set InvoiceNumber value
     * @param int $invoiceNumber
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        $this->InvoiceNumber = $invoiceNumber;
        return $this;
    }
    /**
     * Get InvoiceCreateDate value
     * @return string|null
     */
    public function getInvoiceCreateDate()
    {
        return $this->InvoiceCreateDate;
    }
    /**
     * Set InvoiceCreateDate value
     * @param string $invoiceCreateDate
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setInvoiceCreateDate($invoiceCreateDate = null)
    {
        $this->InvoiceCreateDate = $invoiceCreateDate;
        return $this;
    }
    /**
     * Get DkNumber value
     * @return string|null
     */
    public function getDkNumber()
    {
        return $this->DkNumber;
    }
    /**
     * Set DkNumber value
     * @param string $dkNumber
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setDkNumber($dkNumber = null)
    {
        $this->DkNumber = $dkNumber;
        return $this;
    }
    /**
     * Get TravellerLastName value
     * @return string|null
     */
    public function getTravellerLastName()
    {
        return $this->TravellerLastName;
    }
    /**
     * Set TravellerLastName value
     * @param string $travellerLastName
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setTravellerLastName($travellerLastName = null)
    {
        $this->TravellerLastName = $travellerLastName;
        return $this;
    }
    /**
     * Get TravellerFirstName value
     * @return string|null
     */
    public function getTravellerFirstName()
    {
        return $this->TravellerFirstName;
    }
    /**
     * Set TravellerFirstName value
     * @param string $travellerFirstName
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setTravellerFirstName($travellerFirstName = null)
    {
        $this->TravellerFirstName = $travellerFirstName;
        return $this;
    }
    /**
     * Get TravellerName value
     * @return \Sabre\TravelItineraryRead\Structs\NameAssociationTag[]|null
     */
    public function getTravellerName()
    {
        return $this->TravellerName;
    }
    /**
     * Set TravellerName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag[] $travellerName
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setTravellerName(array $travellerName = array())
    {
        $this->TravellerName = $travellerName;
        return $this;
    }
    /**
     * Add item to TravellerName value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationTag $item
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function addToTravellerName(\Sabre\TravelItineraryRead\Structs\NameAssociationTag $item)
    {
        $this->TravellerName[] = $item;
        return $this;
    }
    /**
     * Get AccountingLine value
     * @return string[]|null
     */
    public function getAccountingLine()
    {
        return $this->AccountingLine;
    }
    /**
     * Set AccountingLine value
     * @throws \InvalidArgumentException
     * @param string[] $accountingLine
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setAccountingLine(array $accountingLine = array())
    {
        $this->AccountingLine = $accountingLine;
        return $this;
    }
    /**
     * Add item to AccountingLine value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function addToAccountingLine($item)
    {
        $this->AccountingLine[] = $item;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string[]|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @throws \InvalidArgumentException
     * @param string[] $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function setSegmentNumber(array $segmentNumber = array())
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Add item to SegmentNumber value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public function addToSegmentNumber($item)
    {
        $this->SegmentNumber[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\InvoiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
