<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HotelFee Structs
 * Meta informations extracted from the WSDL
 * - documentation: Contains attributes for the description, amount, and currency of a single fee. Details any VAT, state/city tax, resort fees, or any other fees collected that cannot be reasonably avoided.
 * @subpackage Structs
 */
class HotelFee extends AbstractStructBase
{
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: The type of charge.
     * @var string
     */
    public $Description;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: Value for the charge.
     * @var float
     */
    public $Amount;
    /**
     * Constructor method for HotelFee
     * @uses HotelFee::setDescription()
     * @uses HotelFee::setAmount()
     * @param string $description
     * @param float $amount
     */
    public function __construct($description = null, $amount = null)
    {
        $this
            ->setDescription($description)
            ->setAmount($amount);
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \Sabre\TravelItineraryRead\Structs\HotelFee
     */
    public function setDescription($description = null)
    {
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \Sabre\TravelItineraryRead\Structs\HotelFee
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\HotelFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
