<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GroundTransportationType Structs
 * @subpackage Structs
 */
class GroundTransportationType extends AbstractStructBase
{
    /**
     * The StatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StatusCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CompanyType
     */
    public $Vendor;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var ServiceType
     */
    public $Service;
    /**
     * The ServiceProvider
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ServiceProviderType
     */
    public $ServiceProvider;
    /**
     * The StartDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LocationDetailsType
     */
    public $StartDetails;
    /**
     * The StopDetails
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LocationDetailsType[]
     */
    public $StopDetails;
    /**
     * The EndDetails
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LocationDetailsType
     */
    public $EndDetails;
    /**
     * The ExternalReservation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ExternalReservationType
     */
    public $ExternalReservation;
    /**
     * The Restrictions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RestrictionsType
     */
    public $Restrictions;
    /**
     * The POS
     * @var \Sabre\TravelItineraryRead\Structs\POSType
     */
    public $POS;
    /**
     * The AgentLoyalty
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\LoyaltyType[]
     */
    public $AgentLoyalty;
    /**
     * The Passenger
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerType[]
     */
    public $Passenger;
    /**
     * The RateQualifier
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RateQualifierType[]
     */
    public $RateQualifier;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ChargesType
     */
    public $Charges;
    /**
     * Constructor method for GroundTransportationType
     * @uses GroundTransportationType::setStatusCode()
     * @uses GroundTransportationType::setVendor()
     * @uses GroundTransportationType::setService()
     * @uses GroundTransportationType::setServiceProvider()
     * @uses GroundTransportationType::setStartDetails()
     * @uses GroundTransportationType::setStopDetails()
     * @uses GroundTransportationType::setEndDetails()
     * @uses GroundTransportationType::setExternalReservation()
     * @uses GroundTransportationType::setRestrictions()
     * @uses GroundTransportationType::setPOS()
     * @uses GroundTransportationType::setAgentLoyalty()
     * @uses GroundTransportationType::setPassenger()
     * @uses GroundTransportationType::setRateQualifier()
     * @uses GroundTransportationType::setCharges()
     * @param string $statusCode
     * @param \Sabre\TravelItineraryRead\Structs\CompanyType $vendor
     * @param ServiceType $service
     * @param \Sabre\TravelItineraryRead\Structs\ServiceProviderType $serviceProvider
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType[] $stopDetails
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails
     * @param \Sabre\TravelItineraryRead\Structs\ExternalReservationType $externalReservation
     * @param \Sabre\TravelItineraryRead\Structs\RestrictionsType $restrictions
     * @param \Sabre\TravelItineraryRead\Structs\POSType $pOS
     * @param \Sabre\TravelItineraryRead\Structs\LoyaltyType[] $agentLoyalty
     * @param \Sabre\TravelItineraryRead\Structs\PassengerType[] $passenger
     * @param \Sabre\TravelItineraryRead\Structs\RateQualifierType[] $rateQualifier
     * @param \Sabre\TravelItineraryRead\Structs\ChargesType $charges
     */
    public function __construct($statusCode = null, \Sabre\TravelItineraryRead\Structs\CompanyType $vendor = null, ServiceType $service = null, \Sabre\TravelItineraryRead\Structs\ServiceProviderType $serviceProvider = null, \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails = null, array $stopDetails = array(), \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails = null, \Sabre\TravelItineraryRead\Structs\ExternalReservationType $externalReservation = null, \Sabre\TravelItineraryRead\Structs\RestrictionsType $restrictions = null, \Sabre\TravelItineraryRead\Structs\POSType $pOS = null, array $agentLoyalty = array(), array $passenger = array(), array $rateQualifier = array(), \Sabre\TravelItineraryRead\Structs\ChargesType $charges = null)
    {
        $this
            ->setStatusCode($statusCode)
            ->setVendor($vendor)
            ->setService($service)
            ->setServiceProvider($serviceProvider)
            ->setStartDetails($startDetails)
            ->setStopDetails($stopDetails)
            ->setEndDetails($endDetails)
            ->setExternalReservation($externalReservation)
            ->setRestrictions($restrictions)
            ->setPOS($pOS)
            ->setAgentLoyalty($agentLoyalty)
            ->setPassenger($passenger)
            ->setRateQualifier($rateQualifier)
            ->setCharges($charges);
    }
    /**
     * Get StatusCode value
     * @return string|null
     */
    public function getStatusCode()
    {
        return $this->StatusCode;
    }
    /**
     * Set StatusCode value
     * @param string $statusCode
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setStatusCode($statusCode = null)
    {
        $this->StatusCode = $statusCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return \Sabre\TravelItineraryRead\Structs\CompanyType|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param \Sabre\TravelItineraryRead\Structs\CompanyType $vendor
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setVendor(\Sabre\TravelItineraryRead\Structs\CompanyType $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get Service value
     * @return ServiceType|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @param ServiceType $service
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setService(ServiceType $service = null)
    {
        $this->Service = $service;
        return $this;
    }
    /**
     * Get ServiceProvider value
     * @return \Sabre\TravelItineraryRead\Structs\ServiceProviderType|null
     */
    public function getServiceProvider()
    {
        return $this->ServiceProvider;
    }
    /**
     * Set ServiceProvider value
     * @param \Sabre\TravelItineraryRead\Structs\ServiceProviderType $serviceProvider
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setServiceProvider(\Sabre\TravelItineraryRead\Structs\ServiceProviderType $serviceProvider = null)
    {
        $this->ServiceProvider = $serviceProvider;
        return $this;
    }
    /**
     * Get StartDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetailsType|null
     */
    public function getStartDetails()
    {
        return $this->StartDetails;
    }
    /**
     * Set StartDetails value
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setStartDetails(\Sabre\TravelItineraryRead\Structs\LocationDetailsType $startDetails = null)
    {
        $this->StartDetails = $startDetails;
        return $this;
    }
    /**
     * Get StopDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetailsType[]|null
     */
    public function getStopDetails()
    {
        return $this->StopDetails;
    }
    /**
     * Set StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType[] $stopDetails
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setStopDetails(array $stopDetails = array())
    {
        $this->StopDetails = $stopDetails;
        return $this;
    }
    /**
     * Add item to StopDetails value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $item
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function addToStopDetails(\Sabre\TravelItineraryRead\Structs\LocationDetailsType $item)
    {
        $this->StopDetails[] = $item;
        return $this;
    }
    /**
     * Get EndDetails value
     * @return \Sabre\TravelItineraryRead\Structs\LocationDetailsType|null
     */
    public function getEndDetails()
    {
        return $this->EndDetails;
    }
    /**
     * Set EndDetails value
     * @param \Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setEndDetails(\Sabre\TravelItineraryRead\Structs\LocationDetailsType $endDetails = null)
    {
        $this->EndDetails = $endDetails;
        return $this;
    }
    /**
     * Get ExternalReservation value
     * @return \Sabre\TravelItineraryRead\Structs\ExternalReservationType|null
     */
    public function getExternalReservation()
    {
        return $this->ExternalReservation;
    }
    /**
     * Set ExternalReservation value
     * @param \Sabre\TravelItineraryRead\Structs\ExternalReservationType $externalReservation
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setExternalReservation(\Sabre\TravelItineraryRead\Structs\ExternalReservationType $externalReservation = null)
    {
        $this->ExternalReservation = $externalReservation;
        return $this;
    }
    /**
     * Get Restrictions value
     * @return \Sabre\TravelItineraryRead\Structs\RestrictionsType|null
     */
    public function getRestrictions()
    {
        return $this->Restrictions;
    }
    /**
     * Set Restrictions value
     * @param \Sabre\TravelItineraryRead\Structs\RestrictionsType $restrictions
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setRestrictions(\Sabre\TravelItineraryRead\Structs\RestrictionsType $restrictions = null)
    {
        $this->Restrictions = $restrictions;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\TravelItineraryRead\Structs\POSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\TravelItineraryRead\Structs\POSType $pOS
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setPOS(\Sabre\TravelItineraryRead\Structs\POSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get AgentLoyalty value
     * @return \Sabre\TravelItineraryRead\Structs\LoyaltyType[]|null
     */
    public function getAgentLoyalty()
    {
        return $this->AgentLoyalty;
    }
    /**
     * Set AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\LoyaltyType[] $agentLoyalty
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setAgentLoyalty(array $agentLoyalty = array())
    {
        $this->AgentLoyalty = $agentLoyalty;
        return $this;
    }
    /**
     * Add item to AgentLoyalty value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\LoyaltyType $item
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function addToAgentLoyalty(\Sabre\TravelItineraryRead\Structs\LoyaltyType $item)
    {
        $this->AgentLoyalty[] = $item;
        return $this;
    }
    /**
     * Get Passenger value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerType[]|null
     */
    public function getPassenger()
    {
        return $this->Passenger;
    }
    /**
     * Set Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerType[] $passenger
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setPassenger(array $passenger = array())
    {
        $this->Passenger = $passenger;
        return $this;
    }
    /**
     * Add item to Passenger value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PassengerType $item
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function addToPassenger(\Sabre\TravelItineraryRead\Structs\PassengerType $item)
    {
        $this->Passenger[] = $item;
        return $this;
    }
    /**
     * Get RateQualifier value
     * @return \Sabre\TravelItineraryRead\Structs\RateQualifierType[]|null
     */
    public function getRateQualifier()
    {
        return $this->RateQualifier;
    }
    /**
     * Set RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\RateQualifierType[] $rateQualifier
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setRateQualifier(array $rateQualifier = array())
    {
        $this->RateQualifier = $rateQualifier;
        return $this;
    }
    /**
     * Add item to RateQualifier value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\RateQualifierType $item
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function addToRateQualifier(\Sabre\TravelItineraryRead\Structs\RateQualifierType $item)
    {
        $this->RateQualifier[] = $item;
        return $this;
    }
    /**
     * Get Charges value
     * @return \Sabre\TravelItineraryRead\Structs\ChargesType|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \Sabre\TravelItineraryRead\Structs\ChargesType $charges
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public function setCharges(\Sabre\TravelItineraryRead\Structs\ChargesType $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\GroundTransportationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
