<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GST Structs
 * @subpackage Structs
 */
class GST extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the applicable amount.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "CurrencyCode" is used to return the applicable currency code.
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: "Percent" is used to return the applicable percentage.
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * Constructor method for GST
     * @uses GST::setAmount()
     * @uses GST::setCurrencyCode()
     * @uses GST::setPercent()
     * @param string $amount
     * @param string $currencyCode
     * @param string $percent
     */
    public function __construct($amount = null, $currencyCode = null, $percent = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode)
            ->setPercent($percent);
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\GST
     */
    public function setAmount($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\GST
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\TravelItineraryRead\Structs\GST
     */
    public function setPercent($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\GST
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
