<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExcessRate Structs
 * @subpackage Structs
 */
class ExcessRate extends AbstractStructBase
{
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: "amount" is used to return excess rate amount.
     * - use: optional
     * @var string
     */
    public $amount;
    /**
     * The currencyCode
     * Meta informations extracted from the WSDL
     * - documentation: "currencyCode" is used to return the currency code associated with excess rate charges.
     * - use: optional
     * @var string
     */
    public $currencyCode;
    /**
     * Constructor method for ExcessRate
     * @uses ExcessRate::setAmount()
     * @uses ExcessRate::setCurrencyCode()
     * @param string $amount
     * @param string $currencyCode
     */
    public function __construct($amount = null, $currencyCode = null)
    {
        $this
            ->setAmount($amount)
            ->setCurrencyCode($currencyCode);
    }
    /**
     * Get amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\ExcessRate
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get currencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->currencyCode;
    }
    /**
     * Set currencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\ExcessRate
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->currencyCode = $currencyCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ExcessRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
