<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Equipment Structs
 * @subpackage Structs
 */
class Equipment extends AbstractStructBase
{
    /**
     * The AirEquipType
     * Meta informations extracted from the WSDL
     * - documentation: "AirEquipType" is used to return the aircraft equipment type associated with the particular flight segment.
     * - use: optional
     * @var string
     */
    public $AirEquipType;
    /**
     * The EquipType
     * Meta informations extracted from the WSDL
     * - documentation: "EquipType" is used to return the category of vehicle associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $EquipType;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - documentation: "Quantity" is used to return the number of reserved vehicles associated with the vehicle rental.
     * - use: optional
     * @var string
     */
    public $Quantity;
    /**
     * The SpecialEquip
     * Meta informations extracted from the WSDL
     * - documentation: "SpecialEquip" is used to return special equipment-related information.
     * - use: optional
     * @var string
     */
    public $SpecialEquip;
    /**
     * The SpecialEquipConfirmed
     * Meta informations extracted from the WSDL
     * - documentation: "SpecialEquipConfirmed" is used to denote whether or not the special equipment is confirmed.
     * - use: optional
     * @var string
     */
    public $SpecialEquipConfirmed;
    /**
     * Constructor method for Equipment
     * @uses Equipment::setAirEquipType()
     * @uses Equipment::setEquipType()
     * @uses Equipment::setQuantity()
     * @uses Equipment::setSpecialEquip()
     * @uses Equipment::setSpecialEquipConfirmed()
     * @param string $airEquipType
     * @param string $equipType
     * @param string $quantity
     * @param string $specialEquip
     * @param string $specialEquipConfirmed
     */
    public function __construct($airEquipType = null, $equipType = null, $quantity = null, $specialEquip = null, $specialEquipConfirmed = null)
    {
        $this
            ->setAirEquipType($airEquipType)
            ->setEquipType($equipType)
            ->setQuantity($quantity)
            ->setSpecialEquip($specialEquip)
            ->setSpecialEquipConfirmed($specialEquipConfirmed);
    }
    /**
     * Get AirEquipType value
     * @return string|null
     */
    public function getAirEquipType()
    {
        return $this->AirEquipType;
    }
    /**
     * Set AirEquipType value
     * @param string $airEquipType
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public function setAirEquipType($airEquipType = null)
    {
        $this->AirEquipType = $airEquipType;
        return $this;
    }
    /**
     * Get EquipType value
     * @return string|null
     */
    public function getEquipType()
    {
        return $this->EquipType;
    }
    /**
     * Set EquipType value
     * @param string $equipType
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public function setEquipType($equipType = null)
    {
        $this->EquipType = $equipType;
        return $this;
    }
    /**
     * Get Quantity value
     * @return string|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param string $quantity
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get SpecialEquip value
     * @return string|null
     */
    public function getSpecialEquip()
    {
        return $this->SpecialEquip;
    }
    /**
     * Set SpecialEquip value
     * @param string $specialEquip
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public function setSpecialEquip($specialEquip = null)
    {
        $this->SpecialEquip = $specialEquip;
        return $this;
    }
    /**
     * Get SpecialEquipConfirmed value
     * @return string|null
     */
    public function getSpecialEquipConfirmed()
    {
        return $this->SpecialEquipConfirmed;
    }
    /**
     * Set SpecialEquipConfirmed value
     * @param string $specialEquipConfirmed
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public function setSpecialEquipConfirmed($specialEquipConfirmed = null)
    {
        $this->SpecialEquipConfirmed = $specialEquipConfirmed;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Equipment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
