<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocumentType Structs
 * @subpackage Structs
 */
class DocumentType extends AbstractStructBase
{
    /**
     * The DocumentID
     * @var string
     */
    public $DocumentID;
    /**
     * The AgencyAccountNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AgencyAccountNumber;
    /**
     * The CreationChannel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreationChannel;
    /**
     * The SeatNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $SeatNumber;
    /**
     * The TypeOfPass
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TypeOfPass;
    /**
     * The PassengerReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PassengerReferences
     */
    public $PassengerReferences;
    /**
     * The SegmentReferences
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SegmentReferences
     */
    public $SegmentReferences;
    /**
     * The IssueTimeLimit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $IssueTimeLimit;
    /**
     * The IssueDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $IssueDateTime;
    /**
     * The DocumentStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DocumentStatus;
    /**
     * The Charges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ChargesType
     */
    public $Charges;
    /**
     * The FormOfPayment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\FormOfPayment
     */
    public $FormOfPayment;
    /**
     * The File
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\File
     */
    public $File;
    /**
     * The IssueType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueType;
    /**
     * The DocumentRules
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\DocumentRules
     */
    public $DocumentRules;
    /**
     * The type
     * @var string
     */
    public $type;
    /**
     * The code
     * @var string
     */
    public $code;
    /**
     * The codeContext
     * @var string
     */
    public $codeContext;
    /**
     * Constructor method for DocumentType
     * @uses DocumentType::setDocumentID()
     * @uses DocumentType::setAgencyAccountNumber()
     * @uses DocumentType::setCreationChannel()
     * @uses DocumentType::setSeatNumber()
     * @uses DocumentType::setTypeOfPass()
     * @uses DocumentType::setPassengerReferences()
     * @uses DocumentType::setSegmentReferences()
     * @uses DocumentType::setIssueTimeLimit()
     * @uses DocumentType::setIssueDateTime()
     * @uses DocumentType::setDocumentStatus()
     * @uses DocumentType::setCharges()
     * @uses DocumentType::setFormOfPayment()
     * @uses DocumentType::setFile()
     * @uses DocumentType::setIssueType()
     * @uses DocumentType::setDocumentRules()
     * @uses DocumentType::setType()
     * @uses DocumentType::setCode()
     * @uses DocumentType::setCodeContext()
     * @param string $documentID
     * @param string $agencyAccountNumber
     * @param string $creationChannel
     * @param string $seatNumber
     * @param string $typeOfPass
     * @param \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences
     * @param \Sabre\TravelItineraryRead\Structs\SegmentReferences $segmentReferences
     * @param string $issueTimeLimit
     * @param string $issueDateTime
     * @param string $documentStatus
     * @param \Sabre\TravelItineraryRead\Structs\ChargesType $charges
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @param \Sabre\TravelItineraryRead\Structs\File $file
     * @param string $issueType
     * @param \Sabre\TravelItineraryRead\Structs\DocumentRules $documentRules
     * @param string $type
     * @param string $code
     * @param string $codeContext
     */
    public function __construct($documentID = null, $agencyAccountNumber = null, $creationChannel = null, $seatNumber = null, $typeOfPass = null, \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences = null, \Sabre\TravelItineraryRead\Structs\SegmentReferences $segmentReferences = null, $issueTimeLimit = null, $issueDateTime = null, $documentStatus = null, \Sabre\TravelItineraryRead\Structs\ChargesType $charges = null, \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null, \Sabre\TravelItineraryRead\Structs\File $file = null, $issueType = null, \Sabre\TravelItineraryRead\Structs\DocumentRules $documentRules = null, $type = null, $code = null, $codeContext = null)
    {
        $this
            ->setDocumentID($documentID)
            ->setAgencyAccountNumber($agencyAccountNumber)
            ->setCreationChannel($creationChannel)
            ->setSeatNumber($seatNumber)
            ->setTypeOfPass($typeOfPass)
            ->setPassengerReferences($passengerReferences)
            ->setSegmentReferences($segmentReferences)
            ->setIssueTimeLimit($issueTimeLimit)
            ->setIssueDateTime($issueDateTime)
            ->setDocumentStatus($documentStatus)
            ->setCharges($charges)
            ->setFormOfPayment($formOfPayment)
            ->setFile($file)
            ->setIssueType($issueType)
            ->setDocumentRules($documentRules)
            ->setType($type)
            ->setCode($code)
            ->setCodeContext($codeContext);
    }
    /**
     * Get DocumentID value
     * @return string|null
     */
    public function getDocumentID()
    {
        return $this->DocumentID;
    }
    /**
     * Set DocumentID value
     * @param string $documentID
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setDocumentID($documentID = null)
    {
        $this->DocumentID = $documentID;
        return $this;
    }
    /**
     * Get AgencyAccountNumber value
     * @return string|null
     */
    public function getAgencyAccountNumber()
    {
        return $this->AgencyAccountNumber;
    }
    /**
     * Set AgencyAccountNumber value
     * @param string $agencyAccountNumber
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setAgencyAccountNumber($agencyAccountNumber = null)
    {
        $this->AgencyAccountNumber = $agencyAccountNumber;
        return $this;
    }
    /**
     * Get CreationChannel value
     * @return string|null
     */
    public function getCreationChannel()
    {
        return $this->CreationChannel;
    }
    /**
     * Set CreationChannel value
     * @param string $creationChannel
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setCreationChannel($creationChannel = null)
    {
        $this->CreationChannel = $creationChannel;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setSeatNumber($seatNumber = null)
    {
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get TypeOfPass value
     * @return string|null
     */
    public function getTypeOfPass()
    {
        return $this->TypeOfPass;
    }
    /**
     * Set TypeOfPass value
     * @param string $typeOfPass
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setTypeOfPass($typeOfPass = null)
    {
        $this->TypeOfPass = $typeOfPass;
        return $this;
    }
    /**
     * Get PassengerReferences value
     * @return \Sabre\TravelItineraryRead\Structs\PassengerReferences|null
     */
    public function getPassengerReferences()
    {
        return $this->PassengerReferences;
    }
    /**
     * Set PassengerReferences value
     * @param \Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setPassengerReferences(\Sabre\TravelItineraryRead\Structs\PassengerReferences $passengerReferences = null)
    {
        $this->PassengerReferences = $passengerReferences;
        return $this;
    }
    /**
     * Get SegmentReferences value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentReferences|null
     */
    public function getSegmentReferences()
    {
        return $this->SegmentReferences;
    }
    /**
     * Set SegmentReferences value
     * @param \Sabre\TravelItineraryRead\Structs\SegmentReferences $segmentReferences
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setSegmentReferences(\Sabre\TravelItineraryRead\Structs\SegmentReferences $segmentReferences = null)
    {
        $this->SegmentReferences = $segmentReferences;
        return $this;
    }
    /**
     * Get IssueTimeLimit value
     * @return string|null
     */
    public function getIssueTimeLimit()
    {
        return $this->IssueTimeLimit;
    }
    /**
     * Set IssueTimeLimit value
     * @param string $issueTimeLimit
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setIssueTimeLimit($issueTimeLimit = null)
    {
        $this->IssueTimeLimit = $issueTimeLimit;
        return $this;
    }
    /**
     * Get IssueDateTime value
     * @return string|null
     */
    public function getIssueDateTime()
    {
        return $this->IssueDateTime;
    }
    /**
     * Set IssueDateTime value
     * @param string $issueDateTime
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setIssueDateTime($issueDateTime = null)
    {
        $this->IssueDateTime = $issueDateTime;
        return $this;
    }
    /**
     * Get DocumentStatus value
     * @return string|null
     */
    public function getDocumentStatus()
    {
        return $this->DocumentStatus;
    }
    /**
     * Set DocumentStatus value
     * @param string $documentStatus
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setDocumentStatus($documentStatus = null)
    {
        $this->DocumentStatus = $documentStatus;
        return $this;
    }
    /**
     * Get Charges value
     * @return \Sabre\TravelItineraryRead\Structs\ChargesType|null
     */
    public function getCharges()
    {
        return $this->Charges;
    }
    /**
     * Set Charges value
     * @param \Sabre\TravelItineraryRead\Structs\ChargesType $charges
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setCharges(\Sabre\TravelItineraryRead\Structs\ChargesType $charges = null)
    {
        $this->Charges = $charges;
        return $this;
    }
    /**
     * Get FormOfPayment value
     * @return \Sabre\TravelItineraryRead\Structs\FormOfPayment|null
     */
    public function getFormOfPayment()
    {
        return $this->FormOfPayment;
    }
    /**
     * Set FormOfPayment value
     * @param \Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setFormOfPayment(\Sabre\TravelItineraryRead\Structs\FormOfPayment $formOfPayment = null)
    {
        $this->FormOfPayment = $formOfPayment;
        return $this;
    }
    /**
     * Get File value
     * @return \Sabre\TravelItineraryRead\Structs\File|null
     */
    public function getFile()
    {
        return $this->File;
    }
    /**
     * Set File value
     * @param \Sabre\TravelItineraryRead\Structs\File $file
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setFile(\Sabre\TravelItineraryRead\Structs\File $file = null)
    {
        $this->File = $file;
        return $this;
    }
    /**
     * Get IssueType value
     * @return string|null
     */
    public function getIssueType()
    {
        return $this->IssueType;
    }
    /**
     * Set IssueType value
     * @param string $issueType
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setIssueType($issueType = null)
    {
        $this->IssueType = $issueType;
        return $this;
    }
    /**
     * Get DocumentRules value
     * @return \Sabre\TravelItineraryRead\Structs\DocumentRules|null
     */
    public function getDocumentRules()
    {
        return $this->DocumentRules;
    }
    /**
     * Set DocumentRules value
     * @param \Sabre\TravelItineraryRead\Structs\DocumentRules $documentRules
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setDocumentRules(\Sabre\TravelItineraryRead\Structs\DocumentRules $documentRules = null)
    {
        $this->DocumentRules = $documentRules;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setCode($code = null)
    {
        $this->code = $code;
        return $this;
    }
    /**
     * Get codeContext value
     * @return string|null
     */
    public function getCodeContext()
    {
        return $this->codeContext;
    }
    /**
     * Set codeContext value
     * @param string $codeContext
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public function setCodeContext($codeContext = null)
    {
        $this->codeContext = $codeContext;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\DocumentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
