<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryInfo Structs
 * @subpackage Structs
 */
class DeliveryInfo extends AbstractStructBase
{
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\AddressType
     */
    public $Address;
    /**
     * The CollectionFee
     * Meta informations extracted from the WSDL
     * - documentation: "CollectionFee" is used to return the Collection fee details associated with the vehicle reservation if applicable. | "CollectionFee" is used to return the Collection fee details associated with the vehicle reservation if applicable.
     * - minOccurs: 0
     * @var string
     */
    public $CollectionFee;
    /**
     * The ContactNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PhoneType
     */
    public $ContactNumber;
    /**
     * The siteID
     * Meta informations extracted from the WSDL
     * - documentation: "siteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $siteID;
    /**
     * The siteName
     * Meta informations extracted from the WSDL
     * - documentation: "siteName" is used to return the collection site name associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $siteName;
    /**
     * The ContactNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\ContactNumbers
     */
    public $ContactNumbers;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - documentation: "Text" is used to return miscellaneous delivery-related text.
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The SiteID
     * Meta informations extracted from the WSDL
     * - documentation: "SiteID" is used to return the collection site ID associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteID;
    /**
     * The SiteName
     * Meta informations extracted from the WSDL
     * - documentation: "SiteName" is used to return the collection site name associated with the vehicle reservation if applicable.
     * - use: optional
     * @var string
     */
    public $SiteName;
    /**
     * Constructor method for DeliveryInfo
     * @uses DeliveryInfo::setAddress()
     * @uses DeliveryInfo::setCollectionFee()
     * @uses DeliveryInfo::setContactNumber()
     * @uses DeliveryInfo::setSiteID()
     * @uses DeliveryInfo::setSiteName()
     * @uses DeliveryInfo::setContactNumbers()
     * @uses DeliveryInfo::setText()
     * @uses DeliveryInfo::setSiteID_1()
     * @uses DeliveryInfo::setSiteName_1()
     * @param \Sabre\TravelItineraryRead\Structs\AddressType $address
     * @param string $collectionFee
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber
     * @param string $siteID
     * @param string $siteName
     * @param \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers
     * @param string $text
     * @param string $siteID
     * @param string $siteName
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\AddressType $address = null, $collectionFee = null, \Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber = null, $siteID = null, $siteName = null, \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers = null, $text = null, $siteID = null, $siteName = null)
    {
        $this
            ->setAddress($address)
            ->setCollectionFee($collectionFee)
            ->setContactNumber($contactNumber)
            ->setSiteID($siteID)
            ->setSiteName($siteName)
            ->setContactNumbers($contactNumbers)
            ->setText($text)
            ->setSiteID_1($siteID)
            ->setSiteName_1($siteName);
    }
    /**
     * Get Address value
     * @return \Sabre\TravelItineraryRead\Structs\AddressType|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param \Sabre\TravelItineraryRead\Structs\AddressType $address
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setAddress(\Sabre\TravelItineraryRead\Structs\AddressType $address = null)
    {
        $this->Address = $address;
        return $this;
    }
    /**
     * Get CollectionFee value
     * @return string|null
     */
    public function getCollectionFee()
    {
        return $this->CollectionFee;
    }
    /**
     * Set CollectionFee value
     * @param string $collectionFee
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setCollectionFee($collectionFee = null)
    {
        $this->CollectionFee = $collectionFee;
        return $this;
    }
    /**
     * Get ContactNumber value
     * @return \Sabre\TravelItineraryRead\Structs\PhoneType|null
     */
    public function getContactNumber()
    {
        return $this->ContactNumber;
    }
    /**
     * Set ContactNumber value
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setContactNumber(\Sabre\TravelItineraryRead\Structs\PhoneType $contactNumber = null)
    {
        $this->ContactNumber = $contactNumber;
        return $this;
    }
    /**
     * Get SiteID value
     * @return string|null
     */
    public function getSiteID()
    {
        return $this->siteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setSiteID($siteID = null)
    {
        $this->siteID = $siteID;
        return $this;
    }
    /**
     * Get SiteName value
     * @return string|null
     */
    public function getSiteName()
    {
        return $this->siteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setSiteName($siteName = null)
    {
        $this->siteName = $siteName;
        return $this;
    }
    /**
     * Get ContactNumbers value
     * @return \Sabre\TravelItineraryRead\Structs\ContactNumbers|null
     */
    public function getContactNumbers()
    {
        return $this->ContactNumbers;
    }
    /**
     * Set ContactNumbers value
     * @param \Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setContactNumbers(\Sabre\TravelItineraryRead\Structs\ContactNumbers $contactNumbers = null)
    {
        $this->ContactNumbers = $contactNumbers;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get siteID_1 value
     * @return siteID_1
     */
    public function getSiteID_1()
    {
        return $this->SiteID;
    }
    /**
     * Set SiteID value
     * @param string $siteID
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setSiteID_1($siteID = null)
    {
        $this->SiteID = $siteID;
        return $this;
    }
    /**
     * Get siteName_1 value
     * @return siteName_1
     */
    public function getSiteName_1()
    {
        return $this->SiteName;
    }
    /**
     * Set SiteName value
     * @param string $siteName
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public function setSiteName_1($siteName = null)
    {
        $this->SiteName = $siteName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\DeliveryInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
