<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Deal Structs
 * Meta informations extracted from the WSDL
 * - documentation: Information about applied discount/markup for this ancillary
 * @subpackage Structs
 */
class Deal extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $type;
    /**
     * The Percentage
     * Meta informations extracted from the WSDL
     * - documentation: Percentage as defined in RULE for percentage discounts/markups
     * - minOccurs: 0
     * @var float
     */
    public $Percentage;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Amount
     */
    public $Amount;
    /**
     * Constructor method for Deal
     * @uses Deal::setType()
     * @uses Deal::setPercentage()
     * @uses Deal::setAmount()
     * @param string $type
     * @param float $percentage
     * @param \Sabre\TravelItineraryRead\Structs\Amount $amount
     */
    public function __construct($type = null, $percentage = null, \Sabre\TravelItineraryRead\Structs\Amount $amount = null)
    {
        $this
            ->setType($type)
            ->setPercentage($percentage)
            ->setAmount($amount);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\Deal
     */
    public function setType($type = null)
    {
        $this->type = $type;
        return $this;
    }
    /**
     * Get Percentage value
     * @return float|null
     */
    public function getPercentage()
    {
        return $this->Percentage;
    }
    /**
     * Set Percentage value
     * @param float $percentage
     * @return \Sabre\TravelItineraryRead\Structs\Deal
     */
    public function setPercentage($percentage = null)
    {
        $this->Percentage = $percentage;
        return $this;
    }
    /**
     * Get Amount value
     * @return \Sabre\TravelItineraryRead\Structs\Amount|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \Sabre\TravelItineraryRead\Structs\Amount $amount
     * @return \Sabre\TravelItineraryRead\Structs\Deal
     */
    public function setAmount(\Sabre\TravelItineraryRead\Structs\Amount $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Deal
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
