<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditCard Structs
 * @subpackage Structs
 */
class CreditCard extends AbstractStructBase
{
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Number;
    /**
     * The Issuer
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Issuer;
    /**
     * The ExpirationMonth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationMonth;
    /**
     * The ExpirationYear
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ExpirationYear;
    /**
     * The CardHolder
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\CardHolder
     */
    public $CardHolder;
    /**
     * Constructor method for CreditCard
     * @uses CreditCard::setNumber()
     * @uses CreditCard::setIssuer()
     * @uses CreditCard::setExpirationMonth()
     * @uses CreditCard::setExpirationYear()
     * @uses CreditCard::setCardHolder()
     * @param string $number
     * @param string $issuer
     * @param string $expirationMonth
     * @param string $expirationYear
     * @param \Sabre\TravelItineraryRead\Structs\CardHolder $cardHolder
     */
    public function __construct($number = null, $issuer = null, $expirationMonth = null, $expirationYear = null, \Sabre\TravelItineraryRead\Structs\CardHolder $cardHolder = null)
    {
        $this
            ->setNumber($number)
            ->setIssuer($issuer)
            ->setExpirationMonth($expirationMonth)
            ->setExpirationYear($expirationYear)
            ->setCardHolder($cardHolder);
    }
    /**
     * Get Number value
     * @return string|null
     */
    public function getNumber()
    {
        return $this->Number;
    }
    /**
     * Set Number value
     * @param string $number
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public function setNumber($number = null)
    {
        $this->Number = $number;
        return $this;
    }
    /**
     * Get Issuer value
     * @return string|null
     */
    public function getIssuer()
    {
        return $this->Issuer;
    }
    /**
     * Set Issuer value
     * @param string $issuer
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public function setIssuer($issuer = null)
    {
        $this->Issuer = $issuer;
        return $this;
    }
    /**
     * Get ExpirationMonth value
     * @return string|null
     */
    public function getExpirationMonth()
    {
        return $this->ExpirationMonth;
    }
    /**
     * Set ExpirationMonth value
     * @param string $expirationMonth
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public function setExpirationMonth($expirationMonth = null)
    {
        $this->ExpirationMonth = $expirationMonth;
        return $this;
    }
    /**
     * Get ExpirationYear value
     * @return string|null
     */
    public function getExpirationYear()
    {
        return $this->ExpirationYear;
    }
    /**
     * Set ExpirationYear value
     * @param string $expirationYear
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public function setExpirationYear($expirationYear = null)
    {
        $this->ExpirationYear = $expirationYear;
        return $this;
    }
    /**
     * Get CardHolder value
     * @return \Sabre\TravelItineraryRead\Structs\CardHolder|null
     */
    public function getCardHolder()
    {
        return $this->CardHolder;
    }
    /**
     * Set CardHolder value
     * @param \Sabre\TravelItineraryRead\Structs\CardHolder $cardHolder
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public function setCardHolder(\Sabre\TravelItineraryRead\Structs\CardHolder $cardHolder = null)
    {
        $this->CardHolder = $cardHolder;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\CreditCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
