<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission Structs
 * Meta informations extracted from the WSDL
 * - documentation: Commission is used as a place holder for commission associated with the particular accounting line Example: Commission Amount="31.00" Percent="1" | "Commission" is used to return commission-related information. | "Commission" is used
 * to return commission-related information.
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The Indicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Indicator;
    /**
     * The PerNight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PerNight;
    /**
     * The Text
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Text;
    /**
     * The amount
     * Meta informations extracted from the WSDL
     * - documentation: "amount" is used to return the commission amount if applicable.
     * - use: optional
     * @var string
     */
    public $amount;
    /**
     * The percent
     * Meta informations extracted from the WSDL
     * - documentation: "percent" is used to return the commission percentage if applicable.
     * - use: optional
     * @var string
     */
    public $percent;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - documentation: "Amount" is used to return the commission amount associated with the particular hotel reservation if applicable. | "Amount" is used to return the commission amount if applicable.
     * - use: optional
     * @var string
     */
    public $Amount;
    /**
     * The Percent
     * Meta informations extracted from the WSDL
     * - documentation: "Percent" is used to return the commission percentage associated with the particular hotel reservation if applicable. | "Percent" is used to return the commission percentage if applicable.
     * - minOccurs: 0
     * - use: optional
     * @var string
     */
    public $Percent;
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $CurrencyCode;
    /**
     * The _
     * @var string
     */
    public $_;
    /**
     * The NonCommission
     * Meta informations extracted from the WSDL
     * - documentation: "NonCommission" is used to return non-commission-related information.
     * - use: optional
     * @var bool
     */
    public $NonCommission;
    /**
     * Constructor method for Commission
     * @uses Commission::setIndicator()
     * @uses Commission::setPerNight()
     * @uses Commission::setText()
     * @uses Commission::setAmount()
     * @uses Commission::setPercent()
     * @uses Commission::setAmount_1()
     * @uses Commission::setPercent_1()
     * @uses Commission::setCurrencyCode()
     * @uses Commission::set_()
     * @uses Commission::setNonCommission()
     * @param string $indicator
     * @param string $perNight
     * @param string $text
     * @param string $amount
     * @param string $percent
     * @param string $amount
     * @param string $percent
     * @param string $currencyCode
     * @param string $_
     * @param bool $nonCommission
     */
    public function __construct($indicator = null, $perNight = null, $text = null, $amount = null, $percent = null, $amount = null, $percent = null, $currencyCode = null, $_ = null, $nonCommission = null)
    {
        $this
            ->setIndicator($indicator)
            ->setPerNight($perNight)
            ->setText($text)
            ->setAmount($amount)
            ->setPercent($percent)
            ->setAmount_1($amount)
            ->setPercent_1($percent)
            ->setCurrencyCode($currencyCode)
            ->set_($_)
            ->setNonCommission($nonCommission);
    }
    /**
     * Get Indicator value
     * @return string|null
     */
    public function getIndicator()
    {
        return $this->Indicator;
    }
    /**
     * Set Indicator value
     * @param string $indicator
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setIndicator($indicator = null)
    {
        $this->Indicator = $indicator;
        return $this;
    }
    /**
     * Get PerNight value
     * @return string|null
     */
    public function getPerNight()
    {
        return $this->PerNight;
    }
    /**
     * Set PerNight value
     * @param string $perNight
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setPerNight($perNight = null)
    {
        $this->PerNight = $perNight;
        return $this;
    }
    /**
     * Get Text value
     * @return string|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * Set Text value
     * @param string $text
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setText($text = null)
    {
        $this->Text = $text;
        return $this;
    }
    /**
     * Get Amount value
     * @return string|null
     */
    public function getAmount()
    {
        return $this->amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setAmount($amount = null)
    {
        $this->amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setPercent($percent = null)
    {
        $this->percent = $percent;
        return $this;
    }
    /**
     * Get amount_1 value
     * @return amount_1
     */
    public function getAmount_1()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param string $amount
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setAmount_1($amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get percent_1 value
     * @return percent_1
     */
    public function getPercent_1()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setPercent_1($percent = null)
    {
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get CurrencyCode value
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return $this->CurrencyCode;
    }
    /**
     * Set CurrencyCode value
     * @param string $currencyCode
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setCurrencyCode($currencyCode = null)
    {
        $this->CurrencyCode = $currencyCode;
        return $this;
    }
    /**
     * Get _ value
     * @return string|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param string $_
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function set_($_ = null)
    {
        $this->_ = $_;
        return $this;
    }
    /**
     * Get NonCommission value
     * @return bool|null
     */
    public function getNonCommission()
    {
        return $this->NonCommission;
    }
    /**
     * Set NonCommission value
     * @param bool $nonCommission
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public function setNonCommission($nonCommission = null)
    {
        $this->NonCommission = $nonCommission;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\Commission
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
