<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssociationMatrix Structs
 * @subpackage Structs
 */
class AssociationMatrix extends AbstractStructBase
{
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Name;
    /**
     * The Parent
     * @var \Sabre\TravelItineraryRead\Structs\_Parent
     */
    public $Parent;
    /**
     * The Child
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \Sabre\TravelItineraryRead\Structs\Child[]
     */
    public $Child;
    /**
     * The elementId
     * @var string
     */
    public $elementId;
    /**
     * Constructor method for AssociationMatrix
     * @uses AssociationMatrix::setName()
     * @uses AssociationMatrix::setParent()
     * @uses AssociationMatrix::setChild()
     * @uses AssociationMatrix::setElementId()
     * @param string $name
     * @param \Sabre\TravelItineraryRead\Structs\_Parent $parent
     * @param \Sabre\TravelItineraryRead\Structs\Child[] $child
     * @param string $elementId
     */
    public function __construct($name = null, \Sabre\TravelItineraryRead\Structs\_Parent $parent = null, array $child = array(), $elementId = null)
    {
        $this
            ->setName($name)
            ->setParent($parent)
            ->setChild($child)
            ->setElementId($elementId);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Parent value
     * @return \Sabre\TravelItineraryRead\Structs\_Parent|null
     */
    public function getParent()
    {
        return $this->Parent;
    }
    /**
     * Set Parent value
     * @param \Sabre\TravelItineraryRead\Structs\_Parent $parent
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public function setParent(\Sabre\TravelItineraryRead\Structs\_Parent $parent = null)
    {
        $this->Parent = $parent;
        return $this;
    }
    /**
     * Get Child value
     * @return \Sabre\TravelItineraryRead\Structs\Child[]|null
     */
    public function getChild()
    {
        return $this->Child;
    }
    /**
     * Set Child value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Child[] $child
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public function setChild(array $child = array())
    {
        $this->Child = $child;
        return $this;
    }
    /**
     * Add item to Child value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Child $item
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public function addToChild(\Sabre\TravelItineraryRead\Structs\Child $item)
    {
        $this->Child[] = $item;
        return $this;
    }
    /**
     * Get elementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->elementId;
    }
    /**
     * Set elementId value
     * @param string $elementId
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public function setElementId($elementId = null)
    {
        $this->elementId = $elementId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AssociationMatrix
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
