<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArrangerDetailsType Structs
 * @subpackage Structs
 */
class ArrangerDetailsType extends AbstractStructBase
{
    /**
     * The PersonName
     * @var \Sabre\TravelItineraryRead\Structs\PersonNameType
     */
    public $PersonName;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\PhoneType[]
     */
    public $Telephone;
    /**
     * The Email
     * Meta informations extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var string[]
     */
    public $Email;
    /**
     * Constructor method for ArrangerDetailsType
     * @uses ArrangerDetailsType::setPersonName()
     * @uses ArrangerDetailsType::setTelephone()
     * @uses ArrangerDetailsType::setEmail()
     * @param \Sabre\TravelItineraryRead\Structs\PersonNameType $personName
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @param string[] $email
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\PersonNameType $personName = null, array $telephone = array(), array $email = array())
    {
        $this
            ->setPersonName($personName)
            ->setTelephone($telephone)
            ->setEmail($email);
    }
    /**
     * Get PersonName value
     * @return \Sabre\TravelItineraryRead\Structs\PersonNameType|null
     */
    public function getPersonName()
    {
        return $this->PersonName;
    }
    /**
     * Set PersonName value
     * @param \Sabre\TravelItineraryRead\Structs\PersonNameType $personName
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public function setPersonName(\Sabre\TravelItineraryRead\Structs\PersonNameType $personName = null)
    {
        $this->PersonName = $personName;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \Sabre\TravelItineraryRead\Structs\PhoneType[]|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType[] $telephone
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public function setTelephone(array $telephone = array())
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Add item to Telephone value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\PhoneType $item
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public function addToTelephone(\Sabre\TravelItineraryRead\Structs\PhoneType $item)
    {
        $this->Telephone[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return string[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param string[] $email
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public function setEmail(array $email = array())
    {
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public function addToEmail($item)
    {
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\ArrangerDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
