<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryServiceData Structs
 * @subpackage Structs
 */
class AncillaryServiceData extends AbstractStructBase
{
    /**
     * The NameAssociationList
     * @var \Sabre\TravelItineraryRead\Structs\NameAssociationList
     */
    public $NameAssociationList;
    /**
     * The SegmentAssociationList
     * @var \Sabre\TravelItineraryRead\Structs\SegmentAssociationList
     */
    public $SegmentAssociationList;
    /**
     * The CommercialName
     * @var CommonString
     */
    public $CommercialName;
    /**
     * The RficCode
     * @var CommonString
     */
    public $RficCode;
    /**
     * The RficSubcode
     * @var string
     */
    public $RficSubcode;
    /**
     * The SSRCode
     * @var CommonString
     */
    public $SSRCode;
    /**
     * The ProductTextDetails
     * @var \Sabre\TravelItineraryRead\Structs\ProductTextDetails
     */
    public $ProductTextDetails;
    /**
     * The ProductText
     * @var CommonString
     */
    public $ProductText;
    /**
     * The OwningCarrierCode
     * @var CommonString
     */
    public $OwningCarrierCode;
    /**
     * The SsimCode
     * @var CommonString
     */
    public $SsimCode;
    /**
     * The BookingIndicator
     * @var CommonString
     */
    public $BookingIndicator;
    /**
     * The Vendor
     * @var CommonString
     */
    public $Vendor;
    /**
     * The EMDType
     * @var CommonString
     */
    public $EMDType;
    /**
     * The EMDNumber
     * @var CommonString
     */
    public $EMDNumber;
    /**
     * The EMDCoupon
     * @var CommonString
     */
    public $EMDCoupon;
    /**
     * The ETicketNumber
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate
     */
    public $ETicketNumber;
    /**
     * The ServiceFeeLineNumber
     * @var CommonString
     */
    public $ServiceFeeLineNumber;
    /**
     * The DisplayOnlyIndicator
     * @var bool
     */
    public $DisplayOnlyIndicator;
    /**
     * The ConsumptionIndicator
     * @var CommonString
     */
    public $ConsumptionIndicator;
    /**
     * The PresentTo
     * @var CommonString
     */
    public $PresentTo;
    /**
     * The AtCity
     * @var CommonString
     */
    public $AtCity;
    /**
     * The Endorsements
     * @var CommonString
     */
    public $Endorsements;
    /**
     * The StationIndicator
     * @var CommonString
     */
    public $StationIndicator;
    /**
     * The ServiceCity
     * @var CommonString
     */
    public $ServiceCity;
    /**
     * The ServiceCityDestination
     * @var CommonString
     */
    public $ServiceCityDestination;
    /**
     * The ServiceType
     * @var ServiceType
     */
    public $ServiceType;
    /**
     * The RuleSet
     * @var \Sabre\TravelItineraryRead\Structs\RuleSet
     */
    public $RuleSet;
    /**
     * The OriginalPrice
     * @var \Sabre\TravelItineraryRead\Structs\OriginalPrice
     */
    public $OriginalPrice;
    /**
     * The NewMiscIndicator
     * @var string
     */
    public $NewMiscIndicator;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The SegmentNumber
     * @var SegmentID.Pricing
     */
    public $SegmentNumber;
    /**
     * The EquivalentPrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $EquivalentPrice;
    /**
     * The TTLPrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $TTLPrice;
    /**
     * The PortionOfTravelIndicator
     * @var string
     */
    public $PortionOfTravelIndicator;
    /**
     * The OriginalBasePrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $OriginalBasePrice;
    /**
     * The RefundIndicator
     * @var CommonString
     */
    public $RefundIndicator;
    /**
     * The CommisionIndicator
     * @var CommonString
     */
    public $CommisionIndicator;
    /**
     * The InterlineIndicator
     * @var CommonString
     */
    public $InterlineIndicator;
    /**
     * The FeeApplicationIndicator
     * @var CommonString
     */
    public $FeeApplicationIndicator;
    /**
     * The PassengerTypeCode
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The BoardPoint
     * @var string
     */
    public $BoardPoint;
    /**
     * The OffPoint
     * @var string
     */
    public $OffPoint;
    /**
     * The TaxesIncluded
     * @var bool
     */
    public $TaxesIncluded;
    /**
     * The Taxes
     * @var \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public $Taxes;
    /**
     * The SoftMatchIndicator
     * @var bool
     */
    public $SoftMatchIndicator;
    /**
     * The NoChargeNotAvailIndicator
     * @var string
     */
    public $NoChargeNotAvailIndicator;
    /**
     * The TicketCouponNumberAssociation
     * @var \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation
     */
    public $TicketCouponNumberAssociation;
    /**
     * The SimultaneousTicketIndicator
     * @var string
     */
    public $SimultaneousTicketIndicator;
    /**
     * The FormOfRefund
     * @var string
     */
    public $FormOfRefund;
    /**
     * The FeeNotGuaranteedIndicator
     * @var bool
     */
    public $FeeNotGuaranteedIndicator;
    /**
     * The FQTVTierLevel
     * @var int
     */
    public $FQTVTierLevel;
    /**
     * The TourCodeSHC
     * @var CommonString
     */
    public $TourCodeSHC;
    /**
     * The TravelDateEffective
     * @var CommonString
     */
    public $TravelDateEffective;
    /**
     * The LatestTravelDatePermitted
     * @var CommonString
     */
    public $LatestTravelDatePermitted;
    /**
     * The PurchaseByDate
     * Meta informations extracted from the WSDL
     * - documentation: A simple date type. Allows specifying a date without a year. Accepted formats: "yyyy-mm-dd" or "mm-dd"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))
     * @var string
     */
    public $PurchaseByDate;
    /**
     * The TotalOriginalBasePrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $TotalOriginalBasePrice;
    /**
     * The TotalEquivalentPrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $TotalEquivalentPrice;
    /**
     * The TotalTTLPrice
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $TotalTTLPrice;
    /**
     * The TotalTaxes
     * @var \Sabre\TravelItineraryRead\Structs\TotalTaxes
     */
    public $TotalTaxes;
    /**
     * The TaxExemptIndicator
     * @var CommonString
     */
    public $TaxExemptIndicator;
    /**
     * The BagWeight
     * @var \Sabre\TravelItineraryRead\Structs\BagWeight
     */
    public $BagWeight;
    /**
     * The StatusIndicator
     * @var int
     */
    public $StatusIndicator;
    /**
     * The NumberOfItems
     * @var CommonString
     */
    public $NumberOfItems;
    /**
     * The ActionCode
     * @var string
     */
    public $ActionCode;
    /**
     * The SegmentIndicator
     * @var CommonString
     */
    public $SegmentIndicator;
    /**
     * The FrequentFlyerTier
     * @var CommonString
     */
    public $FrequentFlyerTier;
    /**
     * The RefundFormIndicator
     * @var CommonString
     */
    public $RefundFormIndicator;
    /**
     * The FareGuaranteedIndicator
     * @var CommonString
     */
    public $FareGuaranteedIndicator;
    /**
     * The ServiceChargeIndicator
     * @var CommonString
     */
    public $ServiceChargeIndicator;
    /**
     * The AdvancePurchaseIndicator
     * @var CommonString
     */
    public $AdvancePurchaseIndicator;
    /**
     * The BookingSource
     * @var CommonString
     */
    public $BookingSource;
    /**
     * The TaxIndicator
     * @var CommonString
     */
    public $TaxIndicator;
    /**
     * The TicketingIndicator
     * @var CommonString
     */
    public $TicketingIndicator;
    /**
     * The FeeWaiveReason
     * @var CommonString
     */
    public $FeeWaiveReason;
    /**
     * The FulfillmentType
     * @var CommonString
     */
    public $FulfillmentType;
    /**
     * The AaPayOriginalSeat
     * @var CommonString
     */
    public $AaPayOriginalSeat;
    /**
     * The PdcSeat
     * @var CommonString
     */
    public $PdcSeat;
    /**
     * The EquipmentType
     * @var CommonString
     */
    public $EquipmentType;
    /**
     * The AaPayOptionalStatus
     * @var string
     */
    public $AaPayOptionalStatus;
    /**
     * The FirstTravelDate
     * @var string
     */
    public $FirstTravelDate;
    /**
     * The LastTravelDate
     * @var string
     */
    public $LastTravelDate;
    /**
     * The TTYConfirmationTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TTYConfirmationTimestamp;
    /**
     * The PurchaseTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $PurchaseTimestamp;
    /**
     * The BrandedFareId
     * @var CommonString
     */
    public $BrandedFareId;
    /**
     * The GroupCode
     * @var CommonString
     */
    public $GroupCode;
    /**
     * The TourCode
     * @var CommonString
     */
    public $TourCode;
    /**
     * The EmdPaperIndicator
     * @var CommonString
     */
    public $EmdPaperIndicator;
    /**
     * The SeatRequestTransactionID
     * @var string
     */
    public $SeatRequestTransactionID;
    /**
     * The TicketUsedForEMDPricing
     * @var CommonString
     */
    public $TicketUsedForEMDPricing;
    /**
     * The PaperDocRequired
     * @var OptionalIndicator
     */
    public $PaperDocRequired;
    /**
     * The EMDConsummedAtIssuance
     * @var OptionalIndicator
     */
    public $EMDConsummedAtIssuance;
    /**
     * The TaxExemption
     * @var Indicator
     */
    public $TaxExemption;
    /**
     * The PriceQuoteDesignator
     * @var int
     */
    public $PriceQuoteDesignator;
    /**
     * The PriceMismatchAction
     * @var PriceMismatchAction
     */
    public $PriceMismatchAction;
    /**
     * The InventoryControlledIndicator
     * @var CommonString
     */
    public $InventoryControlledIndicator;
    /**
     * The InventoryConfirmationToken
     * @var CommonString
     */
    public $InventoryConfirmationToken;
    /**
     * The ACSCount
     * @var int
     */
    public $ACSCount;
    /**
     * The NetAmount
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPrice
     */
    public $NetAmount;
    /**
     * The AncillaryPriceQuoteData
     * @var \Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData
     */
    public $AncillaryPriceQuoteData;
    /**
     * The Segment
     * @var \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion
     */
    public $Segment;
    /**
     * The TravelPortions
     * @var \Sabre\TravelItineraryRead\Structs\TravelPortions
     */
    public $TravelPortions;
    /**
     * The id
     * @var UniqueIdentifier
     */
    public $id;
    /**
     * The op
     * @var OperationType
     */
    public $op;
    /**
     * The elementId
     * @var string
     */
    public $elementId;
    /**
     * The Segments
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[]
     */
    public $Segments;
    /**
     * Constructor method for AncillaryServiceData
     * @uses AncillaryServiceData::setNameAssociationList()
     * @uses AncillaryServiceData::setSegmentAssociationList()
     * @uses AncillaryServiceData::setCommercialName()
     * @uses AncillaryServiceData::setRficCode()
     * @uses AncillaryServiceData::setRficSubcode()
     * @uses AncillaryServiceData::setSSRCode()
     * @uses AncillaryServiceData::setProductTextDetails()
     * @uses AncillaryServiceData::setProductText()
     * @uses AncillaryServiceData::setOwningCarrierCode()
     * @uses AncillaryServiceData::setSsimCode()
     * @uses AncillaryServiceData::setBookingIndicator()
     * @uses AncillaryServiceData::setVendor()
     * @uses AncillaryServiceData::setEMDType()
     * @uses AncillaryServiceData::setEMDNumber()
     * @uses AncillaryServiceData::setEMDCoupon()
     * @uses AncillaryServiceData::setETicketNumber()
     * @uses AncillaryServiceData::setServiceFeeLineNumber()
     * @uses AncillaryServiceData::setDisplayOnlyIndicator()
     * @uses AncillaryServiceData::setConsumptionIndicator()
     * @uses AncillaryServiceData::setPresentTo()
     * @uses AncillaryServiceData::setAtCity()
     * @uses AncillaryServiceData::setEndorsements()
     * @uses AncillaryServiceData::setStationIndicator()
     * @uses AncillaryServiceData::setServiceCity()
     * @uses AncillaryServiceData::setServiceCityDestination()
     * @uses AncillaryServiceData::setServiceType()
     * @uses AncillaryServiceData::setRuleSet()
     * @uses AncillaryServiceData::setOriginalPrice()
     * @uses AncillaryServiceData::setNewMiscIndicator()
     * @uses AncillaryServiceData::setQuantity()
     * @uses AncillaryServiceData::setSegmentNumber()
     * @uses AncillaryServiceData::setEquivalentPrice()
     * @uses AncillaryServiceData::setTTLPrice()
     * @uses AncillaryServiceData::setPortionOfTravelIndicator()
     * @uses AncillaryServiceData::setOriginalBasePrice()
     * @uses AncillaryServiceData::setRefundIndicator()
     * @uses AncillaryServiceData::setCommisionIndicator()
     * @uses AncillaryServiceData::setInterlineIndicator()
     * @uses AncillaryServiceData::setFeeApplicationIndicator()
     * @uses AncillaryServiceData::setPassengerTypeCode()
     * @uses AncillaryServiceData::setBoardPoint()
     * @uses AncillaryServiceData::setOffPoint()
     * @uses AncillaryServiceData::setTaxesIncluded()
     * @uses AncillaryServiceData::setTaxes()
     * @uses AncillaryServiceData::setSoftMatchIndicator()
     * @uses AncillaryServiceData::setNoChargeNotAvailIndicator()
     * @uses AncillaryServiceData::setTicketCouponNumberAssociation()
     * @uses AncillaryServiceData::setSimultaneousTicketIndicator()
     * @uses AncillaryServiceData::setFormOfRefund()
     * @uses AncillaryServiceData::setFeeNotGuaranteedIndicator()
     * @uses AncillaryServiceData::setFQTVTierLevel()
     * @uses AncillaryServiceData::setTourCodeSHC()
     * @uses AncillaryServiceData::setTravelDateEffective()
     * @uses AncillaryServiceData::setLatestTravelDatePermitted()
     * @uses AncillaryServiceData::setPurchaseByDate()
     * @uses AncillaryServiceData::setTotalOriginalBasePrice()
     * @uses AncillaryServiceData::setTotalEquivalentPrice()
     * @uses AncillaryServiceData::setTotalTTLPrice()
     * @uses AncillaryServiceData::setTotalTaxes()
     * @uses AncillaryServiceData::setTaxExemptIndicator()
     * @uses AncillaryServiceData::setBagWeight()
     * @uses AncillaryServiceData::setStatusIndicator()
     * @uses AncillaryServiceData::setNumberOfItems()
     * @uses AncillaryServiceData::setActionCode()
     * @uses AncillaryServiceData::setSegmentIndicator()
     * @uses AncillaryServiceData::setFrequentFlyerTier()
     * @uses AncillaryServiceData::setRefundFormIndicator()
     * @uses AncillaryServiceData::setFareGuaranteedIndicator()
     * @uses AncillaryServiceData::setServiceChargeIndicator()
     * @uses AncillaryServiceData::setAdvancePurchaseIndicator()
     * @uses AncillaryServiceData::setBookingSource()
     * @uses AncillaryServiceData::setTaxIndicator()
     * @uses AncillaryServiceData::setTicketingIndicator()
     * @uses AncillaryServiceData::setFeeWaiveReason()
     * @uses AncillaryServiceData::setFulfillmentType()
     * @uses AncillaryServiceData::setAaPayOriginalSeat()
     * @uses AncillaryServiceData::setPdcSeat()
     * @uses AncillaryServiceData::setEquipmentType()
     * @uses AncillaryServiceData::setAaPayOptionalStatus()
     * @uses AncillaryServiceData::setFirstTravelDate()
     * @uses AncillaryServiceData::setLastTravelDate()
     * @uses AncillaryServiceData::setTTYConfirmationTimestamp()
     * @uses AncillaryServiceData::setPurchaseTimestamp()
     * @uses AncillaryServiceData::setBrandedFareId()
     * @uses AncillaryServiceData::setGroupCode()
     * @uses AncillaryServiceData::setTourCode()
     * @uses AncillaryServiceData::setEmdPaperIndicator()
     * @uses AncillaryServiceData::setSeatRequestTransactionID()
     * @uses AncillaryServiceData::setTicketUsedForEMDPricing()
     * @uses AncillaryServiceData::setPaperDocRequired()
     * @uses AncillaryServiceData::setEMDConsummedAtIssuance()
     * @uses AncillaryServiceData::setTaxExemption()
     * @uses AncillaryServiceData::setPriceQuoteDesignator()
     * @uses AncillaryServiceData::setPriceMismatchAction()
     * @uses AncillaryServiceData::setInventoryControlledIndicator()
     * @uses AncillaryServiceData::setInventoryConfirmationToken()
     * @uses AncillaryServiceData::setACSCount()
     * @uses AncillaryServiceData::setNetAmount()
     * @uses AncillaryServiceData::setAncillaryPriceQuoteData()
     * @uses AncillaryServiceData::setSegment()
     * @uses AncillaryServiceData::setTravelPortions()
     * @uses AncillaryServiceData::setId()
     * @uses AncillaryServiceData::setOp()
     * @uses AncillaryServiceData::setElementId()
     * @uses AncillaryServiceData::setSegments()
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationList $nameAssociationList
     * @param \Sabre\TravelItineraryRead\Structs\SegmentAssociationList $segmentAssociationList
     * @param CommonString $commercialName
     * @param CommonString $rficCode
     * @param string $rficSubcode
     * @param CommonString $sSRCode
     * @param \Sabre\TravelItineraryRead\Structs\ProductTextDetails $productTextDetails
     * @param CommonString $productText
     * @param CommonString $owningCarrierCode
     * @param CommonString $ssimCode
     * @param CommonString $bookingIndicator
     * @param CommonString $vendor
     * @param CommonString $eMDType
     * @param CommonString $eMDNumber
     * @param CommonString $eMDCoupon
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate $eTicketNumber
     * @param CommonString $serviceFeeLineNumber
     * @param bool $displayOnlyIndicator
     * @param CommonString $consumptionIndicator
     * @param CommonString $presentTo
     * @param CommonString $atCity
     * @param CommonString $endorsements
     * @param CommonString $stationIndicator
     * @param CommonString $serviceCity
     * @param CommonString $serviceCityDestination
     * @param ServiceType $serviceType
     * @param \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet
     * @param \Sabre\TravelItineraryRead\Structs\OriginalPrice $originalPrice
     * @param string $newMiscIndicator
     * @param int $quantity
     * @param SegmentID.Pricing $segmentNumber
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $equivalentPrice
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $tTLPrice
     * @param string $portionOfTravelIndicator
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $originalBasePrice
     * @param CommonString $refundIndicator
     * @param CommonString $commisionIndicator
     * @param CommonString $interlineIndicator
     * @param CommonString $feeApplicationIndicator
     * @param string $passengerTypeCode
     * @param string $boardPoint
     * @param string $offPoint
     * @param bool $taxesIncluded
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @param bool $softMatchIndicator
     * @param string $noChargeNotAvailIndicator
     * @param \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $ticketCouponNumberAssociation
     * @param string $simultaneousTicketIndicator
     * @param string $formOfRefund
     * @param bool $feeNotGuaranteedIndicator
     * @param int $fQTVTierLevel
     * @param CommonString $tourCodeSHC
     * @param CommonString $travelDateEffective
     * @param CommonString $latestTravelDatePermitted
     * @param string $purchaseByDate
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalOriginalBasePrice
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalEquivalentPrice
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalTTLPrice
     * @param \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes
     * @param CommonString $taxExemptIndicator
     * @param \Sabre\TravelItineraryRead\Structs\BagWeight $bagWeight
     * @param int $statusIndicator
     * @param CommonString $numberOfItems
     * @param string $actionCode
     * @param CommonString $segmentIndicator
     * @param CommonString $frequentFlyerTier
     * @param CommonString $refundFormIndicator
     * @param CommonString $fareGuaranteedIndicator
     * @param CommonString $serviceChargeIndicator
     * @param CommonString $advancePurchaseIndicator
     * @param CommonString $bookingSource
     * @param CommonString $taxIndicator
     * @param CommonString $ticketingIndicator
     * @param CommonString $feeWaiveReason
     * @param CommonString $fulfillmentType
     * @param CommonString $aaPayOriginalSeat
     * @param CommonString $pdcSeat
     * @param CommonString $equipmentType
     * @param string $aaPayOptionalStatus
     * @param string $firstTravelDate
     * @param string $lastTravelDate
     * @param string $tTYConfirmationTimestamp
     * @param string $purchaseTimestamp
     * @param CommonString $brandedFareId
     * @param CommonString $groupCode
     * @param CommonString $tourCode
     * @param CommonString $emdPaperIndicator
     * @param string $seatRequestTransactionID
     * @param CommonString $ticketUsedForEMDPricing
     * @param OptionalIndicator $paperDocRequired
     * @param OptionalIndicator $eMDConsummedAtIssuance
     * @param Indicator $taxExemption
     * @param int $priceQuoteDesignator
     * @param PriceMismatchAction $priceMismatchAction
     * @param CommonString $inventoryControlledIndicator
     * @param CommonString $inventoryConfirmationToken
     * @param int $aCSCount
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $netAmount
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData $ancillaryPriceQuoteData
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $segment
     * @param \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions
     * @param UniqueIdentifier $id
     * @param OperationType $op
     * @param string $elementId
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[] $segments
     */
    public function __construct(\Sabre\TravelItineraryRead\Structs\NameAssociationList $nameAssociationList = null, \Sabre\TravelItineraryRead\Structs\SegmentAssociationList $segmentAssociationList = null, CommonString $commercialName = null, CommonString $rficCode = null, $rficSubcode = null, CommonString $sSRCode = null, \Sabre\TravelItineraryRead\Structs\ProductTextDetails $productTextDetails = null, CommonString $productText = null, CommonString $owningCarrierCode = null, CommonString $ssimCode = null, CommonString $bookingIndicator = null, CommonString $vendor = null, CommonString $eMDType = null, CommonString $eMDNumber = null, CommonString $eMDCoupon = null, \Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate $eTicketNumber = null, CommonString $serviceFeeLineNumber = null, $displayOnlyIndicator = null, CommonString $consumptionIndicator = null, CommonString $presentTo = null, CommonString $atCity = null, CommonString $endorsements = null, CommonString $stationIndicator = null, CommonString $serviceCity = null, CommonString $serviceCityDestination = null, ServiceType $serviceType = null, \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet = null, \Sabre\TravelItineraryRead\Structs\OriginalPrice $originalPrice = null, $newMiscIndicator = null, $quantity = null, SegmentID.Pricing $segmentNumber = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $equivalentPrice = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $tTLPrice = null, $portionOfTravelIndicator = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $originalBasePrice = null, CommonString $refundIndicator = null, CommonString $commisionIndicator = null, CommonString $interlineIndicator = null, CommonString $feeApplicationIndicator = null, $passengerTypeCode = null, $boardPoint = null, $offPoint = null, $taxesIncluded = null, \Sabre\TravelItineraryRead\Structs\Taxes $taxes = null, $softMatchIndicator = null, $noChargeNotAvailIndicator = null, \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $ticketCouponNumberAssociation = null, $simultaneousTicketIndicator = null, $formOfRefund = null, $feeNotGuaranteedIndicator = null, $fQTVTierLevel = null, CommonString $tourCodeSHC = null, CommonString $travelDateEffective = null, CommonString $latestTravelDatePermitted = null, $purchaseByDate = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalOriginalBasePrice = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalEquivalentPrice = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalTTLPrice = null, \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes = null, CommonString $taxExemptIndicator = null, \Sabre\TravelItineraryRead\Structs\BagWeight $bagWeight = null, $statusIndicator = null, CommonString $numberOfItems = null, $actionCode = null, CommonString $segmentIndicator = null, CommonString $frequentFlyerTier = null, CommonString $refundFormIndicator = null, CommonString $fareGuaranteedIndicator = null, CommonString $serviceChargeIndicator = null, CommonString $advancePurchaseIndicator = null, CommonString $bookingSource = null, CommonString $taxIndicator = null, CommonString $ticketingIndicator = null, CommonString $feeWaiveReason = null, CommonString $fulfillmentType = null, CommonString $aaPayOriginalSeat = null, CommonString $pdcSeat = null, CommonString $equipmentType = null, $aaPayOptionalStatus = null, $firstTravelDate = null, $lastTravelDate = null, $tTYConfirmationTimestamp = null, $purchaseTimestamp = null, CommonString $brandedFareId = null, CommonString $groupCode = null, CommonString $tourCode = null, CommonString $emdPaperIndicator = null, $seatRequestTransactionID = null, CommonString $ticketUsedForEMDPricing = null, OptionalIndicator $paperDocRequired = null, OptionalIndicator $eMDConsummedAtIssuance = null, Indicator $taxExemption = null, $priceQuoteDesignator = null, PriceMismatchAction $priceMismatchAction = null, CommonString $inventoryControlledIndicator = null, CommonString $inventoryConfirmationToken = null, $aCSCount = null, \Sabre\TravelItineraryRead\Structs\AncillaryPrice $netAmount = null, \Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData $ancillaryPriceQuoteData = null, \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $segment = null, \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions = null, UniqueIdentifier $id = null, OperationType $op = null, $elementId = null, array $segments = array())
    {
        $this
            ->setNameAssociationList($nameAssociationList)
            ->setSegmentAssociationList($segmentAssociationList)
            ->setCommercialName($commercialName)
            ->setRficCode($rficCode)
            ->setRficSubcode($rficSubcode)
            ->setSSRCode($sSRCode)
            ->setProductTextDetails($productTextDetails)
            ->setProductText($productText)
            ->setOwningCarrierCode($owningCarrierCode)
            ->setSsimCode($ssimCode)
            ->setBookingIndicator($bookingIndicator)
            ->setVendor($vendor)
            ->setEMDType($eMDType)
            ->setEMDNumber($eMDNumber)
            ->setEMDCoupon($eMDCoupon)
            ->setETicketNumber($eTicketNumber)
            ->setServiceFeeLineNumber($serviceFeeLineNumber)
            ->setDisplayOnlyIndicator($displayOnlyIndicator)
            ->setConsumptionIndicator($consumptionIndicator)
            ->setPresentTo($presentTo)
            ->setAtCity($atCity)
            ->setEndorsements($endorsements)
            ->setStationIndicator($stationIndicator)
            ->setServiceCity($serviceCity)
            ->setServiceCityDestination($serviceCityDestination)
            ->setServiceType($serviceType)
            ->setRuleSet($ruleSet)
            ->setOriginalPrice($originalPrice)
            ->setNewMiscIndicator($newMiscIndicator)
            ->setQuantity($quantity)
            ->setSegmentNumber($segmentNumber)
            ->setEquivalentPrice($equivalentPrice)
            ->setTTLPrice($tTLPrice)
            ->setPortionOfTravelIndicator($portionOfTravelIndicator)
            ->setOriginalBasePrice($originalBasePrice)
            ->setRefundIndicator($refundIndicator)
            ->setCommisionIndicator($commisionIndicator)
            ->setInterlineIndicator($interlineIndicator)
            ->setFeeApplicationIndicator($feeApplicationIndicator)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setBoardPoint($boardPoint)
            ->setOffPoint($offPoint)
            ->setTaxesIncluded($taxesIncluded)
            ->setTaxes($taxes)
            ->setSoftMatchIndicator($softMatchIndicator)
            ->setNoChargeNotAvailIndicator($noChargeNotAvailIndicator)
            ->setTicketCouponNumberAssociation($ticketCouponNumberAssociation)
            ->setSimultaneousTicketIndicator($simultaneousTicketIndicator)
            ->setFormOfRefund($formOfRefund)
            ->setFeeNotGuaranteedIndicator($feeNotGuaranteedIndicator)
            ->setFQTVTierLevel($fQTVTierLevel)
            ->setTourCodeSHC($tourCodeSHC)
            ->setTravelDateEffective($travelDateEffective)
            ->setLatestTravelDatePermitted($latestTravelDatePermitted)
            ->setPurchaseByDate($purchaseByDate)
            ->setTotalOriginalBasePrice($totalOriginalBasePrice)
            ->setTotalEquivalentPrice($totalEquivalentPrice)
            ->setTotalTTLPrice($totalTTLPrice)
            ->setTotalTaxes($totalTaxes)
            ->setTaxExemptIndicator($taxExemptIndicator)
            ->setBagWeight($bagWeight)
            ->setStatusIndicator($statusIndicator)
            ->setNumberOfItems($numberOfItems)
            ->setActionCode($actionCode)
            ->setSegmentIndicator($segmentIndicator)
            ->setFrequentFlyerTier($frequentFlyerTier)
            ->setRefundFormIndicator($refundFormIndicator)
            ->setFareGuaranteedIndicator($fareGuaranteedIndicator)
            ->setServiceChargeIndicator($serviceChargeIndicator)
            ->setAdvancePurchaseIndicator($advancePurchaseIndicator)
            ->setBookingSource($bookingSource)
            ->setTaxIndicator($taxIndicator)
            ->setTicketingIndicator($ticketingIndicator)
            ->setFeeWaiveReason($feeWaiveReason)
            ->setFulfillmentType($fulfillmentType)
            ->setAaPayOriginalSeat($aaPayOriginalSeat)
            ->setPdcSeat($pdcSeat)
            ->setEquipmentType($equipmentType)
            ->setAaPayOptionalStatus($aaPayOptionalStatus)
            ->setFirstTravelDate($firstTravelDate)
            ->setLastTravelDate($lastTravelDate)
            ->setTTYConfirmationTimestamp($tTYConfirmationTimestamp)
            ->setPurchaseTimestamp($purchaseTimestamp)
            ->setBrandedFareId($brandedFareId)
            ->setGroupCode($groupCode)
            ->setTourCode($tourCode)
            ->setEmdPaperIndicator($emdPaperIndicator)
            ->setSeatRequestTransactionID($seatRequestTransactionID)
            ->setTicketUsedForEMDPricing($ticketUsedForEMDPricing)
            ->setPaperDocRequired($paperDocRequired)
            ->setEMDConsummedAtIssuance($eMDConsummedAtIssuance)
            ->setTaxExemption($taxExemption)
            ->setPriceQuoteDesignator($priceQuoteDesignator)
            ->setPriceMismatchAction($priceMismatchAction)
            ->setInventoryControlledIndicator($inventoryControlledIndicator)
            ->setInventoryConfirmationToken($inventoryConfirmationToken)
            ->setACSCount($aCSCount)
            ->setNetAmount($netAmount)
            ->setAncillaryPriceQuoteData($ancillaryPriceQuoteData)
            ->setSegment($segment)
            ->setTravelPortions($travelPortions)
            ->setId($id)
            ->setOp($op)
            ->setElementId($elementId)
            ->setSegments($segments);
    }
    /**
     * Get NameAssociationList value
     * @return \Sabre\TravelItineraryRead\Structs\NameAssociationList|null
     */
    public function getNameAssociationList()
    {
        return $this->NameAssociationList;
    }
    /**
     * Set NameAssociationList value
     * @param \Sabre\TravelItineraryRead\Structs\NameAssociationList $nameAssociationList
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setNameAssociationList(\Sabre\TravelItineraryRead\Structs\NameAssociationList $nameAssociationList = null)
    {
        $this->NameAssociationList = $nameAssociationList;
        return $this;
    }
    /**
     * Get SegmentAssociationList value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentAssociationList|null
     */
    public function getSegmentAssociationList()
    {
        return $this->SegmentAssociationList;
    }
    /**
     * Set SegmentAssociationList value
     * @param \Sabre\TravelItineraryRead\Structs\SegmentAssociationList $segmentAssociationList
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSegmentAssociationList(\Sabre\TravelItineraryRead\Structs\SegmentAssociationList $segmentAssociationList = null)
    {
        $this->SegmentAssociationList = $segmentAssociationList;
        return $this;
    }
    /**
     * Get CommercialName value
     * @return CommonString|null
     */
    public function getCommercialName()
    {
        return $this->CommercialName;
    }
    /**
     * Set CommercialName value
     * @param CommonString $commercialName
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setCommercialName(CommonString $commercialName = null)
    {
        $this->CommercialName = $commercialName;
        return $this;
    }
    /**
     * Get RficCode value
     * @return CommonString|null
     */
    public function getRficCode()
    {
        return $this->RficCode;
    }
    /**
     * Set RficCode value
     * @param CommonString $rficCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setRficCode(CommonString $rficCode = null)
    {
        $this->RficCode = $rficCode;
        return $this;
    }
    /**
     * Get RficSubcode value
     * @return string|null
     */
    public function getRficSubcode()
    {
        return $this->RficSubcode;
    }
    /**
     * Set RficSubcode value
     * @param string $rficSubcode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setRficSubcode($rficSubcode = null)
    {
        $this->RficSubcode = $rficSubcode;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return CommonString|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param CommonString $sSRCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSSRCode(CommonString $sSRCode = null)
    {
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get ProductTextDetails value
     * @return \Sabre\TravelItineraryRead\Structs\ProductTextDetails|null
     */
    public function getProductTextDetails()
    {
        return $this->ProductTextDetails;
    }
    /**
     * Set ProductTextDetails value
     * @param \Sabre\TravelItineraryRead\Structs\ProductTextDetails $productTextDetails
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setProductTextDetails(\Sabre\TravelItineraryRead\Structs\ProductTextDetails $productTextDetails = null)
    {
        $this->ProductTextDetails = $productTextDetails;
        return $this;
    }
    /**
     * Get ProductText value
     * @return CommonString|null
     */
    public function getProductText()
    {
        return $this->ProductText;
    }
    /**
     * Set ProductText value
     * @param CommonString $productText
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setProductText(CommonString $productText = null)
    {
        $this->ProductText = $productText;
        return $this;
    }
    /**
     * Get OwningCarrierCode value
     * @return CommonString|null
     */
    public function getOwningCarrierCode()
    {
        return $this->OwningCarrierCode;
    }
    /**
     * Set OwningCarrierCode value
     * @param CommonString $owningCarrierCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setOwningCarrierCode(CommonString $owningCarrierCode = null)
    {
        $this->OwningCarrierCode = $owningCarrierCode;
        return $this;
    }
    /**
     * Get SsimCode value
     * @return CommonString|null
     */
    public function getSsimCode()
    {
        return $this->SsimCode;
    }
    /**
     * Set SsimCode value
     * @param CommonString $ssimCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSsimCode(CommonString $ssimCode = null)
    {
        $this->SsimCode = $ssimCode;
        return $this;
    }
    /**
     * Get BookingIndicator value
     * @return CommonString|null
     */
    public function getBookingIndicator()
    {
        return $this->BookingIndicator;
    }
    /**
     * Set BookingIndicator value
     * @param CommonString $bookingIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setBookingIndicator(CommonString $bookingIndicator = null)
    {
        $this->BookingIndicator = $bookingIndicator;
        return $this;
    }
    /**
     * Get Vendor value
     * @return CommonString|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param CommonString $vendor
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setVendor(CommonString $vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get EMDType value
     * @return CommonString|null
     */
    public function getEMDType()
    {
        return $this->EMDType;
    }
    /**
     * Set EMDType value
     * @param CommonString $eMDType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEMDType(CommonString $eMDType = null)
    {
        $this->EMDType = $eMDType;
        return $this;
    }
    /**
     * Get EMDNumber value
     * @return CommonString|null
     */
    public function getEMDNumber()
    {
        return $this->EMDNumber;
    }
    /**
     * Set EMDNumber value
     * @param CommonString $eMDNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEMDNumber(CommonString $eMDNumber = null)
    {
        $this->EMDNumber = $eMDNumber;
        return $this;
    }
    /**
     * Get EMDCoupon value
     * @return CommonString|null
     */
    public function getEMDCoupon()
    {
        return $this->EMDCoupon;
    }
    /**
     * Set EMDCoupon value
     * @param CommonString $eMDCoupon
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEMDCoupon(CommonString $eMDCoupon = null)
    {
        $this->EMDCoupon = $eMDCoupon;
        return $this;
    }
    /**
     * Get ETicketNumber value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate|null
     */
    public function getETicketNumber()
    {
        return $this->ETicketNumber;
    }
    /**
     * Set ETicketNumber value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate $eTicketNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setETicketNumber(\Sabre\TravelItineraryRead\Structs\AncillaryServiceETicketNumberUpdate $eTicketNumber = null)
    {
        $this->ETicketNumber = $eTicketNumber;
        return $this;
    }
    /**
     * Get ServiceFeeLineNumber value
     * @return CommonString|null
     */
    public function getServiceFeeLineNumber()
    {
        return $this->ServiceFeeLineNumber;
    }
    /**
     * Set ServiceFeeLineNumber value
     * @param CommonString $serviceFeeLineNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setServiceFeeLineNumber(CommonString $serviceFeeLineNumber = null)
    {
        $this->ServiceFeeLineNumber = $serviceFeeLineNumber;
        return $this;
    }
    /**
     * Get DisplayOnlyIndicator value
     * @return bool|null
     */
    public function getDisplayOnlyIndicator()
    {
        return $this->DisplayOnlyIndicator;
    }
    /**
     * Set DisplayOnlyIndicator value
     * @param bool $displayOnlyIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setDisplayOnlyIndicator($displayOnlyIndicator = null)
    {
        $this->DisplayOnlyIndicator = $displayOnlyIndicator;
        return $this;
    }
    /**
     * Get ConsumptionIndicator value
     * @return CommonString|null
     */
    public function getConsumptionIndicator()
    {
        return $this->ConsumptionIndicator;
    }
    /**
     * Set ConsumptionIndicator value
     * @param CommonString $consumptionIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setConsumptionIndicator(CommonString $consumptionIndicator = null)
    {
        $this->ConsumptionIndicator = $consumptionIndicator;
        return $this;
    }
    /**
     * Get PresentTo value
     * @return CommonString|null
     */
    public function getPresentTo()
    {
        return $this->PresentTo;
    }
    /**
     * Set PresentTo value
     * @param CommonString $presentTo
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPresentTo(CommonString $presentTo = null)
    {
        $this->PresentTo = $presentTo;
        return $this;
    }
    /**
     * Get AtCity value
     * @return CommonString|null
     */
    public function getAtCity()
    {
        return $this->AtCity;
    }
    /**
     * Set AtCity value
     * @param CommonString $atCity
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setAtCity(CommonString $atCity = null)
    {
        $this->AtCity = $atCity;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return CommonString|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param CommonString $endorsements
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEndorsements(CommonString $endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get StationIndicator value
     * @return CommonString|null
     */
    public function getStationIndicator()
    {
        return $this->StationIndicator;
    }
    /**
     * Set StationIndicator value
     * @param CommonString $stationIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setStationIndicator(CommonString $stationIndicator = null)
    {
        $this->StationIndicator = $stationIndicator;
        return $this;
    }
    /**
     * Get ServiceCity value
     * @return CommonString|null
     */
    public function getServiceCity()
    {
        return $this->ServiceCity;
    }
    /**
     * Set ServiceCity value
     * @param CommonString $serviceCity
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setServiceCity(CommonString $serviceCity = null)
    {
        $this->ServiceCity = $serviceCity;
        return $this;
    }
    /**
     * Get ServiceCityDestination value
     * @return CommonString|null
     */
    public function getServiceCityDestination()
    {
        return $this->ServiceCityDestination;
    }
    /**
     * Set ServiceCityDestination value
     * @param CommonString $serviceCityDestination
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setServiceCityDestination(CommonString $serviceCityDestination = null)
    {
        $this->ServiceCityDestination = $serviceCityDestination;
        return $this;
    }
    /**
     * Get ServiceType value
     * @return ServiceType|null
     */
    public function getServiceType()
    {
        return $this->ServiceType;
    }
    /**
     * Set ServiceType value
     * @param ServiceType $serviceType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setServiceType(ServiceType $serviceType = null)
    {
        $this->ServiceType = $serviceType;
        return $this;
    }
    /**
     * Get RuleSet value
     * @return \Sabre\TravelItineraryRead\Structs\RuleSet|null
     */
    public function getRuleSet()
    {
        return $this->RuleSet;
    }
    /**
     * Set RuleSet value
     * @param \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setRuleSet(\Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet = null)
    {
        $this->RuleSet = $ruleSet;
        return $this;
    }
    /**
     * Get OriginalPrice value
     * @return \Sabre\TravelItineraryRead\Structs\OriginalPrice|null
     */
    public function getOriginalPrice()
    {
        return $this->OriginalPrice;
    }
    /**
     * Set OriginalPrice value
     * @param \Sabre\TravelItineraryRead\Structs\OriginalPrice $originalPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setOriginalPrice(\Sabre\TravelItineraryRead\Structs\OriginalPrice $originalPrice = null)
    {
        $this->OriginalPrice = $originalPrice;
        return $this;
    }
    /**
     * Get NewMiscIndicator value
     * @return string|null
     */
    public function getNewMiscIndicator()
    {
        return $this->NewMiscIndicator;
    }
    /**
     * Set NewMiscIndicator value
     * @param string $newMiscIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setNewMiscIndicator($newMiscIndicator = null)
    {
        $this->NewMiscIndicator = $newMiscIndicator;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setQuantity($quantity = null)
    {
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return SegmentID.Pricing|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param SegmentID.Pricing $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSegmentNumber(SegmentID.Pricing $segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get EquivalentPrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getEquivalentPrice()
    {
        return $this->EquivalentPrice;
    }
    /**
     * Set EquivalentPrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $equivalentPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEquivalentPrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $equivalentPrice = null)
    {
        $this->EquivalentPrice = $equivalentPrice;
        return $this;
    }
    /**
     * Get TTLPrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getTTLPrice()
    {
        return $this->TTLPrice;
    }
    /**
     * Set TTLPrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $tTLPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTTLPrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $tTLPrice = null)
    {
        $this->TTLPrice = $tTLPrice;
        return $this;
    }
    /**
     * Get PortionOfTravelIndicator value
     * @return string|null
     */
    public function getPortionOfTravelIndicator()
    {
        return $this->PortionOfTravelIndicator;
    }
    /**
     * Set PortionOfTravelIndicator value
     * @param string $portionOfTravelIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPortionOfTravelIndicator($portionOfTravelIndicator = null)
    {
        $this->PortionOfTravelIndicator = $portionOfTravelIndicator;
        return $this;
    }
    /**
     * Get OriginalBasePrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getOriginalBasePrice()
    {
        return $this->OriginalBasePrice;
    }
    /**
     * Set OriginalBasePrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $originalBasePrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setOriginalBasePrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $originalBasePrice = null)
    {
        $this->OriginalBasePrice = $originalBasePrice;
        return $this;
    }
    /**
     * Get RefundIndicator value
     * @return CommonString|null
     */
    public function getRefundIndicator()
    {
        return $this->RefundIndicator;
    }
    /**
     * Set RefundIndicator value
     * @param CommonString $refundIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setRefundIndicator(CommonString $refundIndicator = null)
    {
        $this->RefundIndicator = $refundIndicator;
        return $this;
    }
    /**
     * Get CommisionIndicator value
     * @return CommonString|null
     */
    public function getCommisionIndicator()
    {
        return $this->CommisionIndicator;
    }
    /**
     * Set CommisionIndicator value
     * @param CommonString $commisionIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setCommisionIndicator(CommonString $commisionIndicator = null)
    {
        $this->CommisionIndicator = $commisionIndicator;
        return $this;
    }
    /**
     * Get InterlineIndicator value
     * @return CommonString|null
     */
    public function getInterlineIndicator()
    {
        return $this->InterlineIndicator;
    }
    /**
     * Set InterlineIndicator value
     * @param CommonString $interlineIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setInterlineIndicator(CommonString $interlineIndicator = null)
    {
        $this->InterlineIndicator = $interlineIndicator;
        return $this;
    }
    /**
     * Get FeeApplicationIndicator value
     * @return CommonString|null
     */
    public function getFeeApplicationIndicator()
    {
        return $this->FeeApplicationIndicator;
    }
    /**
     * Set FeeApplicationIndicator value
     * @param CommonString $feeApplicationIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFeeApplicationIndicator(CommonString $feeApplicationIndicator = null)
    {
        $this->FeeApplicationIndicator = $feeApplicationIndicator;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get BoardPoint value
     * @return string|null
     */
    public function getBoardPoint()
    {
        return $this->BoardPoint;
    }
    /**
     * Set BoardPoint value
     * @param string $boardPoint
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setBoardPoint($boardPoint = null)
    {
        $this->BoardPoint = $boardPoint;
        return $this;
    }
    /**
     * Get OffPoint value
     * @return string|null
     */
    public function getOffPoint()
    {
        return $this->OffPoint;
    }
    /**
     * Set OffPoint value
     * @param string $offPoint
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setOffPoint($offPoint = null)
    {
        $this->OffPoint = $offPoint;
        return $this;
    }
    /**
     * Get TaxesIncluded value
     * @return bool|null
     */
    public function getTaxesIncluded()
    {
        return $this->TaxesIncluded;
    }
    /**
     * Set TaxesIncluded value
     * @param bool $taxesIncluded
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTaxesIncluded($taxesIncluded = null)
    {
        $this->TaxesIncluded = $taxesIncluded;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\TravelItineraryRead\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTaxes(\Sabre\TravelItineraryRead\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get SoftMatchIndicator value
     * @return bool|null
     */
    public function getSoftMatchIndicator()
    {
        return $this->SoftMatchIndicator;
    }
    /**
     * Set SoftMatchIndicator value
     * @param bool $softMatchIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSoftMatchIndicator($softMatchIndicator = null)
    {
        $this->SoftMatchIndicator = $softMatchIndicator;
        return $this;
    }
    /**
     * Get NoChargeNotAvailIndicator value
     * @return string|null
     */
    public function getNoChargeNotAvailIndicator()
    {
        return $this->NoChargeNotAvailIndicator;
    }
    /**
     * Set NoChargeNotAvailIndicator value
     * @param string $noChargeNotAvailIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setNoChargeNotAvailIndicator($noChargeNotAvailIndicator = null)
    {
        $this->NoChargeNotAvailIndicator = $noChargeNotAvailIndicator;
        return $this;
    }
    /**
     * Get TicketCouponNumberAssociation value
     * @return \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation|null
     */
    public function getTicketCouponNumberAssociation()
    {
        return $this->TicketCouponNumberAssociation;
    }
    /**
     * Set TicketCouponNumberAssociation value
     * @param \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $ticketCouponNumberAssociation
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTicketCouponNumberAssociation(\Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $ticketCouponNumberAssociation = null)
    {
        $this->TicketCouponNumberAssociation = $ticketCouponNumberAssociation;
        return $this;
    }
    /**
     * Get SimultaneousTicketIndicator value
     * @return string|null
     */
    public function getSimultaneousTicketIndicator()
    {
        return $this->SimultaneousTicketIndicator;
    }
    /**
     * Set SimultaneousTicketIndicator value
     * @param string $simultaneousTicketIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSimultaneousTicketIndicator($simultaneousTicketIndicator = null)
    {
        $this->SimultaneousTicketIndicator = $simultaneousTicketIndicator;
        return $this;
    }
    /**
     * Get FormOfRefund value
     * @return string|null
     */
    public function getFormOfRefund()
    {
        return $this->FormOfRefund;
    }
    /**
     * Set FormOfRefund value
     * @param string $formOfRefund
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFormOfRefund($formOfRefund = null)
    {
        $this->FormOfRefund = $formOfRefund;
        return $this;
    }
    /**
     * Get FeeNotGuaranteedIndicator value
     * @return bool|null
     */
    public function getFeeNotGuaranteedIndicator()
    {
        return $this->FeeNotGuaranteedIndicator;
    }
    /**
     * Set FeeNotGuaranteedIndicator value
     * @param bool $feeNotGuaranteedIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFeeNotGuaranteedIndicator($feeNotGuaranteedIndicator = null)
    {
        $this->FeeNotGuaranteedIndicator = $feeNotGuaranteedIndicator;
        return $this;
    }
    /**
     * Get FQTVTierLevel value
     * @return int|null
     */
    public function getFQTVTierLevel()
    {
        return $this->FQTVTierLevel;
    }
    /**
     * Set FQTVTierLevel value
     * @param int $fQTVTierLevel
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFQTVTierLevel($fQTVTierLevel = null)
    {
        $this->FQTVTierLevel = $fQTVTierLevel;
        return $this;
    }
    /**
     * Get TourCodeSHC value
     * @return CommonString|null
     */
    public function getTourCodeSHC()
    {
        return $this->TourCodeSHC;
    }
    /**
     * Set TourCodeSHC value
     * @param CommonString $tourCodeSHC
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTourCodeSHC(CommonString $tourCodeSHC = null)
    {
        $this->TourCodeSHC = $tourCodeSHC;
        return $this;
    }
    /**
     * Get TravelDateEffective value
     * @return CommonString|null
     */
    public function getTravelDateEffective()
    {
        return $this->TravelDateEffective;
    }
    /**
     * Set TravelDateEffective value
     * @param CommonString $travelDateEffective
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTravelDateEffective(CommonString $travelDateEffective = null)
    {
        $this->TravelDateEffective = $travelDateEffective;
        return $this;
    }
    /**
     * Get LatestTravelDatePermitted value
     * @return CommonString|null
     */
    public function getLatestTravelDatePermitted()
    {
        return $this->LatestTravelDatePermitted;
    }
    /**
     * Set LatestTravelDatePermitted value
     * @param CommonString $latestTravelDatePermitted
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setLatestTravelDatePermitted(CommonString $latestTravelDatePermitted = null)
    {
        $this->LatestTravelDatePermitted = $latestTravelDatePermitted;
        return $this;
    }
    /**
     * Get PurchaseByDate value
     * @return string|null
     */
    public function getPurchaseByDate()
    {
        return $this->PurchaseByDate;
    }
    /**
     * Set PurchaseByDate value
     * @param string $purchaseByDate
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPurchaseByDate($purchaseByDate = null)
    {
        $this->PurchaseByDate = $purchaseByDate;
        return $this;
    }
    /**
     * Get TotalOriginalBasePrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getTotalOriginalBasePrice()
    {
        return $this->TotalOriginalBasePrice;
    }
    /**
     * Set TotalOriginalBasePrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalOriginalBasePrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTotalOriginalBasePrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalOriginalBasePrice = null)
    {
        $this->TotalOriginalBasePrice = $totalOriginalBasePrice;
        return $this;
    }
    /**
     * Get TotalEquivalentPrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getTotalEquivalentPrice()
    {
        return $this->TotalEquivalentPrice;
    }
    /**
     * Set TotalEquivalentPrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalEquivalentPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTotalEquivalentPrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalEquivalentPrice = null)
    {
        $this->TotalEquivalentPrice = $totalEquivalentPrice;
        return $this;
    }
    /**
     * Get TotalTTLPrice value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getTotalTTLPrice()
    {
        return $this->TotalTTLPrice;
    }
    /**
     * Set TotalTTLPrice value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalTTLPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTotalTTLPrice(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $totalTTLPrice = null)
    {
        $this->TotalTTLPrice = $totalTTLPrice;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return \Sabre\TravelItineraryRead\Structs\TotalTaxes|null
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTotalTaxes(\Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get TaxExemptIndicator value
     * @return CommonString|null
     */
    public function getTaxExemptIndicator()
    {
        return $this->TaxExemptIndicator;
    }
    /**
     * Set TaxExemptIndicator value
     * @param CommonString $taxExemptIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTaxExemptIndicator(CommonString $taxExemptIndicator = null)
    {
        $this->TaxExemptIndicator = $taxExemptIndicator;
        return $this;
    }
    /**
     * Get BagWeight value
     * @return \Sabre\TravelItineraryRead\Structs\BagWeight|null
     */
    public function getBagWeight()
    {
        return $this->BagWeight;
    }
    /**
     * Set BagWeight value
     * @param \Sabre\TravelItineraryRead\Structs\BagWeight $bagWeight
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setBagWeight(\Sabre\TravelItineraryRead\Structs\BagWeight $bagWeight = null)
    {
        $this->BagWeight = $bagWeight;
        return $this;
    }
    /**
     * Get StatusIndicator value
     * @return int|null
     */
    public function getStatusIndicator()
    {
        return $this->StatusIndicator;
    }
    /**
     * Set StatusIndicator value
     * @param int $statusIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setStatusIndicator($statusIndicator = null)
    {
        $this->StatusIndicator = $statusIndicator;
        return $this;
    }
    /**
     * Get NumberOfItems value
     * @return CommonString|null
     */
    public function getNumberOfItems()
    {
        return $this->NumberOfItems;
    }
    /**
     * Set NumberOfItems value
     * @param CommonString $numberOfItems
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setNumberOfItems(CommonString $numberOfItems = null)
    {
        $this->NumberOfItems = $numberOfItems;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get SegmentIndicator value
     * @return CommonString|null
     */
    public function getSegmentIndicator()
    {
        return $this->SegmentIndicator;
    }
    /**
     * Set SegmentIndicator value
     * @param CommonString $segmentIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSegmentIndicator(CommonString $segmentIndicator = null)
    {
        $this->SegmentIndicator = $segmentIndicator;
        return $this;
    }
    /**
     * Get FrequentFlyerTier value
     * @return CommonString|null
     */
    public function getFrequentFlyerTier()
    {
        return $this->FrequentFlyerTier;
    }
    /**
     * Set FrequentFlyerTier value
     * @param CommonString $frequentFlyerTier
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFrequentFlyerTier(CommonString $frequentFlyerTier = null)
    {
        $this->FrequentFlyerTier = $frequentFlyerTier;
        return $this;
    }
    /**
     * Get RefundFormIndicator value
     * @return CommonString|null
     */
    public function getRefundFormIndicator()
    {
        return $this->RefundFormIndicator;
    }
    /**
     * Set RefundFormIndicator value
     * @param CommonString $refundFormIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setRefundFormIndicator(CommonString $refundFormIndicator = null)
    {
        $this->RefundFormIndicator = $refundFormIndicator;
        return $this;
    }
    /**
     * Get FareGuaranteedIndicator value
     * @return CommonString|null
     */
    public function getFareGuaranteedIndicator()
    {
        return $this->FareGuaranteedIndicator;
    }
    /**
     * Set FareGuaranteedIndicator value
     * @param CommonString $fareGuaranteedIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFareGuaranteedIndicator(CommonString $fareGuaranteedIndicator = null)
    {
        $this->FareGuaranteedIndicator = $fareGuaranteedIndicator;
        return $this;
    }
    /**
     * Get ServiceChargeIndicator value
     * @return CommonString|null
     */
    public function getServiceChargeIndicator()
    {
        return $this->ServiceChargeIndicator;
    }
    /**
     * Set ServiceChargeIndicator value
     * @param CommonString $serviceChargeIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setServiceChargeIndicator(CommonString $serviceChargeIndicator = null)
    {
        $this->ServiceChargeIndicator = $serviceChargeIndicator;
        return $this;
    }
    /**
     * Get AdvancePurchaseIndicator value
     * @return CommonString|null
     */
    public function getAdvancePurchaseIndicator()
    {
        return $this->AdvancePurchaseIndicator;
    }
    /**
     * Set AdvancePurchaseIndicator value
     * @param CommonString $advancePurchaseIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setAdvancePurchaseIndicator(CommonString $advancePurchaseIndicator = null)
    {
        $this->AdvancePurchaseIndicator = $advancePurchaseIndicator;
        return $this;
    }
    /**
     * Get BookingSource value
     * @return CommonString|null
     */
    public function getBookingSource()
    {
        return $this->BookingSource;
    }
    /**
     * Set BookingSource value
     * @param CommonString $bookingSource
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setBookingSource(CommonString $bookingSource = null)
    {
        $this->BookingSource = $bookingSource;
        return $this;
    }
    /**
     * Get TaxIndicator value
     * @return CommonString|null
     */
    public function getTaxIndicator()
    {
        return $this->TaxIndicator;
    }
    /**
     * Set TaxIndicator value
     * @param CommonString $taxIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTaxIndicator(CommonString $taxIndicator = null)
    {
        $this->TaxIndicator = $taxIndicator;
        return $this;
    }
    /**
     * Get TicketingIndicator value
     * @return CommonString|null
     */
    public function getTicketingIndicator()
    {
        return $this->TicketingIndicator;
    }
    /**
     * Set TicketingIndicator value
     * @param CommonString $ticketingIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTicketingIndicator(CommonString $ticketingIndicator = null)
    {
        $this->TicketingIndicator = $ticketingIndicator;
        return $this;
    }
    /**
     * Get FeeWaiveReason value
     * @return CommonString|null
     */
    public function getFeeWaiveReason()
    {
        return $this->FeeWaiveReason;
    }
    /**
     * Set FeeWaiveReason value
     * @param CommonString $feeWaiveReason
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFeeWaiveReason(CommonString $feeWaiveReason = null)
    {
        $this->FeeWaiveReason = $feeWaiveReason;
        return $this;
    }
    /**
     * Get FulfillmentType value
     * @return CommonString|null
     */
    public function getFulfillmentType()
    {
        return $this->FulfillmentType;
    }
    /**
     * Set FulfillmentType value
     * @param CommonString $fulfillmentType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFulfillmentType(CommonString $fulfillmentType = null)
    {
        $this->FulfillmentType = $fulfillmentType;
        return $this;
    }
    /**
     * Get AaPayOriginalSeat value
     * @return CommonString|null
     */
    public function getAaPayOriginalSeat()
    {
        return $this->AaPayOriginalSeat;
    }
    /**
     * Set AaPayOriginalSeat value
     * @param CommonString $aaPayOriginalSeat
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setAaPayOriginalSeat(CommonString $aaPayOriginalSeat = null)
    {
        $this->AaPayOriginalSeat = $aaPayOriginalSeat;
        return $this;
    }
    /**
     * Get PdcSeat value
     * @return CommonString|null
     */
    public function getPdcSeat()
    {
        return $this->PdcSeat;
    }
    /**
     * Set PdcSeat value
     * @param CommonString $pdcSeat
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPdcSeat(CommonString $pdcSeat = null)
    {
        $this->PdcSeat = $pdcSeat;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return CommonString|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param CommonString $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEquipmentType(CommonString $equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get AaPayOptionalStatus value
     * @return string|null
     */
    public function getAaPayOptionalStatus()
    {
        return $this->AaPayOptionalStatus;
    }
    /**
     * Set AaPayOptionalStatus value
     * @param string $aaPayOptionalStatus
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setAaPayOptionalStatus($aaPayOptionalStatus = null)
    {
        $this->AaPayOptionalStatus = $aaPayOptionalStatus;
        return $this;
    }
    /**
     * Get FirstTravelDate value
     * @return string|null
     */
    public function getFirstTravelDate()
    {
        return $this->FirstTravelDate;
    }
    /**
     * Set FirstTravelDate value
     * @param string $firstTravelDate
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setFirstTravelDate($firstTravelDate = null)
    {
        $this->FirstTravelDate = $firstTravelDate;
        return $this;
    }
    /**
     * Get LastTravelDate value
     * @return string|null
     */
    public function getLastTravelDate()
    {
        return $this->LastTravelDate;
    }
    /**
     * Set LastTravelDate value
     * @param string $lastTravelDate
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setLastTravelDate($lastTravelDate = null)
    {
        $this->LastTravelDate = $lastTravelDate;
        return $this;
    }
    /**
     * Get TTYConfirmationTimestamp value
     * @return string|null
     */
    public function getTTYConfirmationTimestamp()
    {
        return $this->TTYConfirmationTimestamp;
    }
    /**
     * Set TTYConfirmationTimestamp value
     * @param string $tTYConfirmationTimestamp
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTTYConfirmationTimestamp($tTYConfirmationTimestamp = null)
    {
        $this->TTYConfirmationTimestamp = $tTYConfirmationTimestamp;
        return $this;
    }
    /**
     * Get PurchaseTimestamp value
     * @return string|null
     */
    public function getPurchaseTimestamp()
    {
        return $this->PurchaseTimestamp;
    }
    /**
     * Set PurchaseTimestamp value
     * @param string $purchaseTimestamp
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPurchaseTimestamp($purchaseTimestamp = null)
    {
        $this->PurchaseTimestamp = $purchaseTimestamp;
        return $this;
    }
    /**
     * Get BrandedFareId value
     * @return CommonString|null
     */
    public function getBrandedFareId()
    {
        return $this->BrandedFareId;
    }
    /**
     * Set BrandedFareId value
     * @param CommonString $brandedFareId
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setBrandedFareId(CommonString $brandedFareId = null)
    {
        $this->BrandedFareId = $brandedFareId;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return CommonString|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param CommonString $groupCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setGroupCode(CommonString $groupCode = null)
    {
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return CommonString|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param CommonString $tourCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTourCode(CommonString $tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get EmdPaperIndicator value
     * @return CommonString|null
     */
    public function getEmdPaperIndicator()
    {
        return $this->EmdPaperIndicator;
    }
    /**
     * Set EmdPaperIndicator value
     * @param CommonString $emdPaperIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEmdPaperIndicator(CommonString $emdPaperIndicator = null)
    {
        $this->EmdPaperIndicator = $emdPaperIndicator;
        return $this;
    }
    /**
     * Get SeatRequestTransactionID value
     * @return string|null
     */
    public function getSeatRequestTransactionID()
    {
        return $this->SeatRequestTransactionID;
    }
    /**
     * Set SeatRequestTransactionID value
     * @param string $seatRequestTransactionID
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSeatRequestTransactionID($seatRequestTransactionID = null)
    {
        $this->SeatRequestTransactionID = $seatRequestTransactionID;
        return $this;
    }
    /**
     * Get TicketUsedForEMDPricing value
     * @return CommonString|null
     */
    public function getTicketUsedForEMDPricing()
    {
        return $this->TicketUsedForEMDPricing;
    }
    /**
     * Set TicketUsedForEMDPricing value
     * @param CommonString $ticketUsedForEMDPricing
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTicketUsedForEMDPricing(CommonString $ticketUsedForEMDPricing = null)
    {
        $this->TicketUsedForEMDPricing = $ticketUsedForEMDPricing;
        return $this;
    }
    /**
     * Get PaperDocRequired value
     * @return OptionalIndicator|null
     */
    public function getPaperDocRequired()
    {
        return $this->PaperDocRequired;
    }
    /**
     * Set PaperDocRequired value
     * @param OptionalIndicator $paperDocRequired
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPaperDocRequired(OptionalIndicator $paperDocRequired = null)
    {
        $this->PaperDocRequired = $paperDocRequired;
        return $this;
    }
    /**
     * Get EMDConsummedAtIssuance value
     * @return OptionalIndicator|null
     */
    public function getEMDConsummedAtIssuance()
    {
        return $this->EMDConsummedAtIssuance;
    }
    /**
     * Set EMDConsummedAtIssuance value
     * @param OptionalIndicator $eMDConsummedAtIssuance
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setEMDConsummedAtIssuance(OptionalIndicator $eMDConsummedAtIssuance = null)
    {
        $this->EMDConsummedAtIssuance = $eMDConsummedAtIssuance;
        return $this;
    }
    /**
     * Get TaxExemption value
     * @return Indicator|null
     */
    public function getTaxExemption()
    {
        return $this->TaxExemption;
    }
    /**
     * Set TaxExemption value
     * @param Indicator $taxExemption
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTaxExemption(Indicator $taxExemption = null)
    {
        $this->TaxExemption = $taxExemption;
        return $this;
    }
    /**
     * Get PriceQuoteDesignator value
     * @return int|null
     */
    public function getPriceQuoteDesignator()
    {
        return $this->PriceQuoteDesignator;
    }
    /**
     * Set PriceQuoteDesignator value
     * @param int $priceQuoteDesignator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPriceQuoteDesignator($priceQuoteDesignator = null)
    {
        $this->PriceQuoteDesignator = $priceQuoteDesignator;
        return $this;
    }
    /**
     * Get PriceMismatchAction value
     * @return PriceMismatchAction|null
     */
    public function getPriceMismatchAction()
    {
        return $this->PriceMismatchAction;
    }
    /**
     * Set PriceMismatchAction value
     * @param PriceMismatchAction $priceMismatchAction
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setPriceMismatchAction(PriceMismatchAction $priceMismatchAction = null)
    {
        $this->PriceMismatchAction = $priceMismatchAction;
        return $this;
    }
    /**
     * Get InventoryControlledIndicator value
     * @return CommonString|null
     */
    public function getInventoryControlledIndicator()
    {
        return $this->InventoryControlledIndicator;
    }
    /**
     * Set InventoryControlledIndicator value
     * @param CommonString $inventoryControlledIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setInventoryControlledIndicator(CommonString $inventoryControlledIndicator = null)
    {
        $this->InventoryControlledIndicator = $inventoryControlledIndicator;
        return $this;
    }
    /**
     * Get InventoryConfirmationToken value
     * @return CommonString|null
     */
    public function getInventoryConfirmationToken()
    {
        return $this->InventoryConfirmationToken;
    }
    /**
     * Set InventoryConfirmationToken value
     * @param CommonString $inventoryConfirmationToken
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setInventoryConfirmationToken(CommonString $inventoryConfirmationToken = null)
    {
        $this->InventoryConfirmationToken = $inventoryConfirmationToken;
        return $this;
    }
    /**
     * Get ACSCount value
     * @return int|null
     */
    public function getACSCount()
    {
        return $this->ACSCount;
    }
    /**
     * Set ACSCount value
     * @param int $aCSCount
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setACSCount($aCSCount = null)
    {
        $this->ACSCount = $aCSCount;
        return $this;
    }
    /**
     * Get NetAmount value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPrice|null
     */
    public function getNetAmount()
    {
        return $this->NetAmount;
    }
    /**
     * Set NetAmount value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPrice $netAmount
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setNetAmount(\Sabre\TravelItineraryRead\Structs\AncillaryPrice $netAmount = null)
    {
        $this->NetAmount = $netAmount;
        return $this;
    }
    /**
     * Get AncillaryPriceQuoteData value
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData|null
     */
    public function getAncillaryPriceQuoteData()
    {
        return $this->AncillaryPriceQuoteData;
    }
    /**
     * Set AncillaryPriceQuoteData value
     * @param \Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData $ancillaryPriceQuoteData
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setAncillaryPriceQuoteData(\Sabre\TravelItineraryRead\Structs\AncillaryPriceQuoteData $ancillaryPriceQuoteData = null)
    {
        $this->AncillaryPriceQuoteData = $ancillaryPriceQuoteData;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $segment
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSegment(\Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get TravelPortions value
     * @return \Sabre\TravelItineraryRead\Structs\TravelPortions|null
     */
    public function getTravelPortions()
    {
        return $this->TravelPortions;
    }
    /**
     * Set TravelPortions value
     * @param \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setTravelPortions(\Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions = null)
    {
        $this->TravelPortions = $travelPortions;
        return $this;
    }
    /**
     * Get id value
     * @return UniqueIdentifier|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param UniqueIdentifier $id
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setId(UniqueIdentifier $id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get op value
     * @return OperationType|null
     */
    public function getOp()
    {
        return $this->op;
    }
    /**
     * Set op value
     * @param OperationType $op
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setOp(OperationType $op = null)
    {
        $this->op = $op;
        return $this;
    }
    /**
     * Get elementId value
     * @return string|null
     */
    public function getElementId()
    {
        return $this->elementId;
    }
    /**
     * Set elementId value
     * @param string $elementId
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setElementId($elementId = null)
    {
        $this->elementId = $elementId;
        return $this;
    }
    /**
     * Get Segments value
     * @return \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[]|null
     */
    public function getSegments()
    {
        return $this->Segments;
    }
    /**
     * Set Segments value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion[] $segments
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function setSegments(array $segments = array())
    {
        $this->Segments = $segments;
        return $this;
    }
    /**
     * Add item to Segments value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $item
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public function addToSegments(\Sabre\TravelItineraryRead\Structs\SegmentOrTravelPortion $item)
    {
        $this->Segments[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryServiceData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
