<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryService Structs
 * Meta informations extracted from the WSDL
 * - documentation: "AncillaryService" element is used as a container for information about particular ancillary service.
 * @subpackage Structs
 */
class AncillaryService extends AbstractStructBase
{
    /**
     * The ref
     * @var string
     */
    public $ref;
    /**
     * The CommercialName
     * Meta informations extracted from the WSDL
     * - documentation: "CommercialName" indicates the name of requested ancillary service.
     * @var string
     */
    public $CommercialName;
    /**
     * The RficCode
     * Meta informations extracted from the WSDL
     * - documentation: "RficCode" indicates the reason of issuing the EMD for the service associated to the "RficSubcode".
     * @var string
     */
    public $RficCode;
    /**
     * The RficSubcode
     * Meta informations extracted from the WSDL
     * - documentation: "RficSubcode" is used to identify the individual ancillary service.
     * @var string
     */
    public $RficSubcode;
    /**
     * The EMDNumber
     * Meta informations extracted from the WSDL
     * - documentation: "EMDNumber" returns the EMD Number issued for the service
     * - minOccurs: 0
     * @var string
     */
    public $EMDNumber;
    /**
     * The EMDCoupon
     * Meta informations extracted from the WSDL
     * - documentation: "EMDCoupon" is used to identify EMD coupon details for the service .
     * - minOccurs: 0
     * @var string
     */
    public $EMDCoupon;
    /**
     * The SSRCode
     * Meta informations extracted from the WSDL
     * - documentation: "SSRCode" is used to identify the defined SSR code applicable for the service.
     * - minOccurs: 0
     * @var string
     */
    public $SSRCode;
    /**
     * The ProductText
     * Meta informations extracted from the WSDL
     * - documentation: "ProductText" indicates addtional data for an ancillary.
     * - minOccurs: 0
     * @var string
     */
    public $ProductText;
    /**
     * The OwningCarrierCode
     * Meta informations extracted from the WSDL
     * - documentation: "OwningCarrierCode" indicates airline or ATPCO vendor code.
     * - minOccurs: 0
     * @var string
     */
    public $OwningCarrierCode;
    /**
     * The SsimCode
     * Meta informations extracted from the WSDL
     * - documentation: "SsimCode" indicates Standard Schedules Information Manual (SSIM) code
     * - minOccurs: 0
     * @var string
     */
    public $SsimCode;
    /**
     * The Vendor
     * Meta informations extracted from the WSDL
     * - documentation: "Vendor" indicates service provider like "VA" or "MMGR"(Merchandising manager).
     * @var string
     */
    public $Vendor;
    /**
     * The EMDType
     * Meta informations extracted from the WSDL
     * - documentation: "EMDType" indicates type of EMD for the service associated to the "Rfic Subcode".
     * @var string
     */
    public $EMDType;
    /**
     * The EquivalentPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\EquivalentPrice
     */
    public $EquivalentPrice;
    /**
     * The TTLPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TTLPrice
     */
    public $TTLPrice;
    /**
     * The PortionOfTravelIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "PortionOfTravelIndicator" Indicator for O and D / S - segment P - portion.
     * - minOccurs: 0
     * @var string
     */
    public $PortionOfTravelIndicator;
    /**
     * The OriginalBasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\OriginalBasePrice
     */
    public $OriginalBasePrice;
    /**
     * The PassengerTypeCode
     * Meta informations extracted from the WSDL
     * - documentation: "PassengerTypeCode" indicates indicates the type of passenger to whom the record applies like adult / child.
     * - minOccurs: 0
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The BoardPoint
     * Meta informations extracted from the WSDL
     * - documentation: "BoardPoint" indicates departure city.
     * - minOccurs: 0
     * @var string
     */
    public $BoardPoint;
    /**
     * The OffPoint
     * Meta informations extracted from the WSDL
     * - documentation: "OffPoint" indicates arrival city.
     * - minOccurs: 0
     * @var string
     */
    public $OffPoint;
    /**
     * The TaxesIncluded
     * Meta informations extracted from the WSDL
     * - documentation: "TaxesIncluded" indicates if service fee amounts are inclusive of applicable taxes.
     * - minOccurs: 0
     * @var bool
     */
    public $TaxesIncluded;
    /**
     * The Taxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Taxes
     */
    public $Taxes;
    /**
     * The TicketCouponNumberAssociation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 4
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation[]
     */
    public $TicketCouponNumberAssociation;
    /**
     * The TotalOriginalBasePrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice
     */
    public $TotalOriginalBasePrice;
    /**
     * The TotalEquivalentPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice
     */
    public $TotalEquivalentPrice;
    /**
     * The TotalTTLPrice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalTTLPrice
     */
    public $TotalTTLPrice;
    /**
     * The TotalTaxes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TotalTaxes
     */
    public $TotalTaxes;
    /**
     * The FrequentFlyerTier
     * Meta informations extracted from the WSDL
     * - documentation: "FrequentFlyerTier" indicates FQTV carrier filed tier level
     * - minOccurs: 0
     * @var string
     */
    public $FrequentFlyerTier;
    /**
     * The BookingSource
     * Meta informations extracted from the WSDL
     * - documentation: "BookingSource" indicates source of ancillary service request e.g. 01=TTY GDS,02=TTY OA,03=SSW,04=Kiosk,05/06=Interact, 07=Arline Direct Channel, 08=PRS.
     * - minOccurs: 0
     * @var string
     */
    public $BookingSource;
    /**
     * The FeeWaiveReason
     * Meta informations extracted from the WSDL
     * - documentation: "FeeWaiveReason" indicates Reason for fee waive/override.
     * - minOccurs: 0
     * @var string
     */
    public $FeeWaiveReason;
    /**
     * The FulfillmentType
     * Meta informations extracted from the WSDL
     * - documentation: "FulfillmentType" indicates SSR to be sent for fulfilment.
     * - minOccurs: 0
     * @var string
     */
    public $FulfillmentType;
    /**
     * The AaPayOriginalSeat
     * Meta informations extracted from the WSDL
     * - documentation: "AaPayOriginalSeat" indicates Support for AA Pay for seats - original seat assigned - will not be updated if seat is changed.
     * - minOccurs: 0
     * @var string
     */
    public $AaPayOriginalSeat;
    /**
     * The PdcSeat
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PdcSeat;
    /**
     * The EquipmentType
     * Meta informations extracted from the WSDL
     * - documentation: "EquipmetType" indicates aircraft type used for the flight as per IATA standard.
     * - minOccurs: 0
     * @var string
     */
    public $EquipmentType;
    /**
     * The AaPayOptionalStatus
     * Meta informations extracted from the WSDL
     * - documentation: "AaPayOptionalStatus" indicates Support for AA Pay for seats .
     * - minOccurs: 0
     * @var string
     */
    public $AaPayOptionalStatus;
    /**
     * The TTYConfirmationTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: "TTYConfirmationTimestamp" indicates Time stamp when AE teletype confirmation received from airline . | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats:
     * "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $TTYConfirmationTimestamp;
    /**
     * The PurchaseTimestamp
     * Meta informations extracted from the WSDL
     * - documentation: "PurchaseTimestamp" indicates Purchase by time stamp. | A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss",
     * "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - minOccurs: 0
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $PurchaseTimestamp;
    /**
     * The BrandedFareId
     * Meta informations extracted from the WSDL
     * - documentation: "BrandedFareId" indicates branded fare ID.
     * - minOccurs: 0
     * @var string
     */
    public $BrandedFareId;
    /**
     * The GroupCode
     * Meta informations extracted from the WSDL
     * - documentation: "GroupCode" indicates type of ancillary service as per IATA standard (2 letter code defined in ARIMP manual). Following codes can be displayed: BG(Baggage),GT(Ground transportation and non-air services),IE(In-flight
     * entertainment),LG(Lounge),MD(Medical) ML(Meal),PT(Pets),SA(Pre-reserved seat assignment,UN(Unaccompanied travel(escort))
     * @var string
     */
    public $GroupCode;
    /**
     * The TourCode
     * Meta informations extracted from the WSDL
     * - documentation: "TourCode" indicates the tour code used .
     * - minOccurs: 0
     * @var string
     */
    public $TourCode;
    /**
     * The TicketUsedForEMDPricing
     * Meta informations extracted from the WSDL
     * - documentation: "TicketUsedForEMDPricing" indicates Ticket used for EMD pricing.
     * - minOccurs: 0
     * @var string
     */
    public $TicketUsedForEMDPricing;
    /**
     * The EMDConsummedAtIssuance
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EMDConsummedAtIssuance;
    /**
     * The TaxExemption
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TaxExemption;
    /**
     * The PresentTo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PresentTo;
    /**
     * The AtCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AtCity;
    /**
     * The Endorsements
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Endorsements;
    /**
     * The StationIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $StationIndicator;
    /**
     * The ServiceCity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCity;
    /**
     * The ServiceCityDestination
     * Meta informations extracted from the WSDL
     * - documentation: Destination city or off point, Ex “BLR”
     * - minOccurs: 0
     * @var string
     */
    public $ServiceCityDestination;
    /**
     * The RuleSet
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\RuleSet
     */
    public $RuleSet;
    /**
     * The Segment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Segment
     */
    public $Segment;
    /**
     * The TravelPortions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\TravelPortions
     */
    public $TravelPortions;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: "id" is used to return the id of AncillaryService
     * @var string
     */
    public $id;
    /**
     * The SequenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SequenceNumber" is used to return the sequence number of AncillaryService
     * @var string
     */
    public $SequenceNumber;
    /**
     * The NameNumber
     * Meta informations extracted from the WSDL
     * - documentation: "NameNumber" is used to return the passenger name number associated with the particular seat reservation
     * - use: optional
     * @var string
     */
    public $NameNumber;
    /**
     * The SegmentNumber
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentNumber" is used to return the itinerary segment number.
     * - use: optional
     * @var string
     */
    public $SegmentNumber;
    /**
     * The NumberOfItems
     * Meta informations extracted from the WSDL
     * - documentation: "NumberOfItems" is is used to return number of items being requested/sold
     * - use: optional
     * @var string
     */
    public $NumberOfItems;
    /**
     * The ActionCode
     * Meta informations extracted from the WSDL
     * - documentation: "ActionCode" is used to return the request status
     * - use: optional
     * @var string
     */
    public $ActionCode;
    /**
     * The SegmentIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "SegmentIndicator" is used to indicates if ancillary service is associated with particular segment or more than one segment.
     * - use: optional
     * @var string
     */
    public $SegmentIndicator;
    /**
     * The FirstTravelDate
     * Meta informations extracted from the WSDL
     * - documentation: "FirstTravelDate" is used to indicates the earliest travel date permitted for the service being processed
     * - use: optional
     * @var string
     */
    public $FirstTravelDate;
    /**
     * The LastTravelDate
     * Meta informations extracted from the WSDL
     * - documentation: "LastTravelDate" is used to indicate the last travel date permitted for the service being processed.
     * - use: optional
     * @var string
     */
    public $LastTravelDate;
    /**
     * The BookingIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "BookingIndicator" is used to indicates booking method requirement e.g. carrier must be contacted. If blank then there is no specific booking requirement.
     * - use: optional
     * @var string
     */
    public $BookingIndicator;
    /**
     * The RefundIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "RefundIndicator" is used to indicate if refund is applicable or not. If left blank then it suggests that this indicator is not applicable for particular ancillary service.
     * - use: optional
     * @var string
     */
    public $RefundIndicator;
    /**
     * The CommisionIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "CommisionIndicator" is used to return if the ancillary service is commissionable. (service is commissionable),N(service is not commissionable). If left blank then it suggests that this indicator is not applicable for particular
     * ancillary service
     * - use: optional
     * @var string
     */
    public $CommisionIndicator;
    /**
     * The InterlineIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "InterlineIndicator" indicates if ancillary service allows interline settlement. Y(service allows interline settlement),N(service doesn't allow interline settlement. If left blank then it suggests that this indicator is not
     * applicable for particular ancillary service
     * - use: optional
     * @var string
     */
    public $InterlineIndicator;
    /**
     * The FeeApplicationIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "FeeApplicationIndicator" is used to return if indicates if the fee is based on a flight segment, multiple flight segments or entire ticket
     * - use: optional
     * @var string
     */
    public $FeeApplicationIndicator;
    /**
     * The RefundFormIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "RefundFormIndicator" is used to return refund form applicable . Y(service is refundable),N(service is non-refundable)
     * - use: optional
     * @var string
     */
    public $RefundFormIndicator;
    /**
     * The FareGuaranteedIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "FareGuaranteedIndicator" is used to conform the if the fare is guaranteed.
     * - use: optional
     * @var string
     */
    public $FareGuaranteedIndicator;
    /**
     * The ServiceChargeIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "ServiceChargeIndicator" is the fee for the service
     * - use: optional
     * @var string
     */
    public $ServiceChargeIndicator;
    /**
     * The AdvancePurchaseIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "AdvancePurchaseIndicator" Specifies that the data in the record only applies when the service is purchased at the same time as the passenger's (travel) ticket is issued.
     * - use: optional
     * @var string
     */
    public $AdvancePurchaseIndicator;
    /**
     * The TaxIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "TaxIndicator" is used to return the Tax indicator details in the response
     * - use: optional
     * @var string
     */
    public $TaxIndicator;
    /**
     * The TicketingIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "TicketingIndicator" is used to return the ticketing indicator
     * - use: optional
     * @var string
     */
    public $TicketingIndicator;
    /**
     * The EmdPaperIndicator
     * Meta informations extracted from the WSDL
     * - documentation: "EmdPaperIndicator" is used to specify if it EMD or paper doc
     * - use: optional
     * @var string
     */
    public $EmdPaperIndicator;
    /**
     * The SeatRequestTransactionID
     * Meta informations extracted from the WSDL
     * - documentation: "SeatRequestTransactionID" is the transaction ID received from airlines regarding seat request
     * - use: optional
     * @var string
     */
    public $SeatRequestTransactionID;
    /**
     * Constructor method for AncillaryService
     * @uses AncillaryService::setRef()
     * @uses AncillaryService::setCommercialName()
     * @uses AncillaryService::setRficCode()
     * @uses AncillaryService::setRficSubcode()
     * @uses AncillaryService::setEMDNumber()
     * @uses AncillaryService::setEMDCoupon()
     * @uses AncillaryService::setSSRCode()
     * @uses AncillaryService::setProductText()
     * @uses AncillaryService::setOwningCarrierCode()
     * @uses AncillaryService::setSsimCode()
     * @uses AncillaryService::setVendor()
     * @uses AncillaryService::setEMDType()
     * @uses AncillaryService::setEquivalentPrice()
     * @uses AncillaryService::setTTLPrice()
     * @uses AncillaryService::setPortionOfTravelIndicator()
     * @uses AncillaryService::setOriginalBasePrice()
     * @uses AncillaryService::setPassengerTypeCode()
     * @uses AncillaryService::setBoardPoint()
     * @uses AncillaryService::setOffPoint()
     * @uses AncillaryService::setTaxesIncluded()
     * @uses AncillaryService::setTaxes()
     * @uses AncillaryService::setTicketCouponNumberAssociation()
     * @uses AncillaryService::setTotalOriginalBasePrice()
     * @uses AncillaryService::setTotalEquivalentPrice()
     * @uses AncillaryService::setTotalTTLPrice()
     * @uses AncillaryService::setTotalTaxes()
     * @uses AncillaryService::setFrequentFlyerTier()
     * @uses AncillaryService::setBookingSource()
     * @uses AncillaryService::setFeeWaiveReason()
     * @uses AncillaryService::setFulfillmentType()
     * @uses AncillaryService::setAaPayOriginalSeat()
     * @uses AncillaryService::setPdcSeat()
     * @uses AncillaryService::setEquipmentType()
     * @uses AncillaryService::setAaPayOptionalStatus()
     * @uses AncillaryService::setTTYConfirmationTimestamp()
     * @uses AncillaryService::setPurchaseTimestamp()
     * @uses AncillaryService::setBrandedFareId()
     * @uses AncillaryService::setGroupCode()
     * @uses AncillaryService::setTourCode()
     * @uses AncillaryService::setTicketUsedForEMDPricing()
     * @uses AncillaryService::setEMDConsummedAtIssuance()
     * @uses AncillaryService::setTaxExemption()
     * @uses AncillaryService::setPresentTo()
     * @uses AncillaryService::setAtCity()
     * @uses AncillaryService::setEndorsements()
     * @uses AncillaryService::setStationIndicator()
     * @uses AncillaryService::setServiceCity()
     * @uses AncillaryService::setServiceCityDestination()
     * @uses AncillaryService::setRuleSet()
     * @uses AncillaryService::setSegment()
     * @uses AncillaryService::setTravelPortions()
     * @uses AncillaryService::setId()
     * @uses AncillaryService::setSequenceNumber()
     * @uses AncillaryService::setNameNumber()
     * @uses AncillaryService::setSegmentNumber()
     * @uses AncillaryService::setNumberOfItems()
     * @uses AncillaryService::setActionCode()
     * @uses AncillaryService::setSegmentIndicator()
     * @uses AncillaryService::setFirstTravelDate()
     * @uses AncillaryService::setLastTravelDate()
     * @uses AncillaryService::setBookingIndicator()
     * @uses AncillaryService::setRefundIndicator()
     * @uses AncillaryService::setCommisionIndicator()
     * @uses AncillaryService::setInterlineIndicator()
     * @uses AncillaryService::setFeeApplicationIndicator()
     * @uses AncillaryService::setRefundFormIndicator()
     * @uses AncillaryService::setFareGuaranteedIndicator()
     * @uses AncillaryService::setServiceChargeIndicator()
     * @uses AncillaryService::setAdvancePurchaseIndicator()
     * @uses AncillaryService::setTaxIndicator()
     * @uses AncillaryService::setTicketingIndicator()
     * @uses AncillaryService::setEmdPaperIndicator()
     * @uses AncillaryService::setSeatRequestTransactionID()
     * @param string $ref
     * @param string $commercialName
     * @param string $rficCode
     * @param string $rficSubcode
     * @param string $eMDNumber
     * @param string $eMDCoupon
     * @param string $sSRCode
     * @param string $productText
     * @param string $owningCarrierCode
     * @param string $ssimCode
     * @param string $vendor
     * @param string $eMDType
     * @param \Sabre\TravelItineraryRead\Structs\EquivalentPrice $equivalentPrice
     * @param \Sabre\TravelItineraryRead\Structs\TTLPrice $tTLPrice
     * @param string $portionOfTravelIndicator
     * @param \Sabre\TravelItineraryRead\Structs\OriginalBasePrice $originalBasePrice
     * @param string $passengerTypeCode
     * @param string $boardPoint
     * @param string $offPoint
     * @param bool $taxesIncluded
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @param \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation[] $ticketCouponNumberAssociation
     * @param \Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice $totalOriginalBasePrice
     * @param \Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice $totalEquivalentPrice
     * @param \Sabre\TravelItineraryRead\Structs\TotalTTLPrice $totalTTLPrice
     * @param \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes
     * @param string $frequentFlyerTier
     * @param string $bookingSource
     * @param string $feeWaiveReason
     * @param string $fulfillmentType
     * @param string $aaPayOriginalSeat
     * @param string $pdcSeat
     * @param string $equipmentType
     * @param string $aaPayOptionalStatus
     * @param string $tTYConfirmationTimestamp
     * @param string $purchaseTimestamp
     * @param string $brandedFareId
     * @param string $groupCode
     * @param string $tourCode
     * @param string $ticketUsedForEMDPricing
     * @param string $eMDConsummedAtIssuance
     * @param string $taxExemption
     * @param string $presentTo
     * @param string $atCity
     * @param string $endorsements
     * @param string $stationIndicator
     * @param string $serviceCity
     * @param string $serviceCityDestination
     * @param \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet
     * @param \Sabre\TravelItineraryRead\Structs\Segment $segment
     * @param \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions
     * @param string $id
     * @param string $sequenceNumber
     * @param string $nameNumber
     * @param string $segmentNumber
     * @param string $numberOfItems
     * @param string $actionCode
     * @param string $segmentIndicator
     * @param string $firstTravelDate
     * @param string $lastTravelDate
     * @param string $bookingIndicator
     * @param string $refundIndicator
     * @param string $commisionIndicator
     * @param string $interlineIndicator
     * @param string $feeApplicationIndicator
     * @param string $refundFormIndicator
     * @param string $fareGuaranteedIndicator
     * @param string $serviceChargeIndicator
     * @param string $advancePurchaseIndicator
     * @param string $taxIndicator
     * @param string $ticketingIndicator
     * @param string $emdPaperIndicator
     * @param string $seatRequestTransactionID
     */
    public function __construct($ref = null, $commercialName = null, $rficCode = null, $rficSubcode = null, $eMDNumber = null, $eMDCoupon = null, $sSRCode = null, $productText = null, $owningCarrierCode = null, $ssimCode = null, $vendor = null, $eMDType = null, \Sabre\TravelItineraryRead\Structs\EquivalentPrice $equivalentPrice = null, \Sabre\TravelItineraryRead\Structs\TTLPrice $tTLPrice = null, $portionOfTravelIndicator = null, \Sabre\TravelItineraryRead\Structs\OriginalBasePrice $originalBasePrice = null, $passengerTypeCode = null, $boardPoint = null, $offPoint = null, $taxesIncluded = null, \Sabre\TravelItineraryRead\Structs\Taxes $taxes = null, array $ticketCouponNumberAssociation = array(), \Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice $totalOriginalBasePrice = null, \Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice $totalEquivalentPrice = null, \Sabre\TravelItineraryRead\Structs\TotalTTLPrice $totalTTLPrice = null, \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes = null, $frequentFlyerTier = null, $bookingSource = null, $feeWaiveReason = null, $fulfillmentType = null, $aaPayOriginalSeat = null, $pdcSeat = null, $equipmentType = null, $aaPayOptionalStatus = null, $tTYConfirmationTimestamp = null, $purchaseTimestamp = null, $brandedFareId = null, $groupCode = null, $tourCode = null, $ticketUsedForEMDPricing = null, $eMDConsummedAtIssuance = null, $taxExemption = null, $presentTo = null, $atCity = null, $endorsements = null, $stationIndicator = null, $serviceCity = null, $serviceCityDestination = null, \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet = null, \Sabre\TravelItineraryRead\Structs\Segment $segment = null, \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions = null, $id = null, $sequenceNumber = null, $nameNumber = null, $segmentNumber = null, $numberOfItems = null, $actionCode = null, $segmentIndicator = null, $firstTravelDate = null, $lastTravelDate = null, $bookingIndicator = null, $refundIndicator = null, $commisionIndicator = null, $interlineIndicator = null, $feeApplicationIndicator = null, $refundFormIndicator = null, $fareGuaranteedIndicator = null, $serviceChargeIndicator = null, $advancePurchaseIndicator = null, $taxIndicator = null, $ticketingIndicator = null, $emdPaperIndicator = null, $seatRequestTransactionID = null)
    {
        $this
            ->setRef($ref)
            ->setCommercialName($commercialName)
            ->setRficCode($rficCode)
            ->setRficSubcode($rficSubcode)
            ->setEMDNumber($eMDNumber)
            ->setEMDCoupon($eMDCoupon)
            ->setSSRCode($sSRCode)
            ->setProductText($productText)
            ->setOwningCarrierCode($owningCarrierCode)
            ->setSsimCode($ssimCode)
            ->setVendor($vendor)
            ->setEMDType($eMDType)
            ->setEquivalentPrice($equivalentPrice)
            ->setTTLPrice($tTLPrice)
            ->setPortionOfTravelIndicator($portionOfTravelIndicator)
            ->setOriginalBasePrice($originalBasePrice)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setBoardPoint($boardPoint)
            ->setOffPoint($offPoint)
            ->setTaxesIncluded($taxesIncluded)
            ->setTaxes($taxes)
            ->setTicketCouponNumberAssociation($ticketCouponNumberAssociation)
            ->setTotalOriginalBasePrice($totalOriginalBasePrice)
            ->setTotalEquivalentPrice($totalEquivalentPrice)
            ->setTotalTTLPrice($totalTTLPrice)
            ->setTotalTaxes($totalTaxes)
            ->setFrequentFlyerTier($frequentFlyerTier)
            ->setBookingSource($bookingSource)
            ->setFeeWaiveReason($feeWaiveReason)
            ->setFulfillmentType($fulfillmentType)
            ->setAaPayOriginalSeat($aaPayOriginalSeat)
            ->setPdcSeat($pdcSeat)
            ->setEquipmentType($equipmentType)
            ->setAaPayOptionalStatus($aaPayOptionalStatus)
            ->setTTYConfirmationTimestamp($tTYConfirmationTimestamp)
            ->setPurchaseTimestamp($purchaseTimestamp)
            ->setBrandedFareId($brandedFareId)
            ->setGroupCode($groupCode)
            ->setTourCode($tourCode)
            ->setTicketUsedForEMDPricing($ticketUsedForEMDPricing)
            ->setEMDConsummedAtIssuance($eMDConsummedAtIssuance)
            ->setTaxExemption($taxExemption)
            ->setPresentTo($presentTo)
            ->setAtCity($atCity)
            ->setEndorsements($endorsements)
            ->setStationIndicator($stationIndicator)
            ->setServiceCity($serviceCity)
            ->setServiceCityDestination($serviceCityDestination)
            ->setRuleSet($ruleSet)
            ->setSegment($segment)
            ->setTravelPortions($travelPortions)
            ->setId($id)
            ->setSequenceNumber($sequenceNumber)
            ->setNameNumber($nameNumber)
            ->setSegmentNumber($segmentNumber)
            ->setNumberOfItems($numberOfItems)
            ->setActionCode($actionCode)
            ->setSegmentIndicator($segmentIndicator)
            ->setFirstTravelDate($firstTravelDate)
            ->setLastTravelDate($lastTravelDate)
            ->setBookingIndicator($bookingIndicator)
            ->setRefundIndicator($refundIndicator)
            ->setCommisionIndicator($commisionIndicator)
            ->setInterlineIndicator($interlineIndicator)
            ->setFeeApplicationIndicator($feeApplicationIndicator)
            ->setRefundFormIndicator($refundFormIndicator)
            ->setFareGuaranteedIndicator($fareGuaranteedIndicator)
            ->setServiceChargeIndicator($serviceChargeIndicator)
            ->setAdvancePurchaseIndicator($advancePurchaseIndicator)
            ->setTaxIndicator($taxIndicator)
            ->setTicketingIndicator($ticketingIndicator)
            ->setEmdPaperIndicator($emdPaperIndicator)
            ->setSeatRequestTransactionID($seatRequestTransactionID);
    }
    /**
     * Get ref value
     * @return string|null
     */
    public function getRef()
    {
        return $this->ref;
    }
    /**
     * Set ref value
     * @param string $ref
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRef($ref = null)
    {
        $this->ref = $ref;
        return $this;
    }
    /**
     * Get CommercialName value
     * @return string|null
     */
    public function getCommercialName()
    {
        return $this->CommercialName;
    }
    /**
     * Set CommercialName value
     * @param string $commercialName
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setCommercialName($commercialName = null)
    {
        $this->CommercialName = $commercialName;
        return $this;
    }
    /**
     * Get RficCode value
     * @return string|null
     */
    public function getRficCode()
    {
        return $this->RficCode;
    }
    /**
     * Set RficCode value
     * @param string $rficCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRficCode($rficCode = null)
    {
        $this->RficCode = $rficCode;
        return $this;
    }
    /**
     * Get RficSubcode value
     * @return string|null
     */
    public function getRficSubcode()
    {
        return $this->RficSubcode;
    }
    /**
     * Set RficSubcode value
     * @param string $rficSubcode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRficSubcode($rficSubcode = null)
    {
        $this->RficSubcode = $rficSubcode;
        return $this;
    }
    /**
     * Get EMDNumber value
     * @return string|null
     */
    public function getEMDNumber()
    {
        return $this->EMDNumber;
    }
    /**
     * Set EMDNumber value
     * @param string $eMDNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEMDNumber($eMDNumber = null)
    {
        $this->EMDNumber = $eMDNumber;
        return $this;
    }
    /**
     * Get EMDCoupon value
     * @return string|null
     */
    public function getEMDCoupon()
    {
        return $this->EMDCoupon;
    }
    /**
     * Set EMDCoupon value
     * @param string $eMDCoupon
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEMDCoupon($eMDCoupon = null)
    {
        $this->EMDCoupon = $eMDCoupon;
        return $this;
    }
    /**
     * Get SSRCode value
     * @return string|null
     */
    public function getSSRCode()
    {
        return $this->SSRCode;
    }
    /**
     * Set SSRCode value
     * @param string $sSRCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSSRCode($sSRCode = null)
    {
        $this->SSRCode = $sSRCode;
        return $this;
    }
    /**
     * Get ProductText value
     * @return string|null
     */
    public function getProductText()
    {
        return $this->ProductText;
    }
    /**
     * Set ProductText value
     * @param string $productText
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setProductText($productText = null)
    {
        $this->ProductText = $productText;
        return $this;
    }
    /**
     * Get OwningCarrierCode value
     * @return string|null
     */
    public function getOwningCarrierCode()
    {
        return $this->OwningCarrierCode;
    }
    /**
     * Set OwningCarrierCode value
     * @param string $owningCarrierCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setOwningCarrierCode($owningCarrierCode = null)
    {
        $this->OwningCarrierCode = $owningCarrierCode;
        return $this;
    }
    /**
     * Get SsimCode value
     * @return string|null
     */
    public function getSsimCode()
    {
        return $this->SsimCode;
    }
    /**
     * Set SsimCode value
     * @param string $ssimCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSsimCode($ssimCode = null)
    {
        $this->SsimCode = $ssimCode;
        return $this;
    }
    /**
     * Get Vendor value
     * @return string|null
     */
    public function getVendor()
    {
        return $this->Vendor;
    }
    /**
     * Set Vendor value
     * @param string $vendor
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setVendor($vendor = null)
    {
        $this->Vendor = $vendor;
        return $this;
    }
    /**
     * Get EMDType value
     * @return string|null
     */
    public function getEMDType()
    {
        return $this->EMDType;
    }
    /**
     * Set EMDType value
     * @param string $eMDType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEMDType($eMDType = null)
    {
        $this->EMDType = $eMDType;
        return $this;
    }
    /**
     * Get EquivalentPrice value
     * @return \Sabre\TravelItineraryRead\Structs\EquivalentPrice|null
     */
    public function getEquivalentPrice()
    {
        return $this->EquivalentPrice;
    }
    /**
     * Set EquivalentPrice value
     * @param \Sabre\TravelItineraryRead\Structs\EquivalentPrice $equivalentPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEquivalentPrice(\Sabre\TravelItineraryRead\Structs\EquivalentPrice $equivalentPrice = null)
    {
        $this->EquivalentPrice = $equivalentPrice;
        return $this;
    }
    /**
     * Get TTLPrice value
     * @return \Sabre\TravelItineraryRead\Structs\TTLPrice|null
     */
    public function getTTLPrice()
    {
        return $this->TTLPrice;
    }
    /**
     * Set TTLPrice value
     * @param \Sabre\TravelItineraryRead\Structs\TTLPrice $tTLPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTTLPrice(\Sabre\TravelItineraryRead\Structs\TTLPrice $tTLPrice = null)
    {
        $this->TTLPrice = $tTLPrice;
        return $this;
    }
    /**
     * Get PortionOfTravelIndicator value
     * @return string|null
     */
    public function getPortionOfTravelIndicator()
    {
        return $this->PortionOfTravelIndicator;
    }
    /**
     * Set PortionOfTravelIndicator value
     * @param string $portionOfTravelIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setPortionOfTravelIndicator($portionOfTravelIndicator = null)
    {
        $this->PortionOfTravelIndicator = $portionOfTravelIndicator;
        return $this;
    }
    /**
     * Get OriginalBasePrice value
     * @return \Sabre\TravelItineraryRead\Structs\OriginalBasePrice|null
     */
    public function getOriginalBasePrice()
    {
        return $this->OriginalBasePrice;
    }
    /**
     * Set OriginalBasePrice value
     * @param \Sabre\TravelItineraryRead\Structs\OriginalBasePrice $originalBasePrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setOriginalBasePrice(\Sabre\TravelItineraryRead\Structs\OriginalBasePrice $originalBasePrice = null)
    {
        $this->OriginalBasePrice = $originalBasePrice;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get BoardPoint value
     * @return string|null
     */
    public function getBoardPoint()
    {
        return $this->BoardPoint;
    }
    /**
     * Set BoardPoint value
     * @param string $boardPoint
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setBoardPoint($boardPoint = null)
    {
        $this->BoardPoint = $boardPoint;
        return $this;
    }
    /**
     * Get OffPoint value
     * @return string|null
     */
    public function getOffPoint()
    {
        return $this->OffPoint;
    }
    /**
     * Set OffPoint value
     * @param string $offPoint
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setOffPoint($offPoint = null)
    {
        $this->OffPoint = $offPoint;
        return $this;
    }
    /**
     * Get TaxesIncluded value
     * @return bool|null
     */
    public function getTaxesIncluded()
    {
        return $this->TaxesIncluded;
    }
    /**
     * Set TaxesIncluded value
     * @param bool $taxesIncluded
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTaxesIncluded($taxesIncluded = null)
    {
        $this->TaxesIncluded = $taxesIncluded;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \Sabre\TravelItineraryRead\Structs\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \Sabre\TravelItineraryRead\Structs\Taxes $taxes
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTaxes(\Sabre\TravelItineraryRead\Structs\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Get TicketCouponNumberAssociation value
     * @return \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation[]|null
     */
    public function getTicketCouponNumberAssociation()
    {
        return $this->TicketCouponNumberAssociation;
    }
    /**
     * Set TicketCouponNumberAssociation value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation[] $ticketCouponNumberAssociation
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTicketCouponNumberAssociation(array $ticketCouponNumberAssociation = array())
    {
        $this->TicketCouponNumberAssociation = $ticketCouponNumberAssociation;
        return $this;
    }
    /**
     * Add item to TicketCouponNumberAssociation value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $item
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function addToTicketCouponNumberAssociation(\Sabre\TravelItineraryRead\Structs\TicketCouponNumberAssociation $item)
    {
        $this->TicketCouponNumberAssociation[] = $item;
        return $this;
    }
    /**
     * Get TotalOriginalBasePrice value
     * @return \Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice|null
     */
    public function getTotalOriginalBasePrice()
    {
        return $this->TotalOriginalBasePrice;
    }
    /**
     * Set TotalOriginalBasePrice value
     * @param \Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice $totalOriginalBasePrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTotalOriginalBasePrice(\Sabre\TravelItineraryRead\Structs\TotalOriginalBasePrice $totalOriginalBasePrice = null)
    {
        $this->TotalOriginalBasePrice = $totalOriginalBasePrice;
        return $this;
    }
    /**
     * Get TotalEquivalentPrice value
     * @return \Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice|null
     */
    public function getTotalEquivalentPrice()
    {
        return $this->TotalEquivalentPrice;
    }
    /**
     * Set TotalEquivalentPrice value
     * @param \Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice $totalEquivalentPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTotalEquivalentPrice(\Sabre\TravelItineraryRead\Structs\TotalEquivalentPrice $totalEquivalentPrice = null)
    {
        $this->TotalEquivalentPrice = $totalEquivalentPrice;
        return $this;
    }
    /**
     * Get TotalTTLPrice value
     * @return \Sabre\TravelItineraryRead\Structs\TotalTTLPrice|null
     */
    public function getTotalTTLPrice()
    {
        return $this->TotalTTLPrice;
    }
    /**
     * Set TotalTTLPrice value
     * @param \Sabre\TravelItineraryRead\Structs\TotalTTLPrice $totalTTLPrice
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTotalTTLPrice(\Sabre\TravelItineraryRead\Structs\TotalTTLPrice $totalTTLPrice = null)
    {
        $this->TotalTTLPrice = $totalTTLPrice;
        return $this;
    }
    /**
     * Get TotalTaxes value
     * @return \Sabre\TravelItineraryRead\Structs\TotalTaxes|null
     */
    public function getTotalTaxes()
    {
        return $this->TotalTaxes;
    }
    /**
     * Set TotalTaxes value
     * @param \Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTotalTaxes(\Sabre\TravelItineraryRead\Structs\TotalTaxes $totalTaxes = null)
    {
        $this->TotalTaxes = $totalTaxes;
        return $this;
    }
    /**
     * Get FrequentFlyerTier value
     * @return string|null
     */
    public function getFrequentFlyerTier()
    {
        return $this->FrequentFlyerTier;
    }
    /**
     * Set FrequentFlyerTier value
     * @param string $frequentFlyerTier
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFrequentFlyerTier($frequentFlyerTier = null)
    {
        $this->FrequentFlyerTier = $frequentFlyerTier;
        return $this;
    }
    /**
     * Get BookingSource value
     * @return string|null
     */
    public function getBookingSource()
    {
        return $this->BookingSource;
    }
    /**
     * Set BookingSource value
     * @param string $bookingSource
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setBookingSource($bookingSource = null)
    {
        $this->BookingSource = $bookingSource;
        return $this;
    }
    /**
     * Get FeeWaiveReason value
     * @return string|null
     */
    public function getFeeWaiveReason()
    {
        return $this->FeeWaiveReason;
    }
    /**
     * Set FeeWaiveReason value
     * @param string $feeWaiveReason
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFeeWaiveReason($feeWaiveReason = null)
    {
        $this->FeeWaiveReason = $feeWaiveReason;
        return $this;
    }
    /**
     * Get FulfillmentType value
     * @return string|null
     */
    public function getFulfillmentType()
    {
        return $this->FulfillmentType;
    }
    /**
     * Set FulfillmentType value
     * @param string $fulfillmentType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFulfillmentType($fulfillmentType = null)
    {
        $this->FulfillmentType = $fulfillmentType;
        return $this;
    }
    /**
     * Get AaPayOriginalSeat value
     * @return string|null
     */
    public function getAaPayOriginalSeat()
    {
        return $this->AaPayOriginalSeat;
    }
    /**
     * Set AaPayOriginalSeat value
     * @param string $aaPayOriginalSeat
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setAaPayOriginalSeat($aaPayOriginalSeat = null)
    {
        $this->AaPayOriginalSeat = $aaPayOriginalSeat;
        return $this;
    }
    /**
     * Get PdcSeat value
     * @return string|null
     */
    public function getPdcSeat()
    {
        return $this->PdcSeat;
    }
    /**
     * Set PdcSeat value
     * @param string $pdcSeat
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setPdcSeat($pdcSeat = null)
    {
        $this->PdcSeat = $pdcSeat;
        return $this;
    }
    /**
     * Get EquipmentType value
     * @return string|null
     */
    public function getEquipmentType()
    {
        return $this->EquipmentType;
    }
    /**
     * Set EquipmentType value
     * @param string $equipmentType
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEquipmentType($equipmentType = null)
    {
        $this->EquipmentType = $equipmentType;
        return $this;
    }
    /**
     * Get AaPayOptionalStatus value
     * @return string|null
     */
    public function getAaPayOptionalStatus()
    {
        return $this->AaPayOptionalStatus;
    }
    /**
     * Set AaPayOptionalStatus value
     * @param string $aaPayOptionalStatus
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setAaPayOptionalStatus($aaPayOptionalStatus = null)
    {
        $this->AaPayOptionalStatus = $aaPayOptionalStatus;
        return $this;
    }
    /**
     * Get TTYConfirmationTimestamp value
     * @return string|null
     */
    public function getTTYConfirmationTimestamp()
    {
        return $this->TTYConfirmationTimestamp;
    }
    /**
     * Set TTYConfirmationTimestamp value
     * @param string $tTYConfirmationTimestamp
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTTYConfirmationTimestamp($tTYConfirmationTimestamp = null)
    {
        $this->TTYConfirmationTimestamp = $tTYConfirmationTimestamp;
        return $this;
    }
    /**
     * Get PurchaseTimestamp value
     * @return string|null
     */
    public function getPurchaseTimestamp()
    {
        return $this->PurchaseTimestamp;
    }
    /**
     * Set PurchaseTimestamp value
     * @param string $purchaseTimestamp
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setPurchaseTimestamp($purchaseTimestamp = null)
    {
        $this->PurchaseTimestamp = $purchaseTimestamp;
        return $this;
    }
    /**
     * Get BrandedFareId value
     * @return string|null
     */
    public function getBrandedFareId()
    {
        return $this->BrandedFareId;
    }
    /**
     * Set BrandedFareId value
     * @param string $brandedFareId
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setBrandedFareId($brandedFareId = null)
    {
        $this->BrandedFareId = $brandedFareId;
        return $this;
    }
    /**
     * Get GroupCode value
     * @return string|null
     */
    public function getGroupCode()
    {
        return $this->GroupCode;
    }
    /**
     * Set GroupCode value
     * @param string $groupCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setGroupCode($groupCode = null)
    {
        $this->GroupCode = $groupCode;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTourCode($tourCode = null)
    {
        $this->TourCode = $tourCode;
        return $this;
    }
    /**
     * Get TicketUsedForEMDPricing value
     * @return string|null
     */
    public function getTicketUsedForEMDPricing()
    {
        return $this->TicketUsedForEMDPricing;
    }
    /**
     * Set TicketUsedForEMDPricing value
     * @param string $ticketUsedForEMDPricing
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTicketUsedForEMDPricing($ticketUsedForEMDPricing = null)
    {
        $this->TicketUsedForEMDPricing = $ticketUsedForEMDPricing;
        return $this;
    }
    /**
     * Get EMDConsummedAtIssuance value
     * @return string|null
     */
    public function getEMDConsummedAtIssuance()
    {
        return $this->EMDConsummedAtIssuance;
    }
    /**
     * Set EMDConsummedAtIssuance value
     * @uses \Sabre\TravelItineraryRead\Enums\EMDConsummedAtIssuance::valueIsValid()
     * @uses \Sabre\TravelItineraryRead\Enums\EMDConsummedAtIssuance::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eMDConsummedAtIssuance
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEMDConsummedAtIssuance($eMDConsummedAtIssuance = null)
    {
        $this->EMDConsummedAtIssuance = $eMDConsummedAtIssuance;
        return $this;
    }
    /**
     * Get TaxExemption value
     * @return string|null
     */
    public function getTaxExemption()
    {
        return $this->TaxExemption;
    }
    /**
     * Set TaxExemption value
     * @uses \Sabre\TravelItineraryRead\Enums\TaxExemption::valueIsValid()
     * @uses \Sabre\TravelItineraryRead\Enums\TaxExemption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $taxExemption
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTaxExemption($taxExemption = null)
    {
        $this->TaxExemption = $taxExemption;
        return $this;
    }
    /**
     * Get PresentTo value
     * @return string|null
     */
    public function getPresentTo()
    {
        return $this->PresentTo;
    }
    /**
     * Set PresentTo value
     * @param string $presentTo
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setPresentTo($presentTo = null)
    {
        $this->PresentTo = $presentTo;
        return $this;
    }
    /**
     * Get AtCity value
     * @return string|null
     */
    public function getAtCity()
    {
        return $this->AtCity;
    }
    /**
     * Set AtCity value
     * @param string $atCity
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setAtCity($atCity = null)
    {
        $this->AtCity = $atCity;
        return $this;
    }
    /**
     * Get Endorsements value
     * @return string|null
     */
    public function getEndorsements()
    {
        return $this->Endorsements;
    }
    /**
     * Set Endorsements value
     * @param string $endorsements
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEndorsements($endorsements = null)
    {
        $this->Endorsements = $endorsements;
        return $this;
    }
    /**
     * Get StationIndicator value
     * @return string|null
     */
    public function getStationIndicator()
    {
        return $this->StationIndicator;
    }
    /**
     * Set StationIndicator value
     * @uses \Sabre\TravelItineraryRead\Enums\StationIndicator::valueIsValid()
     * @uses \Sabre\TravelItineraryRead\Enums\StationIndicator::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $stationIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setStationIndicator($stationIndicator = null)
    {
        $this->StationIndicator = $stationIndicator;
        return $this;
    }
    /**
     * Get ServiceCity value
     * @return string|null
     */
    public function getServiceCity()
    {
        return $this->ServiceCity;
    }
    /**
     * Set ServiceCity value
     * @param string $serviceCity
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setServiceCity($serviceCity = null)
    {
        $this->ServiceCity = $serviceCity;
        return $this;
    }
    /**
     * Get ServiceCityDestination value
     * @return string|null
     */
    public function getServiceCityDestination()
    {
        return $this->ServiceCityDestination;
    }
    /**
     * Set ServiceCityDestination value
     * @param string $serviceCityDestination
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setServiceCityDestination($serviceCityDestination = null)
    {
        $this->ServiceCityDestination = $serviceCityDestination;
        return $this;
    }
    /**
     * Get RuleSet value
     * @return \Sabre\TravelItineraryRead\Structs\RuleSet|null
     */
    public function getRuleSet()
    {
        return $this->RuleSet;
    }
    /**
     * Set RuleSet value
     * @param \Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRuleSet(\Sabre\TravelItineraryRead\Structs\RuleSet $ruleSet = null)
    {
        $this->RuleSet = $ruleSet;
        return $this;
    }
    /**
     * Get Segment value
     * @return \Sabre\TravelItineraryRead\Structs\Segment|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * Set Segment value
     * @param \Sabre\TravelItineraryRead\Structs\Segment $segment
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSegment(\Sabre\TravelItineraryRead\Structs\Segment $segment = null)
    {
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Get TravelPortions value
     * @return \Sabre\TravelItineraryRead\Structs\TravelPortions|null
     */
    public function getTravelPortions()
    {
        return $this->TravelPortions;
    }
    /**
     * Set TravelPortions value
     * @param \Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTravelPortions(\Sabre\TravelItineraryRead\Structs\TravelPortions $travelPortions = null)
    {
        $this->TravelPortions = $travelPortions;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setId($id = null)
    {
        $this->id = $id;
        return $this;
    }
    /**
     * Get SequenceNumber value
     * @return string|null
     */
    public function getSequenceNumber()
    {
        return $this->SequenceNumber;
    }
    /**
     * Set SequenceNumber value
     * @param string $sequenceNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSequenceNumber($sequenceNumber = null)
    {
        $this->SequenceNumber = $sequenceNumber;
        return $this;
    }
    /**
     * Get NameNumber value
     * @return string|null
     */
    public function getNameNumber()
    {
        return $this->NameNumber;
    }
    /**
     * Set NameNumber value
     * @param string $nameNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setNameNumber($nameNumber = null)
    {
        $this->NameNumber = $nameNumber;
        return $this;
    }
    /**
     * Get SegmentNumber value
     * @return string|null
     */
    public function getSegmentNumber()
    {
        return $this->SegmentNumber;
    }
    /**
     * Set SegmentNumber value
     * @param string $segmentNumber
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSegmentNumber($segmentNumber = null)
    {
        $this->SegmentNumber = $segmentNumber;
        return $this;
    }
    /**
     * Get NumberOfItems value
     * @return string|null
     */
    public function getNumberOfItems()
    {
        return $this->NumberOfItems;
    }
    /**
     * Set NumberOfItems value
     * @param string $numberOfItems
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setNumberOfItems($numberOfItems = null)
    {
        $this->NumberOfItems = $numberOfItems;
        return $this;
    }
    /**
     * Get ActionCode value
     * @return string|null
     */
    public function getActionCode()
    {
        return $this->ActionCode;
    }
    /**
     * Set ActionCode value
     * @param string $actionCode
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setActionCode($actionCode = null)
    {
        $this->ActionCode = $actionCode;
        return $this;
    }
    /**
     * Get SegmentIndicator value
     * @return string|null
     */
    public function getSegmentIndicator()
    {
        return $this->SegmentIndicator;
    }
    /**
     * Set SegmentIndicator value
     * @param string $segmentIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSegmentIndicator($segmentIndicator = null)
    {
        $this->SegmentIndicator = $segmentIndicator;
        return $this;
    }
    /**
     * Get FirstTravelDate value
     * @return string|null
     */
    public function getFirstTravelDate()
    {
        return $this->FirstTravelDate;
    }
    /**
     * Set FirstTravelDate value
     * @param string $firstTravelDate
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFirstTravelDate($firstTravelDate = null)
    {
        $this->FirstTravelDate = $firstTravelDate;
        return $this;
    }
    /**
     * Get LastTravelDate value
     * @return string|null
     */
    public function getLastTravelDate()
    {
        return $this->LastTravelDate;
    }
    /**
     * Set LastTravelDate value
     * @param string $lastTravelDate
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setLastTravelDate($lastTravelDate = null)
    {
        $this->LastTravelDate = $lastTravelDate;
        return $this;
    }
    /**
     * Get BookingIndicator value
     * @return string|null
     */
    public function getBookingIndicator()
    {
        return $this->BookingIndicator;
    }
    /**
     * Set BookingIndicator value
     * @param string $bookingIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setBookingIndicator($bookingIndicator = null)
    {
        $this->BookingIndicator = $bookingIndicator;
        return $this;
    }
    /**
     * Get RefundIndicator value
     * @return string|null
     */
    public function getRefundIndicator()
    {
        return $this->RefundIndicator;
    }
    /**
     * Set RefundIndicator value
     * @param string $refundIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRefundIndicator($refundIndicator = null)
    {
        $this->RefundIndicator = $refundIndicator;
        return $this;
    }
    /**
     * Get CommisionIndicator value
     * @return string|null
     */
    public function getCommisionIndicator()
    {
        return $this->CommisionIndicator;
    }
    /**
     * Set CommisionIndicator value
     * @param string $commisionIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setCommisionIndicator($commisionIndicator = null)
    {
        $this->CommisionIndicator = $commisionIndicator;
        return $this;
    }
    /**
     * Get InterlineIndicator value
     * @return string|null
     */
    public function getInterlineIndicator()
    {
        return $this->InterlineIndicator;
    }
    /**
     * Set InterlineIndicator value
     * @param string $interlineIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setInterlineIndicator($interlineIndicator = null)
    {
        $this->InterlineIndicator = $interlineIndicator;
        return $this;
    }
    /**
     * Get FeeApplicationIndicator value
     * @return string|null
     */
    public function getFeeApplicationIndicator()
    {
        return $this->FeeApplicationIndicator;
    }
    /**
     * Set FeeApplicationIndicator value
     * @param string $feeApplicationIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFeeApplicationIndicator($feeApplicationIndicator = null)
    {
        $this->FeeApplicationIndicator = $feeApplicationIndicator;
        return $this;
    }
    /**
     * Get RefundFormIndicator value
     * @return string|null
     */
    public function getRefundFormIndicator()
    {
        return $this->RefundFormIndicator;
    }
    /**
     * Set RefundFormIndicator value
     * @param string $refundFormIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setRefundFormIndicator($refundFormIndicator = null)
    {
        $this->RefundFormIndicator = $refundFormIndicator;
        return $this;
    }
    /**
     * Get FareGuaranteedIndicator value
     * @return string|null
     */
    public function getFareGuaranteedIndicator()
    {
        return $this->FareGuaranteedIndicator;
    }
    /**
     * Set FareGuaranteedIndicator value
     * @param string $fareGuaranteedIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setFareGuaranteedIndicator($fareGuaranteedIndicator = null)
    {
        $this->FareGuaranteedIndicator = $fareGuaranteedIndicator;
        return $this;
    }
    /**
     * Get ServiceChargeIndicator value
     * @return string|null
     */
    public function getServiceChargeIndicator()
    {
        return $this->ServiceChargeIndicator;
    }
    /**
     * Set ServiceChargeIndicator value
     * @param string $serviceChargeIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setServiceChargeIndicator($serviceChargeIndicator = null)
    {
        $this->ServiceChargeIndicator = $serviceChargeIndicator;
        return $this;
    }
    /**
     * Get AdvancePurchaseIndicator value
     * @return string|null
     */
    public function getAdvancePurchaseIndicator()
    {
        return $this->AdvancePurchaseIndicator;
    }
    /**
     * Set AdvancePurchaseIndicator value
     * @param string $advancePurchaseIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setAdvancePurchaseIndicator($advancePurchaseIndicator = null)
    {
        $this->AdvancePurchaseIndicator = $advancePurchaseIndicator;
        return $this;
    }
    /**
     * Get TaxIndicator value
     * @return string|null
     */
    public function getTaxIndicator()
    {
        return $this->TaxIndicator;
    }
    /**
     * Set TaxIndicator value
     * @param string $taxIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTaxIndicator($taxIndicator = null)
    {
        $this->TaxIndicator = $taxIndicator;
        return $this;
    }
    /**
     * Get TicketingIndicator value
     * @return string|null
     */
    public function getTicketingIndicator()
    {
        return $this->TicketingIndicator;
    }
    /**
     * Set TicketingIndicator value
     * @param string $ticketingIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setTicketingIndicator($ticketingIndicator = null)
    {
        $this->TicketingIndicator = $ticketingIndicator;
        return $this;
    }
    /**
     * Get EmdPaperIndicator value
     * @return string|null
     */
    public function getEmdPaperIndicator()
    {
        return $this->EmdPaperIndicator;
    }
    /**
     * Set EmdPaperIndicator value
     * @param string $emdPaperIndicator
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setEmdPaperIndicator($emdPaperIndicator = null)
    {
        $this->EmdPaperIndicator = $emdPaperIndicator;
        return $this;
    }
    /**
     * Get SeatRequestTransactionID value
     * @return string|null
     */
    public function getSeatRequestTransactionID()
    {
        return $this->SeatRequestTransactionID;
    }
    /**
     * Set SeatRequestTransactionID value
     * @param string $seatRequestTransactionID
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public function setSeatRequestTransactionID($seatRequestTransactionID = null)
    {
        $this->SeatRequestTransactionID = $seatRequestTransactionID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AncillaryService
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
