<?php

namespace Sabre\TravelItineraryRead\Structs;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountingTransaction Structs
 * @subpackage Structs
 */
class AccountingTransaction extends AbstractStructBase
{
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Type;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Status;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - documentation: A date time type that forces both date and time to be specified. A year and seconds are allowed to be omitted. Example formats: "yyyy-mm-ddThh:mm:ss", "mm-ddThh:mm:ss", "mm-ddThh:mm", "yyyy-mm-ddThh:mm"
     * - pattern:
     * (((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-9])))|((((0[13578])|(1[02]))-31)|(((0[1,3-9])|(1[0-2]))-30)))|(((19|20)(([02468][048])|([13579][26]))-02-29))|((20[0-9][0-9])|(19[0-9][0-9]))-((((0[1-9])|(1[0-2]))-((0[1-9])|(1\d)|(2[0-8])))|((((0[13578])|(
     * 1[02]))-31)|(((0[1,3-9])|(1[0-2]))-(29|30)))))T([0-1][0-9]|[2][0-3])(:([0-5][0-9])){1,2}
     * @var string
     */
    public $Date;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem[]
     */
    public $Item;
    /**
     * The OriginatingLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OriginatingLocator;
    /**
     * The POS
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\POSType
     */
    public $POS;
    /**
     * The Payment
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \Sabre\TravelItineraryRead\Structs\Payment[]
     */
    public $Payment;
    /**
     * Constructor method for AccountingTransaction
     * @uses AccountingTransaction::setType()
     * @uses AccountingTransaction::setStatus()
     * @uses AccountingTransaction::setDate()
     * @uses AccountingTransaction::setItem()
     * @uses AccountingTransaction::setOriginatingLocator()
     * @uses AccountingTransaction::setPOS()
     * @uses AccountingTransaction::setPayment()
     * @param string $type
     * @param string $status
     * @param string $date
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem[] $item
     * @param string $originatingLocator
     * @param \Sabre\TravelItineraryRead\Structs\POSType $pOS
     * @param \Sabre\TravelItineraryRead\Structs\Payment[] $payment
     */
    public function __construct($type = null, $status = null, $date = null, array $item = array(), $originatingLocator = null, \Sabre\TravelItineraryRead\Structs\POSType $pOS = null, array $payment = array())
    {
        $this
            ->setType($type)
            ->setStatus($status)
            ->setDate($date)
            ->setItem($item)
            ->setOriginatingLocator($originatingLocator)
            ->setPOS($pOS)
            ->setPayment($payment);
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setStatus($status = null)
    {
        $this->Status = $status;
        return $this;
    }
    /**
     * Get Date value
     * @return string
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setDate($date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Item value
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem[]
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem[] $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setItem(array $item = array())
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Add item to Item value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\AccountingTransactionItem $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function addToItem(\Sabre\TravelItineraryRead\Structs\AccountingTransactionItem $item)
    {
        $this->Item[] = $item;
        return $this;
    }
    /**
     * Get OriginatingLocator value
     * @return string|null
     */
    public function getOriginatingLocator()
    {
        return $this->OriginatingLocator;
    }
    /**
     * Set OriginatingLocator value
     * @param string $originatingLocator
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setOriginatingLocator($originatingLocator = null)
    {
        $this->OriginatingLocator = $originatingLocator;
        return $this;
    }
    /**
     * Get POS value
     * @return \Sabre\TravelItineraryRead\Structs\POSType|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \Sabre\TravelItineraryRead\Structs\POSType $pOS
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setPOS(\Sabre\TravelItineraryRead\Structs\POSType $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Payment value
     * @return \Sabre\TravelItineraryRead\Structs\Payment[]|null
     */
    public function getPayment()
    {
        return $this->Payment;
    }
    /**
     * Set Payment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Payment[] $payment
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function setPayment(array $payment = array())
    {
        $this->Payment = $payment;
        return $this;
    }
    /**
     * Add item to Payment value
     * @throws \InvalidArgumentException
     * @param \Sabre\TravelItineraryRead\Structs\Payment $item
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public function addToPayment(\Sabre\TravelItineraryRead\Structs\Payment $item)
    {
        $this->Payment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Sabre\TravelItineraryRead\Structs\AccountingTransaction
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
